/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ukraine.model.helpers;

import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.ukraine.booking.UkraineTransportationType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AirProductHelper {
    private static final Logger log = LoggerFactory.getLogger(AirProductHelper.class);
    private static final String UKRAINE = "UA";
    public static final List<String> UKRAINE_FOR_RULES = Collections.singletonList("UA");
    private static final List<String> SUBREGIONAL_COUNTRIES = Arrays.asList("RU", "BY", "MD", "AM", "AZ", "GE");
    private static final List<String> SUBREGIONAL_COUNTRIES_FOR_RULES;
    private static final List<String> REGIONAL_COUNTRIES;
    private static final List<String> REGIONAL_COUNTRIES_FOR_RULES;
    public static final String CIS = "CIS";
    public static final String EURO = "EURO";

    public static BigDecimal calculateTotalVendorEquivalentFare(Product product) {
        BigDecimal totalVendorEquivalentFare = com.gridnine.xtrip.common.model.helpers.AirProductHelper.calculateTotalEquivalentFare((Product)product);
        BigDecimal vendorFeesEquivalentAmount = com.gridnine.xtrip.common.model.helpers.AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)com.gridnine.xtrip.common.model.helpers.AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null));
        if (vendorFeesEquivalentAmount != null) {
            totalVendorEquivalentFare = totalVendorEquivalentFare != null ? totalVendorEquivalentFare.add(vendorFeesEquivalentAmount) : vendorFeesEquivalentAmount;
        }
        return totalVendorEquivalentFare;
    }

    public static BigDecimal calculateTotalVendorAddCollect(Product product, BigDecimal addCollectEquivalent, BigDecimal addCollectTaxes) {
        BigDecimal result = (addCollectEquivalent != null ? addCollectEquivalent : BigDecimal.ZERO).add(addCollectTaxes != null ? addCollectTaxes : BigDecimal.ZERO);
        BigDecimal vendorFeesEquivalentAmount = com.gridnine.xtrip.common.model.helpers.AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)com.gridnine.xtrip.common.model.helpers.AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.VENDOR), (Set)GeneralProductHelper.feePropertyTypes, null, null));
        if (vendorFeesEquivalentAmount != null) {
            result = result != null ? result.add(vendorFeesEquivalentAmount) : vendorFeesEquivalentAmount;
        }
        return result;
    }

    public static BigDecimal calculateTotalClientEquivalentFare(Product product) {
        BigDecimal totalClientEquivalentFare = com.gridnine.xtrip.common.model.helpers.AirProductHelper.calculateTotalEquivalentFare((Product)product);
        BigDecimal clientFeesEquivalentAmount = com.gridnine.xtrip.common.model.helpers.AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)com.gridnine.xtrip.common.model.helpers.AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null));
        if (clientFeesEquivalentAmount != null) {
            totalClientEquivalentFare = totalClientEquivalentFare != null ? totalClientEquivalentFare.add(clientFeesEquivalentAmount) : clientFeesEquivalentAmount;
        }
        return totalClientEquivalentFare;
    }

    public static BigDecimal calculateTotalClientAddCollect(Product product, BigDecimal addCollectEquivalent, BigDecimal addCollectTaxes) {
        BigDecimal result = (addCollectEquivalent != null ? addCollectEquivalent : BigDecimal.ZERO).add(addCollectTaxes != null ? addCollectTaxes : BigDecimal.ZERO);
        BigDecimal clientFeesEquivalentAmount = com.gridnine.xtrip.common.model.helpers.AirProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions((Collection)com.gridnine.xtrip.common.model.helpers.AirProductHelper.getUnmodifiableCommissions((Product)product, (ContractType)ContractType.CLIENT), (Set)GeneralProductHelper.feePropertyTypes, null, null));
        if (clientFeesEquivalentAmount != null) {
            result = result != null ? result.add(clientFeesEquivalentAmount) : clientFeesEquivalentAmount;
        }
        return result;
    }

    public static String getTransportationTypeTitle(Product product) {
        log.debug("calculateTransportationType START");
        if (product == null) {
            return null;
        }
        UkraineTransportationType transportationType = AirProductHelper.getTransportationType(product);
        return transportationType == null ? "?" : transportationType.toString();
    }

    public static UkraineTransportationType getTransportationType(Product product) {
        ArrayList<String[]> codes = new ArrayList<String[]>();
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment seg : segmentTariff.getSegments()) {
                DictionaryReference arriveLocationReference = seg.getArriveLocation();
                DictionaryReference departureLocationReference = seg.getDepartureLocation();
                codes.add(DictHelper.getCodeVariants((DictionaryReference)arriveLocationReference, Collections.singletonList(CodeSystem.IATA), (boolean)false, (boolean)true, (boolean)true).toArray(new String[0]));
                codes.add(DictHelper.getCodeVariants((DictionaryReference)departureLocationReference, Collections.singletonList(CodeSystem.IATA), (boolean)false, (boolean)true, (boolean)true).toArray(new String[0]));
            }
        }
        return AirProductHelper.getTransportationType(codes);
    }

    public static UkraineTransportationType getTransportationType(List<String[]> segmentCodes) {
        if (segmentCodes.isEmpty()) {
            return null;
        }
        if (RulesHelper.confinedTo(segmentCodes, UKRAINE_FOR_RULES)) {
            return UkraineTransportationType.DOMESTIC;
        }
        if (RulesHelper.confinedTo(segmentCodes, SUBREGIONAL_COUNTRIES_FOR_RULES)) {
            return UkraineTransportationType.SUBREGIONAL;
        }
        if (RulesHelper.confinedTo(segmentCodes, REGIONAL_COUNTRIES_FOR_RULES)) {
            return UkraineTransportationType.REGIONAL;
        }
        return UkraineTransportationType.INTERCONTINENTAL;
    }

    public static String getTransportationTypeTitleForXmlReport(Product product) {
        String ukraine = UKRAINE;
        String cis = CIS;
        String euro = EURO;
        Logger log = LoggerFactory.getLogger(AirProductHelper.class);
        if (product == null) {
            return null;
        }
        log.debug("calculateTransportationType START");
        ArrayList<String[]> codes = new ArrayList<String[]>();
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment seg : segmentTariff.getSegments()) {
                DictionaryReference arriveLocationReference = seg.getArriveLocation();
                DictionaryReference departureLocationReference = seg.getDepartureLocation();
                codes.add(DictHelper.getCodeVariants((DictionaryReference)arriveLocationReference, Arrays.asList(CodeSystem.IATA), (boolean)false, (boolean)true, (boolean)true).toArray(new String[0]));
                codes.add(DictHelper.getCodeVariants((DictionaryReference)departureLocationReference, Arrays.asList(CodeSystem.IATA), (boolean)false, (boolean)true, (boolean)true).toArray(new String[0]));
            }
        }
        if (codes.isEmpty()) {
            return "?";
        }
        if (RulesHelper.confinedTo(codes, Arrays.asList(ukraine))) {
            return "\u0423\u043a\u0440\u0430\u0438\u043d\u0430";
        }
        if (!RulesHelper.confinedTo(codes, Arrays.asList(ukraine)) && RulesHelper.confinedTo(codes, Arrays.asList(cis))) {
            return "\u0421\u041d\u0413";
        }
        if (!RulesHelper.confinedTo(codes, Arrays.asList(cis)) && RulesHelper.confinedTo(codes, Arrays.asList(cis + "-" + euro))) {
            return "\u0415\u0432\u0440\u043e\u043f\u0430";
        }
        if (!RulesHelper.confinedTo(codes, Arrays.asList(cis + "-" + euro))) {
            return "\u0418\u043d\u0442\u0435\u0440\u043a\u043e\u043d\u0442\u0438\u043d\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e\u0435";
        }
        return "?";
    }

    static {
        REGIONAL_COUNTRIES = Arrays.asList("AL", "AD", "AT", "BE", "BA", "BG", "HR", "CZ", "DK", "EE", "FI", "FR", "DE", "GI", "GR", "HU", "IS", "IE", "IT", "LV", "LI", "LT", "LU", "MK", "MT", "MC", "ME", "NL", "NO", "PL", "PT", "RO", "RS", "SK", "SI", "ES", "SE", "CH", "GB", "VA", "DZ", "CY", "KZ", "MA", "SM", "TN", "TR");
        ArrayList<String> temp = new ArrayList<String>(UKRAINE_FOR_RULES);
        temp.addAll(SUBREGIONAL_COUNTRIES);
        SUBREGIONAL_COUNTRIES_FOR_RULES = Collections.singletonList(TextUtil.join((String)"-", temp));
        temp.addAll(REGIONAL_COUNTRIES);
        REGIONAL_COUNTRIES_FOR_RULES = Collections.singletonList(TextUtil.join((String)"-", temp));
    }
}

