/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp;

import com.gridnine.xtrip.common.ibecorp.model.helpers.TravelPolicyAuthorizationHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.WorkflowStatus;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class CommonIbecorpHelper {
    public static final String SHIPMENT_RECONCILIATION_REPORT_TEMPLATE_UID = "SHIPMENT_RECONCILIATION_REPORT_TEMPLATE_UID";
    public static final String RAKETA_EXTERNAL_SYSTEM_CODE = "RAKETA";
    public static final String EXT_API_DATA_SOURCE = "ext-api";

    public static Money createMoney(BigDecimal value) {
        Money money = new Money();
        money.setCurrency(DictHelper.getLocalCurrency());
        money.setValue(value);
        return money;
    }

    public static RuleSet getRules(EntityReference<SMSite> siteRef) {
        EntityContainer siteCtr = EntityStorage.get().resolve(siteRef);
        if (siteCtr == null) {
            return new RuleSet();
        }
        EntityContainer rulesCtr = EntityStorage.get().resolve(((SMSite)siteCtr.getEntity()).getRules());
        if (rulesCtr == null) {
            return new RuleSet();
        }
        return (RuleSet)MiscUtil.guarded((Object)((RulesHolder)rulesCtr.getEntity()).getRuleSet(), RuleSet::new);
    }

    public static SearchQuery initSearchQuery(EntityReference<Organization> supplierRef, EntityReference<Organization> customerRef, ContractType contractType, boolean isNewContract) {
        SearchQuery query = new SearchQuery();
        if (!isNewContract) {
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), (Object)false), SearchCriterion.eq((String)ContractCustomerIndex.Property.newModel.name(), null)}));
        } else {
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.newModel.name(), (Object)true));
        }
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)contractType));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), supplierRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), customerRef));
        Date now = new Date();
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.startDate.name(), null), SearchCriterion.le((String)ContractCustomerIndex.Property.startDate.name(), (Object)MiscUtil.setDayEndTime((Date)now))}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)ContractCustomerIndex.Property.endDate.name(), null), SearchCriterion.ge((String)ContractCustomerIndex.Property.endDate.name(), (Object)MiscUtil.clearTime((Date)now))}));
        query.getPreferredProperties().add("containerUid");
        return query;
    }

    public static boolean isContractPresent(EntityReference<Organization> supplierRef, EntityReference<Organization> customerRef, ContractType contractType) {
        SearchQuery query = CommonIbecorpHelper.initSearchQuery(supplierRef, customerRef, contractType, true);
        query.setLimit(1);
        List newContracts = EntityStorage.get().search(ContractIndex.class, query).getData();
        if (CollectionUtil.isEmpty((Collection)newContracts)) {
            query = CommonIbecorpHelper.initSearchQuery(supplierRef, customerRef, contractType, false);
            query.setLimit(1);
            List oldContracts = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
            return !CollectionUtil.isEmpty((Collection)oldContracts);
        }
        return true;
    }

    public static List<Contract> getContracts(EntityReference<Organization> supplierRef, EntityReference<Organization> customerRef, ContractType contractType) {
        List<Contract> newModelContracts = CommonIbecorpHelper.getNewModelContracts(supplierRef, customerRef, contractType);
        if (!newModelContracts.isEmpty()) {
            return newModelContracts;
        }
        return CommonIbecorpHelper.getOldModelContracts(supplierRef, customerRef, contractType);
    }

    private static List<Contract> getOldModelContracts(EntityReference<Organization> supplierRef, EntityReference<Organization> customerRef, ContractType contractType) {
        SearchQuery query = CommonIbecorpHelper.initSearchQuery(supplierRef, customerRef, contractType, false);
        List data = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        if (data.isEmpty()) {
            return Collections.emptyList();
        }
        return data.stream().map(idx -> EntityStorage.get().resolve(idx.getSource())).map(EntityContainer::getEntity).collect(Collectors.toList());
    }

    private static List<Contract> getNewModelContracts(EntityReference<Organization> supplierRef, EntityReference<Organization> customerRef, ContractType contractType) {
        SearchQuery query = CommonIbecorpHelper.initSearchQuery(supplierRef, customerRef, contractType, true);
        List data = EntityStorage.get().search(ContractIndex.class, query).getData();
        if (data.isEmpty()) {
            return Collections.emptyList();
        }
        return data.stream().map(idx -> EntityStorage.get().resolve(idx.getSource())).map(EntityContainer::getEntity).collect(Collectors.toList());
    }

    public static boolean isOnlineReservation(Reservation reservation) {
        return reservation != null && reservation.isOnline();
    }

    public static boolean isOnlineBookingFile(BookingFile bookingFile) {
        return bookingFile != null && bookingFile.getReservations().stream().allMatch(CommonIbecorpHelper::isOnlineReservation);
    }

    public static ReservationStatus getReservationStatus(Reservation reservation) {
        return reservation.getStatus() != null ? reservation.getStatus() : CommonIbecorpHelper.calculateReservationStatus(reservation);
    }

    public static ReservationStatus calculateReservationStatus(Reservation reservation) {
        BookingFile bookingFile;
        ReservationStatus status = reservation.getStatus();
        if (null == status && (bookingFile = reservation.getBookingFile()) != null) {
            WorkflowStatus workflowStatus = bookingFile.getWorkflowStatus();
            if (WorkflowStatus.PAYED == workflowStatus) {
                return ReservationStatus.PAYED;
            }
            if (WorkflowStatus.ERROR == workflowStatus) {
                return ReservationStatus.ERROR;
            }
        }
        if (ReservationStatus.PAYED == status || ReservationStatus.ERROR == status) {
            return status;
        }
        Set lastStatusList = reservation.getProducts().stream().filter(p -> !(p instanceof ProductVoiding)).filter(p -> GeneralProductHelper.getHandler((BaseProduct)p).getNextProduct(p) == null).filter(p -> {
            ProductHandler ph = GeneralProductHelper.getHandler((BaseProduct)p);
            boolean cancelledMco = ph.getProductCategory(p) == ProductCategory.MCO && ph.getStatus(p) == ProductStatus.VOID_BOOKING;
            return !cancelledMco;
        }).map(p -> GeneralProductHelper.getHandler((BaseProduct)p).getStatus(p)).filter(Objects::nonNull).collect(Collectors.toSet());
        int size = lastStatusList.size();
        if (0 == size) {
            return null;
        }
        if (lastStatusList.contains(ProductStatus.VOID) || lastStatusList.contains(ProductStatus.VOID_BOOKING) || lastStatusList.contains(ProductStatus.VOID_INTENTION) || lastStatusList.contains(ProductStatus.VOID_REQUEST)) {
            lastStatusList.remove(ProductStatus.VOID);
            lastStatusList.remove(ProductStatus.VOID_BOOKING);
            lastStatusList.remove(ProductStatus.VOID_INTENTION);
            lastStatusList.remove(ProductStatus.VOID_REQUEST);
            size = lastStatusList.size();
            if (0 == size) {
                return ReservationStatus.CANCELED;
            }
        }
        if (1 == size) {
            if (lastStatusList.contains(ProductStatus.INTENTION)) {
                if (reservation.isProposal()) {
                    return ReservationStatus.PROPOSAL;
                }
                if (TravelPolicyAuthorizationHelper.isAuthorization(reservation)) {
                    return ReservationStatus.AUTHORIZATION;
                }
                return ReservationStatus.INTENTION;
            }
            if (lastStatusList.contains(ProductStatus.REQUEST)) {
                return ReservationStatus.REQUEST;
            }
            if (lastStatusList.contains(ProductStatus.BOOKING)) {
                return ReservationStatus.BOOKING;
            }
            if (lastStatusList.contains(ProductStatus.SELL)) {
                return ReservationStatus.ISSUED;
            }
            if (lastStatusList.contains(ProductStatus.REFUND)) {
                return ReservationStatus.REFUND;
            }
            if (lastStatusList.contains(ProductStatus.REJECT)) {
                return ReservationStatus.REJECT;
            }
        }
        if (2 == size && lastStatusList.contains(ProductStatus.SELL) && (lastStatusList.contains(ProductStatus.REFUND) || lastStatusList.contains(ProductStatus.REJECT))) {
            return ReservationStatus.ISSUED;
        }
        if (2 == size && lastStatusList.contains(ProductStatus.SELL) && lastStatusList.contains(ProductStatus.EXCHANGE)) {
            return ReservationStatus.EXCHANGE;
        }
        if (2 == size && lastStatusList.contains(ProductStatus.SELL) && lastStatusList.contains(ProductStatus.BOOKING)) {
            return ReservationStatus.BOOKING;
        }
        if (lastStatusList.contains(ProductStatus.REQUEST)) {
            return ReservationStatus.REQUEST;
        }
        return ReservationStatus.ERROR;
    }

    @Deprecated
    public static ReservationStatus getReservationStatus(BookingFile bookingFile) {
        if (null == bookingFile || bookingFile.getReservations().isEmpty()) {
            return null;
        }
        return CommonIbecorpHelper.getReservationStatus((Reservation)bookingFile.getReservations().get(0));
    }

    public static boolean mustHaveReasonCode(EntityReference<Organization> clientRef, TravelPolicyImpositionResult travelPolicyImpositionResult, ReasonCodeType type) {
        return CommonIbecorpHelper.mustHaveReasonCode(clientRef, travelPolicyImpositionResult, null, type);
    }

    public static boolean mustHaveReasonCode(EntityReference<Organization> clientRef, TravelPolicyImpositionResult travelPolicyImpositionResult1, TravelPolicyImpositionResult travelPolicyImpositionResult2, ReasonCodeType type) {
        if (travelPolicyImpositionResult1 != null || travelPolicyImpositionResult2 != null) {
            if (travelPolicyImpositionResult1 != null && travelPolicyImpositionResult1.isReasonCodeRequired()) {
                return true;
            }
            return travelPolicyImpositionResult2 != null && travelPolicyImpositionResult2.isReasonCodeRequired();
        }
        EntityContainer clientCtr = EntityStorage.get().resolve(clientRef);
        if (null == clientCtr) {
            return false;
        }
        return ((Organization)clientCtr.getEntity()).getReasonCodes().stream().anyMatch(r -> r.getType() == type);
    }

    public static boolean mustHaveKeyContact(TravelPolicyImpositionResult travelPolicyImpositionResult) {
        return travelPolicyImpositionResult != null && travelPolicyImpositionResult.isKeyContactsRequired();
    }

    public static boolean isIntentionCase(Reservation reservation) {
        return reservation.getProducts().stream().filter(Objects::nonNull).anyMatch(pr -> GeneralProductHelper.getStatus((BaseProduct)pr) == ProductStatus.INTENTION || GeneralProductHelper.getStatus((BaseProduct)pr) == ProductStatus.VOID_INTENTION);
    }

    public static SMSiteType getSiteType(Reservation res) {
        if (res.getBookingFile() == null) {
            return null;
        }
        EntityReference siteRef = res.getBookingFile().getSite();
        return CommonIbecorpHelper.getSiteType((EntityReference<SMSite>)siteRef);
    }

    public static SMSiteType getSiteType(EntityReference<SMSite> siteRef) {
        EntityContainer siteCtr = EntityStorage.get().resolve(siteRef);
        return siteCtr == null ? null : ((SMSite)siteCtr.getEntity()).getSiteType();
    }
}

