/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.AirlineCard;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.profile.SalesPointAirlineInfo;
import com.gridnine.xtrip.common.pg.AcceptedCardsProvider;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IbeCorpAcceptedCardsProvider
implements AcceptedCardsProvider {
    private Set<SalesPointAirlineInfo> getSalesPointAirlineInfo(String carrierCode, BookingFile bf) {
        EntityContainer siteCtr = EntityStorage.get().resolve(bf.getSite());
        if (siteCtr == null) {
            return Collections.emptySet();
        }
        EntityContainer rulesCtr = EntityStorage.get().resolve(((SMSite)siteCtr.getEntity()).getRules());
        if (rulesCtr == null) {
            return Collections.emptySet();
        }
        return ((RulesHolder)rulesCtr.getEntity()).getAirlineInfos().stream().filter(Objects::nonNull).filter(info -> info.getAirline() != null && MiscUtil.equals((Object)info.getAirline().getCode(), (Object)carrierCode)).collect(Collectors.toSet());
    }

    public Set<AirlineCard> getAcceptedCards(String carrierCode, BookingFile bf, EntityReference<Organization> agencyRef) {
        HashSet<AirlineCard> res = new HashSet<AirlineCard>();
        Set<SalesPointAirlineInfo> infos = this.getSalesPointAirlineInfo(carrierCode, bf);
        for (SalesPointAirlineInfo info : infos) {
            res.addAll(info.getAcceptableCards());
        }
        return res;
    }

    public Set<AirlineCard> getAcceptedCards(Product product) {
        return this.getAcceptedCards(product.getCarrier().getCode(), product.getReservation().getBookingFile(), (EntityReference<Organization>)AirProductHelper.getSubagency((Product)product));
    }

    public String getHint(String carrierCode, BookingFile bf, EntityReference<Organization> agencyRef) {
        Set<SalesPointAirlineInfo> infos = this.getSalesPointAirlineInfo(carrierCode, bf);
        for (SalesPointAirlineInfo info : infos) {
            if (TextUtil.isBlank((String)info.getHint())) continue;
            return info.getHint();
        }
        return "";
    }
}

