/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.correspondence.handlers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.correspondence.handlers.BaseIssueHandler;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueHandlersRegistry {
    private static final Logger m_log = LoggerFactory.getLogger(IssueHandlersRegistry.class);
    private final Map<String, BaseIssueHandler<? extends BaseIssue>> issueHandlers = new HashMap<String, BaseIssueHandler<? extends BaseIssue>>();

    public static IssueHandlersRegistry get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return (IssueHandlersRegistry)Environment.getPublished(IssueHandlersRegistry.class);
    }

    public BaseIssueHandler<BaseIssue> getHandler(Class<? extends BaseIssue> issueCls) throws NullPointerException {
        Objects.requireNonNull(issueCls);
        String issueClsName = issueCls.getName();
        BaseIssueHandler<BaseIssue> issueHandler = this.issueHandlers.get(issueClsName);
        if (Objects.isNull(issueHandler) && m_log.isWarnEnabled()) {
            m_log.warn("issue handler not found: issueClass=" + issueClsName);
        }
        return issueHandler;
    }

    public void registerHandler(BaseIssueHandler<? extends BaseIssue> issueHandler) throws RuntimeException {
        Objects.requireNonNull(issueHandler);
        Class<?> issueCls = issueHandler.getEntityClass();
        Objects.requireNonNull(issueCls);
        String issueClsName = issueCls.getName();
        if (this.issueHandlers.containsKey(issueClsName)) {
            String errorMessage = "duplicate handler registered for issueClass=" + issueClsName;
            if (m_log.isErrorEnabled()) {
                m_log.error(errorMessage);
            }
            throw new IllegalArgumentException(errorMessage);
        }
        if (m_log.isDebugEnabled()) {
            m_log.debug("registered issue handler " + issueHandler.getClass().getName() + " for issueClass=" + issueClsName);
        }
        this.issueHandlers.put(issueClsName, issueHandler);
    }

    private static final class Holder {
        private static final IssueHandlersRegistry INSTANCE = (IssueHandlersRegistry)Environment.getPublished(IssueHandlersRegistry.class);

        private Holder() {
        }
    }
}

