/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.model.helpers;

import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.midoffice.model.AncillaryFeeContractRelationData;
import com.gridnine.xtrip.common.midoffice.model.BaseAncillaryFee;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseCommission;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.SimpleTax;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructure;
import com.gridnine.xtrip.common.model.helpers.XtripPriceStructureHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class IbecorpPriceStructureHelper {
    public static Map<DictionaryReference<PassengerType>, XtripPriceStructure> calculatePriceStructure(Flight flight) {
        return IbecorpPriceStructureHelper.calculatePriceStructure(flight.getContractRelations());
    }

    public static Map<DictionaryReference<PassengerType>, XtripPriceStructure> calculatePriceStructure(Map<DictionaryReference<PassengerType>, List<GdsContractRelationData>> flightContractRelations) {
        HashMap<DictionaryReference<PassengerType>, XtripPriceStructure> result = new HashMap<DictionaryReference<PassengerType>, XtripPriceStructure>();
        flightContractRelations.entrySet().forEach(entry -> {
            GdsContractRelationData prevRelation = null;
            GdsContractRelationData clientRelation = null;
            for (GdsContractRelationData relation : (List)entry.getValue()) {
                ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
                if (contractType == ContractType.CLIENT) {
                    clientRelation = relation;
                    break;
                }
                prevRelation = relation;
            }
            XtripPriceStructure structure = new XtripPriceStructure();
            if (clientRelation != null) {
                structure.setProductPrice(MiscUtil.guarded((BigDecimal)clientRelation.getServiceData().getTotalPrice()));
                XtripPriceStructureHelper.updateFees((XtripPriceStructure)structure, (List)clientRelation.getCommissions(), (List)(prevRelation == null ? null : prevRelation.getCommissions()), (boolean)true);
                structure.getPriceDetalization().setFare(MiscUtil.guarded((BigDecimal)clientRelation.getServiceData().getDetalization().getFare()).add(clientRelation.getCommissions().stream().filter(f -> GeneralProductHelper.isHiddenFee((EntityReference)f.getCommissionProperties())).map(BaseCommission::getEquivalentAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)));
                BigDecimal taxes = clientRelation.getServiceData().getDetalization().getTaxes().stream().filter(t -> t.getAmount() != null).map(SimpleTax::getAmount).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                structure.getPriceDetalization().setTaxes(taxes);
            }
            result.put((DictionaryReference<PassengerType>)entry.getKey(), structure);
        });
        return result;
    }

    public static XtripPriceStructure calculatePriceStructure(BaseAncillaryFee ancillaryFee) {
        return IbecorpPriceStructureHelper.calculatePriceStructure(ancillaryFee.getContractRelations());
    }

    public static XtripPriceStructure calculatePriceStructure(List<AncillaryFeeContractRelationData> contractRelations) {
        AncillaryFeeContractRelationData prevRelation = null;
        AncillaryFeeContractRelationData clientRelation = null;
        for (AncillaryFeeContractRelationData relation : contractRelations) {
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
            if (contractType == ContractType.CLIENT) {
                clientRelation = relation;
                break;
            }
            prevRelation = relation;
        }
        XtripPriceStructure structure = new XtripPriceStructure();
        if (clientRelation != null) {
            structure.setProductPrice(MiscUtil.guarded((BigDecimal)clientRelation.getPrice()));
            XtripPriceStructureHelper.updateFees((XtripPriceStructure)structure, (List)clientRelation.getCommissions(), (List)(prevRelation == null ? null : prevRelation.getCommissions()), (boolean)true);
        }
        return structure;
    }
}

