/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.model.helpers;

import com.gridnine.xtrip.common.ibecorp.gds.model.OrganizationAirlineSettings;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.NotificationType;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfile;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfileIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMAccessSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMBookingControlSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMGeneralSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMNotificationsSettings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMProfileType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteIndex;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep1Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep2Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep3Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep4Settings;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMVisualSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclRole;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ProfileHelper {
    public static final String DEFAULT_SITE_UID = "default_site_uid";
    public static List<NotificationType> PERSON_NOTIFICATION_TYPES = Arrays.asList(NotificationType.RESERVATION_CREATED, NotificationType.RESERVATION_CANCELLED, NotificationType.INTENTION_CANCELLED, NotificationType.SERVICES_ISSUED, NotificationType.RESERVATION_VOIDED, NotificationType.PAYMENT_REFUND, NotificationType.RESERVATION_REQUEST_CREATED, NotificationType.RESERVATION_REQUEST_REJECTED, NotificationType.RESERVATION_REQUEST_CONFIRMED, NotificationType.VISA_INFORMATION, NotificationType.SERVICE_FEE_RECEIPT, NotificationType.RECEIPT_LINK, NotificationType.TIME_LIMIT_EXPIRING, NotificationType.TIME_LIMIT_CHANGED);

    public static EntityReference<SMSite> findB2bSite(EntityReference<Organization> organization) {
        EntityContainer organizationContainer = EntityStorage.get().resolve(organization);
        return organizationContainer != null ? ((Organization)organizationContainer.getEntity()).getB2bSite() : null;
    }

    public static EntityReference<SMSite> findB2cSite(EntityReference<Organization> organization) {
        EntityContainer organizationContainer = EntityStorage.get().resolve(organization);
        return organizationContainer != null ? ((Organization)organizationContainer.getEntity()).getB2cSite() : null;
    }

    public static EntityReference<BaseSMProfile> getProfile(EntityReference<SMSite> site, SMProfileType profileType) {
        if (site != null) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.site.name(), site));
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseSMProfileIndex.Property.profileType.name(), (Object)profileType));
            List indexes = EntityStorage.get().search(BaseSMProfileIndex.class, query).getData();
            if (indexes.size() > 0) {
                return ((BaseSMProfileIndex)indexes.get(0)).getSource();
            }
        }
        return null;
    }

    public static SMProfileType getProfileType(BaseSMProfile profile) {
        if (profile instanceof SMGeneralSettings) {
            return SMProfileType.GENERAL_SETTINGS;
        }
        if (profile instanceof SMVisualSettings) {
            return SMProfileType.VISUAL_SETTINGS;
        }
        if (profile instanceof SMNotificationsSettings) {
            return SMProfileType.NOTIFICATIONS_SETTINGS;
        }
        if (profile instanceof SMStep1Settings) {
            return SMProfileType.STEP1_SETTINGS;
        }
        if (profile instanceof SMStep2Settings) {
            return SMProfileType.STEP2_SETTINGS;
        }
        if (profile instanceof SMStep3Settings) {
            return SMProfileType.STEP3_SETTINGS;
        }
        if (profile instanceof SMStep4Settings) {
            return SMProfileType.STEP4_SETTINGS;
        }
        if (profile instanceof SMAccessSettings) {
            return SMProfileType.ACCESS_SETTINGS;
        }
        if (profile instanceof SMBookingControlSettings) {
            return SMProfileType.BOOKING_CONTROL_SETTINGS;
        }
        return null;
    }

    public static Class<? extends BaseSMProfile> getProfileClass(SMProfileType type) {
        if (type == SMProfileType.GENERAL_SETTINGS) {
            return SMGeneralSettings.class;
        }
        if (type == SMProfileType.VISUAL_SETTINGS) {
            return SMVisualSettings.class;
        }
        if (type == SMProfileType.NOTIFICATIONS_SETTINGS) {
            return SMNotificationsSettings.class;
        }
        if (type == SMProfileType.STEP1_SETTINGS) {
            return SMStep1Settings.class;
        }
        if (type == SMProfileType.STEP2_SETTINGS) {
            return SMStep2Settings.class;
        }
        if (type == SMProfileType.STEP3_SETTINGS) {
            return SMStep3Settings.class;
        }
        if (type == SMProfileType.STEP4_SETTINGS) {
            return SMStep4Settings.class;
        }
        if (type == SMProfileType.ACCESS_SETTINGS) {
            return SMAccessSettings.class;
        }
        return null;
    }

    public static List<EntityReference<SMSite>> getOrganizationSites(List<EntityReference<Organization>> organizationReferences) throws Exception {
        ArrayList<EntityReference<SMSite>> sitesReferences = new ArrayList<EntityReference<SMSite>>();
        for (EntityReference<Organization> organizationReference : organizationReferences) {
            EntityReference site;
            EntityContainer organizationContainer = EntityStorage.get().resolve(organizationReference);
            if (organizationContainer == null || sitesReferences.contains(site = ((Organization)organizationContainer.getEntity()).getB2cSite())) continue;
            sitesReferences.add((EntityReference<SMSite>)site);
        }
        return sitesReferences;
    }

    public static List<EntityReference<BaseSMProfile>> getSiteSettings(List<EntityReference<SMSite>> sitesReferences) throws Exception {
        ArrayList<EntityReference<BaseSMProfile>> settingsReferences = new ArrayList<EntityReference<BaseSMProfile>>();
        SearchQuery searchQuery = new SearchQuery();
        List<SearchCriterion> criterions = sitesReferences.stream().map(item -> SearchCriterion.eq((String)BaseSMProfileIndex.Property.site.name(), (Object)item)).collect(Collectors.toList());
        if (criterions.size() == 0) {
            return Collections.emptyList();
        }
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])criterions.toArray(new SearchCriterion[criterions.size()])));
        List settingsIndexes = EntityStorage.get().search(BaseSMProfileIndex.class, searchQuery).getData();
        for (BaseSMProfileIndex settingsIndex : settingsIndexes) {
            settingsReferences.add((EntityReference<BaseSMProfile>)settingsIndex.getSource());
        }
        return settingsReferences;
    }

    public static List<EntityReference<RulesHolder>> getOrganizationRulesHolders(List<EntityReference<Organization>> organizationReferences) throws Exception {
        if (CollectionUtil.isEmpty(organizationReferences)) {
            return Collections.emptyList();
        }
        Object[] orgUids = organizationReferences.stream().filter(Objects::nonNull).map(EntityReference::getUid).filter(Objects::nonNull).toArray();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])orgUids));
        query.getPreferredProperties().add(OrganizationIndex.Property.b2cSite.name());
        query.getPreferredProperties().add(OrganizationIndex.Property.b2bSite.name());
        List orgIndexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        HashSet<String> siteUids = new HashSet<String>();
        for (OrganizationIndex index : orgIndexes) {
            if (index.getB2bSite() != null) {
                siteUids.add(index.getB2bSite().getUid());
            }
            if (index.getB2cSite() == null) continue;
            siteUids.add(index.getB2cSite().getUid());
        }
        if (CollectionUtil.isEmpty(siteUids)) {
            return Collections.emptyList();
        }
        query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)"containerUid", (Object[])siteUids.toArray()));
        query.getPreferredProperties().add(SMSiteIndex.Property.rules.name());
        List siteIndexes = EntityStorage.get().search(SMSiteIndex.class, query).getData();
        return siteIndexes.stream().map(SMSiteIndex::getRules).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<EntityReference<IbeCorpAclRole>> getOrganizationAclRoles(List<EntityReference<Organization>> organizationReferences) throws Exception {
        ArrayList<EntityReference<IbeCorpAclRole>> aclRolesReferences = new ArrayList<EntityReference<IbeCorpAclRole>>();
        for (EntityReference<Organization> organizationReference : organizationReferences) {
            EntityContainer organizationContainer = EntityStorage.get().resolve(organizationReference);
            if (organizationContainer == null) continue;
            for (EntityReference aclRoleReference : ((Organization)organizationContainer.getEntity()).getAclSettings().getOrganizationAclRoles()) {
                if (aclRoleReference == null || aclRolesReferences.contains(aclRoleReference)) continue;
                aclRolesReferences.add((EntityReference<IbeCorpAclRole>)aclRoleReference);
            }
        }
        return aclRolesReferences;
    }

    public static List<EntityReference<IbeCorpAclRole>> getPersonAclRoles(List<EntityReference<Person>> personReferences) {
        ArrayList<EntityReference<IbeCorpAclRole>> aclRoleReferences = new ArrayList<EntityReference<IbeCorpAclRole>>();
        ArrayList<Person> persons = new ArrayList<Person>();
        for (EntityReference<Person> personReference : personReferences) {
            Person person;
            EntityContainer personContainer = EntityStorage.get().resolve(personReference);
            if (personContainer == null || persons.contains(person = (Person)personContainer.getEntity())) continue;
            persons.add(person);
        }
        for (Person person : persons) {
            EntityReference aclRoleReference = person.getAclSettings().getAclRole();
            if (aclRoleReference == null || aclRoleReferences.contains(aclRoleReference)) continue;
            aclRoleReferences.add((EntityReference<IbeCorpAclRole>)aclRoleReference);
        }
        return aclRoleReferences;
    }

    public static List<EntityReference<BaseSystemSettings>> getOrganizationsAirlineSettings(List<EntityReference<Organization>> organizationReferences) throws Exception {
        ArrayList<EntityReference<BaseSystemSettings>> settings = new ArrayList<EntityReference<BaseSystemSettings>>();
        for (EntityReference<Organization> organizationReference : organizationReferences) {
            settings.addAll(ProfileHelper.getOrganizationAirlineSettings(organizationReference));
        }
        return settings;
    }

    public static List<EntityReference<BaseSystemSettings>> getOrganizationAirlineSettings(EntityReference<Organization> organizationReference) {
        ArrayList<EntityReference<BaseSystemSettings>> settings = new ArrayList<EntityReference<BaseSystemSettings>>();
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicSystemSettingsIndex.Property.type.name(), (Object)SystemSettingsType.ORGANIZATION_AIRLINE_SETTINGS));
        List systemSettingsIndexes = EntityStorage.get().search(BasicSystemSettingsIndex.class, query).getData();
        for (BasicSystemSettingsIndex systemSettingsIndex : systemSettingsIndexes) {
            BaseSystemSettings systemsSettings;
            EntityContainer systemSettingsContainer = EntityStorage.get().resolve(systemSettingsIndex.getSource());
            if (systemSettingsContainer == null || !((systemsSettings = (BaseSystemSettings)systemSettingsContainer.getEntity()) instanceof OrganizationAirlineSettings) || !MiscUtil.equals((Object)((OrganizationAirlineSettings)systemsSettings).getOrganization(), organizationReference)) continue;
            settings.add((EntityReference<BaseSystemSettings>)systemSettingsContainer.toReference());
        }
        return settings;
    }
}

