/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyApplicable;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStatus;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationStepParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyAuthorizationUnitParameters;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyImpositionResult;
import com.gridnine.xtrip.common.model.travelPolicy.TravelPolicyUnitAuthorization;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TravelPolicyAuthorizationHelper {
    private static final List<TravelPolicyAuthorizationStatus> AUTHORIZATION_STATUS_SORT_ORDER = Arrays.asList(TravelPolicyAuthorizationStatus.ABORTED, TravelPolicyAuthorizationStatus.CANCELED, TravelPolicyAuthorizationStatus.REFUSED, TravelPolicyAuthorizationStatus.DELETED, TravelPolicyAuthorizationStatus.EXPIRED, TravelPolicyAuthorizationStatus.WAIT, TravelPolicyAuthorizationStatus.APPROVED, TravelPolicyAuthorizationStatus.COMPLETED);

    public static boolean needSendToAuthorization(Reservation reservation) {
        return reservation.getProducts().stream().anyMatch(TravelPolicyAuthorizationHelper::needSendToAuthorization);
    }

    public static boolean needSendToAuthorization(BaseProduct product) {
        TravelPolicyAuthorizationStatus status = TravelPolicyAuthorizationHelper.getAuthorizationStatus(product);
        return (status == null || status == TravelPolicyAuthorizationStatus.APPROVED) && TravelPolicyAuthorizationHelper.isAuthorization(product) && !TravelPolicyAuthorizationHelper.getNeedAuthorizationNextStepUnits(product).isEmpty();
    }

    public static TravelPolicyAuthorizationParameters getTravelPolicyAuthorizationParameters(BaseProduct product) {
        return Optional.ofNullable(TravelPolicyAuthorizationHelper.getTravelPolicyImpositionResult(product)).map(TravelPolicyImpositionResult::getAuthorizationParameters).orElse(null);
    }

    public static boolean isAuthorization(Reservation reservation) {
        return reservation.getProducts().stream().anyMatch(TravelPolicyAuthorizationHelper::isAuthorization);
    }

    public static boolean isAuthorization(BaseProduct product) {
        return !product.getReservation().isProposal() && TravelPolicyAuthorizationHelper.getAuthorizationStatus(product) != TravelPolicyAuthorizationStatus.COMPLETED && Optional.ofNullable(TravelPolicyAuthorizationHelper.getTravelPolicyAuthorizationParameters(product)).isPresent();
    }

    public static boolean hasAuthorization(Reservation reservation) {
        return reservation.getProducts().stream().anyMatch(TravelPolicyAuthorizationHelper::hasAuthorization);
    }

    public static boolean hasAuthorization(BaseProduct product) {
        return !product.getReservation().isProposal() && Optional.ofNullable(TravelPolicyAuthorizationHelper.getTravelPolicyAuthorizationParameters(product)).isPresent();
    }

    public static boolean isAuthorizationStarted(BaseProduct product) {
        return TravelPolicyAuthorizationHelper.hasAuthorization(product) && TravelPolicyAuthorizationHelper.getAuthorizationStatus(product) != null;
    }

    public static TravelPolicyImpositionResult getTravelPolicyImpositionResult(BaseProduct product) {
        return Optional.ofNullable(product).filter(TravelPolicyApplicable.class::isInstance).map(TravelPolicyApplicable.class::cast).map(TravelPolicyApplicable::getTravelPolicyImpositionResult).orElse(null);
    }

    public static Integer findTimeLimit(BaseProduct product) {
        return TravelPolicyAuthorizationHelper.getCurrentAuthorizationUnits(product).stream().map(TravelPolicyAuthorizationUnitParameters::getTimeLimit).filter(Objects::nonNull).min(Integer::compareTo).orElse(null);
    }

    public static BigDecimal findPricingDelta(Reservation reservation) {
        return reservation.getProducts().stream().map(TravelPolicyAuthorizationHelper::getAuthorizationSteps).flatMap(Collection::stream).map(TravelPolicyAuthorizationStepParameters::getUnits).flatMap(Collection::stream).filter(Objects::nonNull).map(TravelPolicyAuthorizationUnitParameters::getPriceLimitPercent).filter(Objects::nonNull).min(BigDecimal::compareTo).orElse(null);
    }

    public static TravelPolicyAuthorizationStatus getAuthorizationStatus(Reservation reservation) {
        return TravelPolicyAuthorizationHelper.getStatus(reservation.getProducts().stream());
    }

    private static TravelPolicyAuthorizationStatus getStatus(Stream<BaseProduct> products) {
        return products.map(TravelPolicyAuthorizationHelper::getAuthorizationStatus).filter(Objects::nonNull).min(Comparator.comparing(AUTHORIZATION_STATUS_SORT_ORDER::indexOf)).orElse(null);
    }

    public static TravelPolicyAuthorizationStatus getAuthorizationStatus(BaseProduct product) {
        return TravelPolicyAuthorizationHelper.getCurrentAuthorizationUnitAuthorizations(product).stream().map(TravelPolicyUnitAuthorization::getStatus).filter(Objects::nonNull).min(Comparator.comparing(AUTHORIZATION_STATUS_SORT_ORDER::indexOf)).orElse(null);
    }

    public static TravelPolicyAuthorizationStatus getAuthorizationStatus(TravelPolicyAuthorizationStepParameters step) {
        return step.getUnits().stream().map(TravelPolicyAuthorizationUnitParameters::getUnitAuthorization).filter(Objects::nonNull).map(TravelPolicyUnitAuthorization::getStatus).filter(Objects::nonNull).min(Comparator.comparing(AUTHORIZATION_STATUS_SORT_ORDER::indexOf)).orElse(null);
    }

    public static LocalDateTime getAuthorizationSendDate(TravelPolicyAuthorizationStepParameters step) {
        return step.getUnits().stream().map(TravelPolicyAuthorizationUnitParameters::getUnitAuthorization).filter(Objects::nonNull).map(TravelPolicyUnitAuthorization::getSendDate).filter(Objects::nonNull).sorted().findFirst().orElse(null);
    }

    public static Date getAuthorizationTimeLimit(BaseProduct product) {
        return TravelPolicyAuthorizationHelper.getCurrentAuthorizationUnits(product).stream().map(TravelPolicyAuthorizationHelper::getAuthorizationUnitTimeLimit).filter(Objects::nonNull).sorted().findFirst().orElse(null);
    }

    private static Date getAuthorizationUnitTimeLimit(TravelPolicyAuthorizationUnitParameters unit) {
        return Optional.ofNullable(unit.getUnitAuthorization()).filter(tpa -> tpa.getStatus() == TravelPolicyAuthorizationStatus.WAIT).filter(tpa -> tpa.getSendDate() != null && unit.getTimeLimit() != null).map(tpa -> DateUtils.toJavaDate((LocalDateTime)tpa.getSendDate().plusMinutes(unit.getTimeLimit().intValue()))).orElse(null);
    }

    public static Map<EntityReference<Person>, String> getAuthPersonMails(BaseProduct product, List<TravelPolicyUnitAuthorization> unitAuthorizations) {
        List units = TravelPolicyAuthorizationHelper.getCurrentAuthorizationUnits(product).stream().filter(unit -> unitAuthorizations == null || unitAuthorizations.contains(unit.getUnitAuthorization())).collect(Collectors.toList());
        Map<EntityReference<Person>, String> result = units.stream().map(TravelPolicyAuthorizationUnitParameters::getPersons).flatMap(Collection::stream).filter(Objects::nonNull).distinct().map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).filter(EntityStorageHelper::nonEmpty).collect(Collectors.toMap(EntityContainer::toReference, ctr -> ProfileHelper.getCommunicationEmail((List)((Person)ctr.getEntity()).getCommunications())));
        result.entrySet().removeIf(entry -> TextUtil.isBlank((String)((String)entry.getValue())));
        return result;
    }

    public static String getPersonEmail(Reservation reservation) {
        List communications = reservation.getBookingFile().getCustomer().getCommunications();
        return ProfileHelper.getCommunicationEmail((List)communications);
    }

    public static String getBookingAgentEmail(Reservation reservation) {
        EntityContainer agentCtr = EntityStorage.get().resolve(reservation.getBookingAgent());
        if (agentCtr == null) {
            return null;
        }
        return ProfileHelper.getCommunicationEmail((List)((Person)agentCtr.getEntity()).getCommunications());
    }

    public static String collectPassengersEmails(BaseProduct product) {
        return ProductHandler.of((BaseProduct)product).getTravellers(product).stream().map(Traveller::getCommunications).filter(Objects::nonNull).map(ProfileHelper::getCommunicationEmail).collect(Collectors.joining(","));
    }

    public static List<TravelPolicyUnitAuthorization> getCurrentAuthorizationUnitAuthorizations(BaseProduct product) {
        return TravelPolicyAuthorizationHelper.getCurrentAuthorizationUnits(product).stream().map(TravelPolicyAuthorizationUnitParameters::getUnitAuthorization).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<TravelPolicyAuthorizationUnitParameters> getCurrentAuthorizationUnits(BaseProduct product) {
        TravelPolicyAuthorizationStepParameters step = TravelPolicyAuthorizationHelper.getCurrentAuthorizationStep(product);
        return Optional.ofNullable(step).map(TravelPolicyAuthorizationStepParameters::getUnits).orElse(Collections.emptyList());
    }

    public static TravelPolicyAuthorizationStepParameters getCurrentAuthorizationStep(BaseProduct product) {
        List<TravelPolicyAuthorizationStepParameters> steps = TravelPolicyAuthorizationHelper.getAuthorizationSteps(product);
        ListIterator<TravelPolicyAuthorizationStepParameters> it = steps.listIterator(steps.size());
        while (it.hasPrevious()) {
            TravelPolicyAuthorizationStepParameters step = it.previous();
            if (!step.getUnits().stream().anyMatch(u -> u.getUnitAuthorization() != null)) continue;
            return step;
        }
        return null;
    }

    public static List<TravelPolicyAuthorizationUnitParameters> getNeedAuthorizationNextStepUnits(BaseProduct product) {
        List<TravelPolicyAuthorizationStepParameters> steps = TravelPolicyAuthorizationHelper.getAuthorizationSteps(product);
        for (TravelPolicyAuthorizationStepParameters step : steps) {
            List<TravelPolicyAuthorizationUnitParameters> units = step.getUnits().stream().filter(unit -> unit.getUnitAuthorization() == null).collect(Collectors.toList());
            if (units.isEmpty()) continue;
            return units;
        }
        return Collections.emptyList();
    }

    public static List<TravelPolicyAuthorizationUnitParameters> getAllAuthorizationUnits(BaseProduct product) {
        return TravelPolicyAuthorizationHelper.getAuthorizationSteps(product).stream().map(TravelPolicyAuthorizationStepParameters::getUnits).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static List<TravelPolicyAuthorizationStepParameters> getAuthorizationSteps(BaseProduct product) {
        return Optional.ofNullable(TravelPolicyAuthorizationHelper.getTravelPolicyAuthorizationParameters(product)).map(TravelPolicyAuthorizationParameters::getSteps).orElse(Collections.emptyList());
    }

    public static boolean isExistsWaitingProductsForAgent(Reservation reservation, EntityReference<Person> agentRef) {
        return reservation.getProducts().stream().anyMatch(pr -> TravelPolicyAuthorizationHelper.isProductWaitingForAgent(pr, agentRef));
    }

    public static boolean isProductWaitingForAgent(BaseProduct product, EntityReference<Person> agentRef) {
        return !TravelPolicyAuthorizationHelper.getWaitingUnitAuthorizations(product, agentRef, null).isEmpty();
    }

    public static Map<BaseProduct, List<TravelPolicyUnitAuthorization>> getProductUnitAuthorizationsMap(List<BaseProduct> products, EntityReference<Person> agentRef, String stepUid) {
        HashMap<BaseProduct, List<TravelPolicyUnitAuthorization>> result = new HashMap<BaseProduct, List<TravelPolicyUnitAuthorization>>();
        for (BaseProduct product : products) {
            List<TravelPolicyUnitAuthorization> unitAuthorizations = TravelPolicyAuthorizationHelper.getWaitingUnitAuthorizations(product, agentRef, stepUid);
            if (unitAuthorizations.isEmpty()) continue;
            result.put(product, unitAuthorizations);
        }
        return result;
    }

    private static List<TravelPolicyUnitAuthorization> getWaitingUnitAuthorizations(BaseProduct product, EntityReference<Person> agentRef, String stepUid) {
        if (TravelPolicyAuthorizationHelper.getAuthorizationStatus(product) != TravelPolicyAuthorizationStatus.WAIT || TravelPolicyAuthorizationHelper.getAuthorizationStatus(product.getReservation()) != TravelPolicyAuthorizationStatus.WAIT) {
            return Collections.emptyList();
        }
        TravelPolicyAuthorizationStepParameters step = Objects.requireNonNull(TravelPolicyAuthorizationHelper.getCurrentAuthorizationStep(product));
        if (TextUtil.nonBlank((String)stepUid) && !MiscUtil.equals((Object)stepUid, (Object)step.getUid())) {
            return Collections.emptyList();
        }
        List<TravelPolicyUnitAuthorization> unitAuthorizations = TravelPolicyAuthorizationHelper.getWaitingUnitAuthorizations(step, agentRef);
        if (unitAuthorizations.isEmpty()) {
            return Collections.emptyList();
        }
        return unitAuthorizations;
    }

    private static List<TravelPolicyUnitAuthorization> getWaitingUnitAuthorizations(TravelPolicyAuthorizationStepParameters step, EntityReference<Person> agentRef) {
        return step.getUnits().stream().filter(unit -> agentRef == null || unit.getPersons().contains(agentRef)).map(TravelPolicyAuthorizationUnitParameters::getUnitAuthorization).filter(ua -> ua.getStatus() == TravelPolicyAuthorizationStatus.WAIT).collect(Collectors.toList());
    }

    public static boolean isPriceChangingInLimit(Reservation reservation, BigDecimal newPrice, BigDecimal oldPrice) {
        BigDecimal deltaBorder = TravelPolicyAuthorizationHelper.findPricingDelta(reservation);
        if (deltaBorder == null) {
            return newPrice.compareTo(oldPrice) <= 0;
        }
        BigDecimal deltaFact = newPrice.subtract(oldPrice).multiply(new BigDecimal(100)).divide(newPrice, RoundingMode.HALF_UP);
        return deltaFact.compareTo(deltaBorder) <= 0;
    }
}

