/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.restriction.resource;

import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.BaseIssue;
import com.gridnine.xtrip.common.model.ibecorp.correspondence.IssueIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.restriction.resource.RestrictionMatchable;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProxy;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyCategory;

public enum IbeRestrictionBaseIssueResourceProperties implements RestrictionResourceProperty,
RestrictionMatchable
{
    AGENCY{

        @Override
        String getIndexPropertyName() {
            return IssueIndex.Property.agency.name();
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseIssue issue = (BaseIssue)object;
            proxy.getProperties().put(this.getId(), issue.getAgency());
        }
    }
    ,
    SUBAGENCY{

        @Override
        String getIndexPropertyName() {
            return IssueIndex.Property.subagency.name();
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseIssue issue = (BaseIssue)object;
            proxy.getProperties().put(this.getId(), issue.getSubagency());
        }
    }
    ,
    CLIENT{

        @Override
        String getIndexPropertyName() {
            return IssueIndex.Property.client.name();
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseIssue issue = (BaseIssue)object;
            proxy.getProperties().put(this.getId(), issue.getClient());
        }
    }
    ,
    ASSIGNEE{

        @Override
        String getIndexPropertyName() {
            return IssueIndex.Property.assignee.name();
        }

        public Class<?> getType() {
            return Person.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseIssue issue = (BaseIssue)object;
            proxy.getProperties().put(this.getId(), issue.getAssignee());
        }
    }
    ,
    AUTHOR{

        @Override
        String getIndexPropertyName() {
            return IssueIndex.Property.author.name();
        }

        public Class<?> getType() {
            return Person.class;
        }

        public boolean isCollection() {
            return false;
        }

        public boolean isTimeIncluded() {
            return false;
        }

        public String getCategoryId() {
            return StandardRestrictionResourcePropertyCategory.ENTITY.name();
        }

        public void init(RestrictionResourceProxy proxy, Object object) {
            BaseIssue issue = (BaseIssue)object;
            proxy.getProperties().put(this.getId(), issue.getAuthor());
        }
    };


    public String getIdSuffix() {
        return this.name();
    }

    public String getId() {
        return String.format("%s.%s", this.getResourceId(), this.getIdSuffix());
    }

    abstract String getIndexPropertyName();

    public String getName() {
        return ((IndexProperty)((IndexType)MetaRegistry.get().getIndexes().get(IssueIndex.class.getName())).getProperties().get(this.getIndexPropertyName())).getDisplayName(LocaleHelper.getCurrentLocale());
    }

    public String getDescriprion() {
        return this.getName();
    }

    public String getResourceId() {
        return IbeRestrictionEntityResources.ENTITY_BASE_ISSUE.getId();
    }

    public Object getValue(RestrictionResourceProxy proxy) {
        return proxy.getProperties().get(this.getId());
    }
}

