/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.restriction.resource.helper;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.BaseSMProfile;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.restriction.resource.helper.RestrictionModelRulesHelper;
import com.gridnine.xtrip.common.model.security.acl.IbeCorpAclRole;
import com.gridnine.xtrip.common.restriction.helper.RestrictionRulesHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbeRestrictionRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(IbeRestrictionRulesHelper.class);

    public static boolean isMyOrganizationsSites(Object data, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<SMSite>> sites = new ArrayList<EntityReference<SMSite>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                sites.addAll(ProfileHelper.getOrganizationSites(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), sites);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), sites);
            }
            return true;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), sites);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), sites);
        }
        return true;
    }

    public static boolean isMyOrganizationsSitesSettings(Object data, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<BaseSMProfile>> settings = new ArrayList<EntityReference<BaseSMProfile>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                settings.addAll(ProfileHelper.getSiteSettings(ProfileHelper.getOrganizationSites(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date()))));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), settings);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), settings);
            }
            return true;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), settings);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), settings);
        }
        return true;
    }

    public static boolean isMyOrganizationsRulesHolders(Object data, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<RulesHolder>> rulesHolder = new ArrayList<EntityReference<RulesHolder>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                rulesHolder.addAll(ProfileHelper.getOrganizationRulesHolders(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), rulesHolder);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), rulesHolder);
            }
            return true;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), rulesHolder);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), rulesHolder);
        }
        return true;
    }

    public static boolean isMyOrganizationsCustomersAclRoles(Object data, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<IbeCorpAclRole>> aclRoles = new ArrayList<EntityReference<IbeCorpAclRole>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                aclRoles.addAll(ProfileHelper.getOrganizationAclRoles(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonsOrganizationsCustomers((EntityContainer)person)));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), aclRoles);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), aclRoles);
            }
            return true;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), aclRoles);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), aclRoles);
        }
        return true;
    }

    public static boolean isMyOrganizationsAclRoles(Object data, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<IbeCorpAclRole>> aclRoles = new ArrayList<EntityReference<IbeCorpAclRole>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                aclRoles.addAll(ProfileHelper.getOrganizationAclRoles(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), aclRoles);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), aclRoles);
            }
            return true;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), aclRoles);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), aclRoles);
        }
        return true;
    }

    public static boolean isMyAclRoles(Object data, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<IbeCorpAclRole>> aclRoles = new ArrayList<EntityReference<IbeCorpAclRole>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                aclRoles.addAll(ProfileHelper.getPersonAclRoles(Arrays.asList(person.toReference())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), aclRoles);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return !RestrictionRulesHelper.isContainsCollection((Collection)((Collection)data), aclRoles);
            }
            return true;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.isEquals((Object)((EntityReference)data), aclRoles);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return !RestrictionRulesHelper.isEquals((Object)((EntityReference)data), aclRoles);
        }
        return true;
    }

    public static SearchCriterion createMyOrganizationsSitesCriterion(String propertyId, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<SMSite>> sites = new ArrayList<EntityReference<SMSite>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                sites.addAll(ProfileHelper.getOrganizationSites(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, sites, (boolean)collection);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, sites, (boolean)collection);
            }
            return null;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, sites);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, sites);
        }
        return null;
    }

    public static SearchCriterion createMyOrganizationsSitesSettingsCriterion(String propertyId, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<BaseSMProfile>> settings = new ArrayList<EntityReference<BaseSMProfile>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                settings.addAll(ProfileHelper.getSiteSettings(ProfileHelper.getOrganizationSites(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date()))));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, settings, (boolean)collection);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, settings, (boolean)collection);
            }
            return null;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, settings);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, settings);
        }
        return null;
    }

    public static SearchCriterion createMyOrganizationsRulesHoldersCriterion(String propertyId, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<RulesHolder>> rulesHolder = new ArrayList<EntityReference<RulesHolder>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                rulesHolder.addAll(ProfileHelper.getOrganizationRulesHolders(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, rulesHolder, (boolean)collection);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, rulesHolder, (boolean)collection);
            }
            return null;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, rulesHolder);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, rulesHolder);
        }
        return null;
    }

    public static SearchCriterion createMyOrganizationsCustomersAclRolesCriterion(String propertyId, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<IbeCorpAclRole>> aclRoles = new ArrayList<EntityReference<IbeCorpAclRole>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                aclRoles.addAll(ProfileHelper.getOrganizationAclRoles(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonsOrganizationsCustomers((EntityContainer)person)));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, aclRoles, (boolean)collection);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, aclRoles, (boolean)collection);
            }
            return null;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, aclRoles);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, aclRoles);
        }
        return null;
    }

    public static SearchCriterion createMyOrganizationsAclRolesCriterion(String propertyId, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<IbeCorpAclRole>> aclRoles = new ArrayList<EntityReference<IbeCorpAclRole>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                aclRoles.addAll(ProfileHelper.getOrganizationAclRoles(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, aclRoles, (boolean)collection);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, aclRoles, (boolean)collection);
            }
            return null;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, aclRoles);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, aclRoles);
        }
        return null;
    }

    public static SearchCriterion createMyAclRolesCriterion(String propertyId, String userId, boolean collection, RestrictionModelRulesHelper.EntityCondition condition) {
        ArrayList<EntityReference<IbeCorpAclRole>> aclRoles = new ArrayList<EntityReference<IbeCorpAclRole>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                aclRoles.addAll(ProfileHelper.getPersonAclRoles(Arrays.asList(person.toReference())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        if (collection) {
            if (condition == RestrictionModelRulesHelper.EntityCondition.CONTAINS) {
                return RestrictionRulesHelper.createContainsCriterion((String)propertyId, aclRoles, (boolean)collection);
            }
            if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_CONTAINS) {
                return RestrictionRulesHelper.createNotContainsCriterion((String)propertyId, aclRoles, (boolean)collection);
            }
            return null;
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.EQUALS) {
            return RestrictionRulesHelper.createEqualsCriterion((String)propertyId, aclRoles);
        }
        if (condition == RestrictionModelRulesHelper.EntityCondition.NOT_EQUALS) {
            return RestrictionRulesHelper.createNotEqualsCriterion((String)propertyId, aclRoles);
        }
        return null;
    }
}

