/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.ibecorp.rules.AirPropertiesProvider;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;

public enum AirProperties implements RuleProperty,
RulePropertyConditions
{
    VALIDATING_CARRIERS{

        public double getRank() {
            return 0.1;
        }

        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CARRIERS);
        }

        public String getRendererId() {
            return ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RESERVATIONS_CANCEL_TICKETS_VOIDING.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_CARRIERS_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirPropertiesProvider ps = (AirPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCarriers(), (Object)value, (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction(ps.getCarriers(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    HOURS_BEFORE_DEPARTURE_IBE{

        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HOURS_BEFORE_DEPARTURE);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RESERVATIONS_CANCEL_TICKETS_VOIDING.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HOURS_BEFORE_DEPARTURE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirPropertiesProvider ps = (AirPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double hrs = ps.getHoursBeforeDeparture();
            if (hrs == -1.0) {
                return false;
            }
            if (Conditions.EQUALS.equals((Object)condition)) {
                return hrs == dv;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return hrs != dv;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return hrs > dv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs >= dv;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return hrs < dv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs <= dv;
            }
            return true;
        }
    }
    ,
    IS_SAME_DAY_AS_DEPARTURE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_IsSameDayAsDeparture);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_IsSameDayAsDeparture_info1) : L10n.get((String)Messages.RuleProperty_IsSameDayAsDeparture_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirPropertiesProvider ps = (AirPropertiesProvider)propertySet;
            return ps.isSameDayAsDeparture().equals(value);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RESERVATIONS_CANCEL_TICKETS_VOIDING.getId()};
        }

        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }
    }
    ,
    HOURS_AFTER_ISSUE{

        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HoursAfterIssueDate);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RESERVATIONS_CANCEL_TICKETS_VOIDING.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HoursAfterIssueDate_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirPropertiesProvider ps = (AirPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double hrs = ps.getHoursAfterIssueDate();
            if (hrs == -1.0) {
                return false;
            }
            if (Conditions.EQUALS.equals((Object)condition)) {
                return hrs == dv;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return hrs != dv;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return hrs > dv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs >= dv;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return hrs < dv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs <= dv;
            }
            return true;
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();
}

