/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.ibecorp.rules.IbecorpTripartitePropertiesSetProvider;
import com.gridnine.xtrip.common.ibecorp.rules.NotificationTypeProvider;
import com.gridnine.xtrip.common.ibecorp.rules.PriceDetailProperty;
import com.gridnine.xtrip.common.ibecorp.rules.SbisPropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.SmSiteTypeProvider;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.ibecorp.rules.ValueTypes;
import com.gridnine.xtrip.common.ibecorp.rules.l10n.Messages;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulePropertyConditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public enum IbecorpProperties implements RuleProperty,
RulePropertyConditions
{
    SM_SITE_TYPE{

        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"IBECORP_RULES_PROPERTIES_SM_SITE_TYPE", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.SM_SITE_TYPE.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SmSiteTypeProvider ps = (SmSiteTypeProvider)propertySet;
            SMSiteType siteType = (SMSiteType)value;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return siteType == ps.getSMSiteType();
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return siteType != ps.getSMSiteType();
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.PRODUCT_COMMISSION.getId(), com.gridnine.xtrip.common.railway.model.rules.standart.Targets.RAILWAY_PRODUCT_COMMISSION.getId(), com.gridnine.xtrip.common.model.rules.standard.Targets.HOTELS_COMMISSION.getId(), com.gridnine.xtrip.common.model.rules.standard.Targets.TRANSFER.getId()};
        }
    }
    ,
    TRIPARTITE_AGREEMENT{

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RuleProperty_TripartiteAgreement", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        @Override
        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            boolean b = (Boolean)value;
            buf.append(b ? L10nResourcesManager.getStr((String)"RuleProperty_With3DAgreement", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"RuleProperty_Without3DAgreement", (Object[])new Object[0]));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            IbecorpTripartitePropertiesSetProvider pp = (IbecorpTripartitePropertiesSetProvider)propertySet;
            Boolean isTripartiteAgreement = (Boolean)value;
            return MiscUtil.equals((Object)isTripartiteAgreement, (Object)pp.isTripartiteAgreement());
        }

        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        @Override
        String[] getTargetIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Targets.HOTELS_COMMISSION.getId()};
        }
    }
    ,
    SBIS_FINANCE_DOCUMENT_TYPE{

        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"IBECORP_RULES_PROPERTIES_SBIS_FINANCE_DOCUMENT_TYPE", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.SBIS_FINANCE_DOCUMENT_TYPE.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SbisPropertySet ps = (SbisPropertySet)propertySet;
            List financeDocumentTypes = (List)value;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return financeDocumentTypes.contains(ps.getFinanceDocumentType());
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return !financeDocumentTypes.contains(ps.getFinanceDocumentType());
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SBIS_PARAMETERS.getId()};
        }
    }
    ,
    SBIS_PRODUCT_TYPE{

        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"IBECORP_RULES_PROPERTIES_SBIS_PRODUCT_TYPE", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.EXTENDED_PRODUCT_TYPE.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SbisPropertySet ps = (SbisPropertySet)propertySet;
            MiscUtil.Pair productType = Optional.ofNullable(ps.getProductType()).map(item -> new MiscUtil.Pair((Object)item.getProductType(), (Object)item.getProductDescription())).orElse(null);
            List productTypes = Optional.ofNullable((List)value).map(items -> items.stream().map(item -> new MiscUtil.Pair((Object)item.getProductType(), (Object)item.getProductDescription())).collect(Collectors.toList())).orElse(Collections.emptyList());
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return productTypes.contains(productType);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return !productTypes.contains(productType);
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SBIS_PARAMETERS.getId()};
        }
    }
    ,
    SBIS_INTERMEDIARY_SERVICE{

        public String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"IBECORP_RULES_PROPERTIES_SBIS_INTERMEDIARY_SERVICE", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SbisPropertySet ps = (SbisPropertySet)propertySet;
            return MiscUtil.equals((Object)((Boolean)value), (Object)ps.isIntermediaryService());
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.SBIS_PARAMETERS.getId()};
        }

        @Override
        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(this.getDisplayName()).append(" ").append(cond.getDisplayName()).append(" \"").append((Boolean)value != false ? L10nResourcesManager.getStr((String)"IBECORP_RULES_PROPERTIES_SBIS_INTERMEDIARY_SERVICE_YES", (Object[])new Object[0]) : L10nResourcesManager.getStr((String)"IBECORP_RULES_PROPERTIES_SBIS_INTERMEDIARY_SERVICE_NO", (Object[])new Object[0])).append("\"");
        }
    }
    ,
    PRICE_DETAIL_DISPLAY_AREA{

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)Messages.RuleProperty_PRICE_DETAIL_DISPLAY_AREA, (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.PRICE_DETAIL_DISPLAY_AREA.name();
        }

        @Override
        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.replace((String)L10nResourcesManager.getStr((String)Messages.RuleProperty_PRICE_DETAIL_DISPLAY_AREA_info, (Object[])new Object[0]), (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            PriceDetailProperty ps = (PriceDetailProperty)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumsRestriction(ps.getPriceDetailDisplayArea(), (List)((List)value), (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumsRestriction(ps.getPriceDetailDisplayArea(), (List)((List)value), (boolean)false);
            }
            return true;
        }
    }
    ,
    NOTIFICATION_TYPE{

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        public String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"IBECORP_RULES_PROPERTIES_NOTIFICATION_TYPE", (Object[])new Object[0]);
        }

        public String getRendererId() {
            return ValueTypes.NOTIFICATION_TYPES.name();
        }

        @Override
        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.replace((String)L10nResourcesManager.getStr((String)"IBECORP_RULES_PROPERTIES_NOTIFICATION_TYPE_INFO", (Object[])new Object[0]), (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            List notificationTypes = (List)value;
            NotificationTypeProvider ps = (NotificationTypeProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return notificationTypes.contains(ps.getNotificationType());
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return !notificationTypes.contains(ps.getNotificationType());
            }
            return true;
        }
    };


    abstract String[] getTargetIds();

    public String getId() {
        return this.name();
    }

    public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
        buf.append(this.getDisplayName()).append(" ").append(cond.getDisplayName()).append(" \"").append(RulesHelper.toString((Object)value)).append("\"");
    }
}

