/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.ibecorp.rules.NotificationBalancePropertySet;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.ibecorp.rules.l10n.Messages;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import java.math.BigDecimal;
import java.util.List;

public enum NotificationBalanceProperties implements RuleProperty
{
    BALANCE_CLIENT{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.NotificationBalanceProperties_BALANCE_CLIENT);
        }

        public String getRendererId() {
            return ValueTypes.ORGANIZATIONS_REFERENCES.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.NOTIFICATION_TEMPLATE_BALANCE.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(this.getDisplayName()).append(" ").append(cond.getDisplayName()).append(" \"").append(RulesHelper.toString((Object)value)).append("\"");
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            NotificationBalancePropertySet ps = (NotificationBalancePropertySet)propertySet;
            List organizations = (List)value;
            EntityReference<Organization> client = ps.getClient();
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return organizations.contains(client);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return !organizations.contains(client);
            }
            return false;
        }
    }
    ,
    BALANCE_AGENCY{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.NotificationBalanceProperties_BALANCE_AGENCY);
        }

        public String getRendererId() {
            return ValueTypes.ORGANIZATIONS_REFERENCES.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.NOTIFICATION_TEMPLATE_BALANCE.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(this.getDisplayName()).append(" ").append(cond.getDisplayName()).append(" \"").append(RulesHelper.toString((Object)value)).append("\"");
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            NotificationBalancePropertySet ps = (NotificationBalancePropertySet)propertySet;
            List organizations = (List)value;
            EntityReference<Organization> agency = ps.getAgency();
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return organizations.contains(agency);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return !organizations.contains(agency);
            }
            return false;
        }
    }
    ,
    AVAILABLE_AMOUNT{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.NotificationBalanceProperties_AVAILABLE_AMOUNT);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.NOTIFICATION_TEMPLATE_BALANCE.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(this.getDisplayName()).append(" ").append(cond.getDisplayName()).append(" \"").append(RulesHelper.toString((Object)value)).append("\"");
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            NotificationBalancePropertySet ps = (NotificationBalancePropertySet)propertySet;
            BigDecimal val = value == null ? BigDecimal.ZERO : BigDecimal.valueOf(((Number)value).doubleValue());
            BigDecimal availableBalance = ps.getAvailableAmount();
            if (availableBalance == null) {
                return false;
            }
            if (Conditions.EQUALS.equals((Object)condition)) {
                return availableBalance.compareTo(val) == 0;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return availableBalance.compareTo(val) != 0;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return availableBalance.compareTo(val) > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return availableBalance.compareTo(val) >= 0;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return availableBalance.compareTo(val) < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return availableBalance.compareTo(val) <= 0;
            }
            return false;
        }
    }
    ,
    BALANCE_AMOUNT{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.NotificationBalanceProperties_BALANCE_AMOUNT);
        }

        public String getRendererId() {
            return ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.NOTIFICATION_TEMPLATE_BALANCE.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(this.getDisplayName()).append(" ").append(cond.getDisplayName()).append(" \"").append(RulesHelper.toString((Object)value)).append("\"");
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            NotificationBalancePropertySet ps = (NotificationBalancePropertySet)propertySet;
            BigDecimal val = value == null ? BigDecimal.ZERO : BigDecimal.valueOf(((Number)value).doubleValue());
            BigDecimal balanceAmount = ps.getBalanceAmount();
            if (balanceAmount == null) {
                return false;
            }
            if (Conditions.EQUALS.equals((Object)condition)) {
                return balanceAmount.compareTo(val) == 0;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return balanceAmount.compareTo(val) != 0;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return balanceAmount.compareTo(val) > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return balanceAmount.compareTo(val) >= 0;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return balanceAmount.compareTo(val) < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return balanceAmount.compareTo(val) <= 0;
            }
            return false;
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();
}

