/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.ibecorp.rules.RzdParametersActionsProvider;
import com.gridnine.xtrip.common.ibecorp.rules.ValueTypes;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.railway.BaseRailGdsAccount;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;

public enum RzdActions implements RuleAction
{
    APPLICABLE_RZD_ACCOUNTS{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            Collection accounts = (Collection)value;
            if (accounts.size() == 0) {
                return;
            }
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleAction_ApplicableGDSAccounts_info, (Object[])new Object[]{CollectionUtil.collectionToString((Iterable)accounts, (String)", ", (boolean)false)}));
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_ApplicableGDSAccounts);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.gds.rules.ValueTypes.GDS_ACCOUNT_LIST.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RzdParametersActionsProvider as = (RzdParametersActionsProvider)proxy.getActionSet();
            for (EntityReference gdsAcc : (Collection)value) {
                as.addApplicableGDSAccount((EntityReference<BaseRailGdsAccount>)gdsAcc);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"applicable-RZD-accounts\"";
        }
    }
    ,
    SEARCH_DAYS_LIMIT{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            Integer limit = (Integer)value;
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0433\u043b\u0443\u0431\u0438\u043d\u0443 \u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u0432 {0} \u0434\u043d.", (Object[])new Object[]{limit}));
        }

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0433\u043b\u0443\u0431\u0438\u043d\u0443 \u043f\u0440\u043e\u0434\u0430\u0436\u0438";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.INTEGER.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RzdParametersActionsProvider as = (RzdParametersActionsProvider)proxy.getActionSet();
            as.setSearchDaysLimit((Integer)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "search-days-limit";
        }
    }
    ,
    CONTENT_TYPE{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u043e\u0440\u043c\u0430\u0442 \u041c\u041a/\u041a\u0420\u0421 \u0432 {0}", (Object[])new Object[]{(ContentType)value}));
        }

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u043e\u0440\u043c\u0430\u0442 \u041c\u041a/\u041a\u0420\u0421";
        }

        public String getRendererId() {
            return ValueTypes.CONTENT_TYPE.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            RzdParametersActionsProvider as = (RzdParametersActionsProvider)proxy.getActionSet();
            as.setDocContentType((ContentType)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"RZD-CONTENT_TYPE\"";
        }
    }
    ,
    BLANK_OWNER_RAIL{

        public void buildInfo(StringBuilder buf, Object value) {
            if (TextUtil.isBlank((String)((String)value))) {
                return;
            }
            buf.append(L10n.replace((String)"\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u043e\u0432 \u0432 {0}", (Object[])new Object[]{value}));
        }

        public String getDisplayName() {
            return "\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043b\u0430\u0434\u0435\u043b\u044c\u0446\u0430 \u0431\u043b\u0430\u043d\u043a\u043e\u0432";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            if (!TextUtil.isBlank((String)((String)value))) {
                RzdParametersActionsProvider as = (RzdParametersActionsProvider)proxy.getActionSet();
                as.setBlankOwner((String)value);
                proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
            }
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "blank-owner-railway";
        }
    };


    public String getId() {
        return this.name();
    }
}

