/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rules;

import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.ibecorp.rules.SearchResultSortTypeActionsSet;
import com.gridnine.xtrip.common.ibecorp.rules.SmSiteTypeProvider;
import com.gridnine.xtrip.common.ibecorp.rules.Targets;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.SearchResultSortType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.SalesContextProperties;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import java.util.Collections;
import java.util.Date;
import org.slf4j.LoggerFactory;

public class SearchResultSortTypeProperty
extends SalesContextProperties
implements SmSiteTypeProvider {
    private final SMSiteType smSiteType;
    private final SalesContext salesContext;
    private final Targets target;
    private final boolean hasTravelPolicy;

    public static Builder builder(SalesContext salesContext, Targets target) {
        return new Builder(salesContext, target);
    }

    @Override
    public SMSiteType getSMSiteType() {
        return this.smSiteType;
    }

    private SearchResultSortTypeProperty(SalesContext salesContext, Targets target, boolean hasTravelPolicy) {
        super(salesContext);
        this.salesContext = salesContext;
        this.smSiteType = CommonIbecorpHelper.getSiteType((EntityReference<SMSite>)salesContext.getSite());
        this.hasTravelPolicy = hasTravelPolicy;
        this.target = target;
    }

    private SearchResultSortType build() {
        if (this.target != null) {
            RuleProxy<SearchResultSortTypeProperty, SearchResultSortTypeActionsSet> proxy = this.createProxy();
            try {
                RuleSet ruleSet = SalesContextHandler.get().getRules(this.salesContext);
                RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)ruleSet);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).warn("failed applying search result sort type rules", (Throwable)e);
            }
            if (((SearchResultSortTypeActionsSet)proxy.getActionSet()).getSearchResultSortType() != null) {
                return ((SearchResultSortTypeActionsSet)proxy.getActionSet()).getSearchResultSortType();
            }
            if (this.target == Targets.SEARCH_RESULT_SORT_TYPE_HOTEL) {
                return SearchResultSortType.SORT_BY_RECOMMEND;
            }
        }
        return this.hasTravelPolicy ? SearchResultSortType.SORT_BY_TRAVEL_POLICY : SearchResultSortType.SORT_BY_PRICE_ASCENDING;
    }

    private RuleProxy<SearchResultSortTypeProperty, SearchResultSortTypeActionsSet> createProxy() {
        RuleProxy proxy = new RuleProxy();
        proxy.setProxyDate(new Date());
        proxy.setProxyType(this.target.getId());
        proxy.setPropertySet((Object)this);
        proxy.setActionSet((Object)new SearchResultSortTypeActionsSet());
        return proxy;
    }

    public static class Builder {
        private final SalesContext salesContext;
        private final Targets target;
        private boolean hasTravelPolicy;

        private Builder(SalesContext salesContext, Targets target) {
            this.salesContext = salesContext;
            this.target = target;
        }

        public Builder setHasTravelPolicy(boolean hasTravelPolicy) {
            this.hasTravelPolicy = hasTravelPolicy;
            return this;
        }

        public SearchResultSortType build() {
            return new SearchResultSortTypeProperty(this.salesContext, this.target, this.hasTravelPolicy).build();
        }
    }
}

