/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.rzd;

import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DirectionGroupCalculator {
    private static List<String> DIRECTION_GROUP_1_COUNTRIES = Arrays.asList("FI");
    private static List<String> DIRECTION_GROUP_2_COUNTRIES = Arrays.asList("FR", "CZ", "DE", "PL", "AT", "BG", "HU", "RS", "SK");

    public DirectionGroup calculate(DictionaryReference<RailwayStation> departureStation, DictionaryReference<RailwayStation> arrivalStation) {
        List<String> countries = this.collectCountries(departureStation, arrivalStation);
        if (countries.isEmpty()) {
            return DirectionGroup.WITHIN_STATE_SNG_0;
        }
        if (CollectionUtil.containAtLeastOneCommonElement(DIRECTION_GROUP_1_COUNTRIES, countries)) {
            return DirectionGroup.ABROAD_RUS_FIN_1;
        }
        if (CollectionUtil.containAtLeastOneCommonElement(DIRECTION_GROUP_2_COUNTRIES, countries)) {
            return DirectionGroup.ABROAD_EAST_WEST_2;
        }
        return DirectionGroup.WITHIN_STATE_SNG_0;
    }

    private List<String> collectCountries(DictionaryReference<RailwayStation> departureStation, DictionaryReference<RailwayStation> arrivalStation) {
        ArrayList<String> countries = new ArrayList<String>();
        DictionaryReference<Country> countryRef = this.getStationCountry(departureStation);
        if (countryRef != null) {
            countries.add(countryRef.getCode());
        }
        if ((countryRef = this.getStationCountry(arrivalStation)) != null) {
            countries.add(countryRef.getCode());
        }
        return countries;
    }

    protected DictionaryReference<Country> getStationCountry(DictionaryReference<RailwayStation> departureStation) {
        return RzdCommonHelper.getStationCountry(departureStation);
    }

    public static enum DirectionGroup {
        WITHIN_STATE_SNG_0(0),
        ABROAD_RUS_FIN_1(1),
        ABROAD_EAST_WEST_2(2);

        private final int value;

        private DirectionGroup(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

