/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.security.acl.resource;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IbeAclModelRulesHelper {
    private static final Logger log = LoggerFactory.getLogger(IbeAclModelRulesHelper.class);

    public static boolean isMySites(EntityReference<SMSite> data, String userId) {
        LinkedList<EntityReference<SMSite>> sites = new LinkedList<EntityReference<SMSite>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            ArrayList organizations = new ArrayList();
            if (person != null) {
                organizations.addAll(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date()));
            }
            for (EntityReference orgRef : organizations) {
                sites.add(ProfileHelper.findB2cSite((EntityReference<Organization>)orgRef));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.isIncludes(data, sites);
    }

    public static SearchCriterion createMySitesCriterion(String propertyId, String userId, boolean collection) {
        LinkedList<EntityReference<SMSite>> sites = new LinkedList<EntityReference<SMSite>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                sites.addAll(ProfileHelper.getOrganizationSites(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, sites, (boolean)collection);
    }

    public static SearchCriterion createMyRulesHoldersCriterion(String propertyId, String userId, boolean collection) {
        LinkedList<EntityReference<RulesHolder>> rulesHolders = new LinkedList<EntityReference<RulesHolder>>();
        try {
            EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (person != null) {
                rulesHolders.addAll(ProfileHelper.getOrganizationRulesHolders(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date())));
            }
        }
        catch (Exception e) {
            log.error("unable to collect entities", (Throwable)e);
        }
        return AclRulesHelper.createIncludesCriterion((String)propertyId, rulesHolders, (boolean)collection);
    }
}

