/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.security.acl.resource;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.ibecorp.security.acl.resource.IbeAclModelResourcePropertyConditions;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.RulesHolder;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclIndexResourceOwnershipProperty;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IbeModelAclRulesHolderIndexResourceOwnershipProperty
extends ModelAclIndexResourceOwnershipProperty {
    private static final Logger log = LoggerFactory.getLogger(IbeModelAclRulesHolderIndexResourceOwnershipProperty.class);

    public IbeModelAclRulesHolderIndexResourceOwnershipProperty(IndexType index, String propertyId, String propertyName, String propertyType) {
        super(index, propertyId, propertyName, propertyType);
    }

    public Set<String> getConditionIds() {
        return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), IbeAclModelResourcePropertyConditions.MY_RULES_HOLDERS.getId()));
    }

    public String getRendererId(String conditionId) {
        if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
            return AclResourcePropertyType.ENTITY.name();
        }
        if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
            return AclResourcePropertyType.ENTITY_LIST.name();
        }
        return AclResourcePropertyType.NULL.name();
    }

    public SearchCriterion getQuery(AclResourcePropertyCondition condition, Object value, String userId) {
        if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
            return this.createContainerUidEqualsCriterion((EntityReference)value);
        }
        if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
            return this.createContainerUidNotEqualsCriterion((EntityReference)value);
        }
        if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
            return this.createContainerUidIncludesCriterion((Iterable)value);
        }
        if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
            return this.createContainerUidNotIncludesCriterion((Iterable)value);
        }
        if (IbeAclModelResourcePropertyConditions.MY_RULES_HOLDERS.getId().equals(condition.getId())) {
            LinkedList<EntityReference<RulesHolder>> rulesHolders = new LinkedList<EntityReference<RulesHolder>>();
            try {
                EntityContainer person = ((EntityStorage)Environment.getPublished(EntityStorage.class)).find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
                if (person != null && IbeAclModelResourcePropertyConditions.MY_RULES_HOLDERS.getId().equals(condition.getId())) {
                    rulesHolders.addAll(ProfileHelper.getOrganizationRulesHolders(com.gridnine.xtrip.common.model.helpers.ProfileHelper.getPersonOrganizations(Arrays.asList(person.toReference()), null, (Date)new Date())));
                }
            }
            catch (Exception e) {
                log.error("unable to collect entities", (Throwable)e);
            }
            return this.createContainerUidIncludesCriterion(rulesHolders);
        }
        return null;
    }
}

