/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ibecorp.util;

import com.gridnine.xtrip.common.model.ibecorp.sm.StyleBlock;
import com.gridnine.xtrip.common.model.ibecorp.sm.StyleSelector;
import java.util.List;

public class StyleHelper {
    public static String getCSS(StyleBlock styleBlock) {
        return StyleHelper.getCSS(styleBlock, false);
    }

    public static String getCSS(StyleBlock styleBlock, boolean isForWebSite) {
        String contents = StyleHelper.getBlockContents(styleBlock, isForWebSite);
        if (contents == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(styleBlock.getSelector().getCss());
        sb.append(" {\n");
        sb.append(contents);
        sb.append("}\n");
        return sb.toString();
    }

    public static String getBlockContents(StyleBlock styleBlock) {
        return StyleHelper.getBlockContents(styleBlock, false);
    }

    public static String getBlockContents(StyleBlock styleBlock, boolean isForWebSite) {
        StringBuilder sb = new StringBuilder();
        if (styleBlock.getBackgroundColor() != null && styleBlock.getSelector() != StyleSelector.BASE_STYLE) {
            sb.append("\tbackground: #");
            sb.append(styleBlock.getBackgroundColor());
            sb.append(StyleHelper.addImportant(isForWebSite, styleBlock.getSelector()));
        }
        if (styleBlock.getForegroundColor() != null) {
            sb.append("\tcolor: #");
            sb.append(styleBlock.getForegroundColor());
            sb.append(StyleHelper.addImportant(isForWebSite, styleBlock.getSelector()));
        }
        if (styleBlock.getFontSettings().getFont() != null) {
            sb.append("\tfont-family: ");
            sb.append(styleBlock.getFontSettings().getFont().getFontName());
            sb.append(StyleHelper.addImportant(isForWebSite, styleBlock.getSelector()));
        }
        if (styleBlock.getFontSettings().getSizeValue() != null) {
            sb.append("\tfont-size: ");
            sb.append(styleBlock.getFontSettings().getSizeValue());
            sb.append(styleBlock.getFontSettings().isSizeRelative() ? "%" : "px");
            sb.append(StyleHelper.addImportant(isForWebSite, styleBlock.getSelector()));
        }
        if (styleBlock.getFontSettings().getBold() != null) {
            sb.append("\tfont-weight: ");
            sb.append(styleBlock.getFontSettings().getBold() != false ? "bold" : "normal");
            sb.append(StyleHelper.addImportant(isForWebSite, styleBlock.getSelector()));
        }
        if (styleBlock.getFontSettings().getItalic() != null) {
            sb.append("\tfont-style: ");
            sb.append(styleBlock.getFontSettings().getItalic() != false ? "italic" : "normal");
            sb.append(StyleHelper.addImportant(isForWebSite, styleBlock.getSelector()));
        }
        if (styleBlock.getFontSettings().getUnderline() != null) {
            sb.append("\ttext-decoration: ");
            sb.append(styleBlock.getFontSettings().getUnderline() != false ? "underline" : "none");
            sb.append(StyleHelper.addImportant(isForWebSite, styleBlock.getSelector()));
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private static String addImportant(boolean isForWebSite, StyleSelector styleSelector) {
        return isForWebSite && styleSelector != StyleSelector.BASE_STYLE ? " !important;\n" : ";\n";
    }

    public static StyleBlock getStyleBlock(List<StyleBlock> list, StyleSelector selector) {
        for (StyleBlock styleBlock : list) {
            if (styleBlock.getSelector() != selector) continue;
            return styleBlock;
        }
        StyleBlock styleBlock = new StyleBlock();
        styleBlock.setSelector(selector);
        list.add(styleBlock);
        return styleBlock;
    }
}

