/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.handlers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayReferenceMcoHelper;
import com.gridnine.xtrip.common.railway.model.rules.standart.Targets;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RailwayReferenceMCOHandler
implements ProductHandler<RailwayReferenceMCO> {
    public Class<RailwayReferenceMCO> getProductClass() {
        return RailwayReferenceMCO.class;
    }

    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, RailwayReferenceMCO product) {
        return this.calculateProductPrice(product, null);
    }

    public VatAmount calculateProductPrice(RailwayReferenceMCO product, ContractType ctype) {
        VatAmount result = new VatAmount();
        result.setTotalVat(BigDecimal.ZERO, MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat((Date)product.getIssueDate())).doubleValue());
        return result;
    }

    public String generateShortProductName(RailwayReferenceMCO product) {
        return "\u0416/\u0414 \u041a\u0420\u0421 " + (TextUtil.isBlank((String)product.getSystemNumber()) ? "" : product.getSystemNumber()) + " ";
    }

    public String generateProductName(RailwayReferenceMCO product) {
        return this.generateShortProductName(product);
    }

    public Date findFirstTravelDate(RailwayReferenceMCO product) {
        return null;
    }

    public Date findLastTravelDate(RailwayReferenceMCO product) {
        return null;
    }

    public List<String> getProductNumbers(RailwayReferenceMCO product) {
        return TextUtil.isBlank((String)product.getSystemNumber()) ? new ArrayList() : Collections.singletonList(product.getSystemNumber());
    }

    public EntityReference<Person> findIssuingAgent(RailwayReferenceMCO product) {
        ProductHandler handler = product.getRelatedProduct() != null ? GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct()) : null;
        return handler != null ? handler.findIssuingAgent(product.getRelatedProduct()) : null;
    }

    public TravelSubject findTravelSubject(RailwayReferenceMCO product) {
        return TravelSubject.RAILWAY;
    }

    public Date findIssueDate(RailwayReferenceMCO product) {
        return product.getIssueDate();
    }

    public Date findLocalIssueDate(RailwayReferenceMCO product) {
        return product.getLocalIssueDate();
    }

    public void setIssueDate(RailwayReferenceMCO product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    public boolean includeInFinanceDocuments(RailwayReferenceMCO product) {
        return false;
    }

    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) {
        return Collections.emptySet();
    }

    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) {
        return Collections.emptyList();
    }

    public String getBillingItemName(RailwayReferenceMCO product, String relatedInvoiceNumber) {
        return null;
    }

    public Collection<Traveller> getTravellers(RailwayReferenceMCO product) {
        ProductHandler handler = product.getRelatedProduct() != null ? GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct()) : null;
        return handler != null ? handler.getTravellers(product.getRelatedProduct()) : Collections.emptyList();
    }

    public void replaceTraveller(RailwayReferenceMCO product, Traveller oldTraveller, Traveller newTraveller) {
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    public void setOrReplaceTraveller(RailwayReferenceMCO product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller != null) {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    public void updateBillingItems(Collection<BillingItem> items, List<RailwayReferenceMCO> products) {
    }

    public EntityReference<SalesPoint> findSalesPoint(RailwayReferenceMCO product) {
        ProductHandler handler = product.getRelatedProduct() != null ? GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct()) : null;
        return handler != null ? handler.findSalesPoint(product.getRelatedProduct()) : null;
    }

    public ProductStatus getStatus(RailwayReferenceMCO product) {
        return product.getStatus();
    }

    public ProductStatus getBaseStatus(RailwayReferenceMCO product) {
        return product.getStatus();
    }

    public void setStatus(RailwayReferenceMCO product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    public ProductType getProductType(RailwayReferenceMCO product) {
        return ProductType.RAILWAY_REFERENCE_MCO;
    }

    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.RAILWAY_REFERENCE_MCO).collect(Collectors.toSet()));
    }

    public RuleTarget getCommissionRuleTarget() {
        return Targets.RAILWAY_PRODUCT_COMMISSION;
    }

    public EntityReference<Organization> getBlankOwner(RailwayReferenceMCO product) {
        return null;
    }

    public EntityReference<Branch> getBranch(RailwayReferenceMCO product) {
        return null;
    }

    public List<MCOFeesSource> getMcoFeesSources(RailwayReferenceMCO product) {
        return Collections.emptyList();
    }

    public boolean isCompleted(RailwayReferenceMCO product) {
        return product.isCompleted();
    }

    public void setCompleted(RailwayReferenceMCO product, boolean completed) {
        product.setCompleted(completed);
    }

    public boolean isChecked(RailwayReferenceMCO product) {
        return product.isChecked();
    }

    public void setChecked(RailwayReferenceMCO product, boolean checked) {
        product.setChecked(checked);
    }

    public TransportationType getTransportationType(RailwayReferenceMCO product) {
        return null;
    }

    public ServiceLocationType getServiceLocationType(RailwayReferenceMCO product) {
        return null;
    }

    public Date findNearestTravelDate(Date momentOfTime, RailwayReferenceMCO product) {
        return null;
    }

    public RailwayReferenceMCO getPreviousProduct(RailwayReferenceMCO product) {
        return null;
    }

    public void setPreviousProduct(RailwayReferenceMCO product, RailwayReferenceMCO previousProduct) {
    }

    public void setNextProduct(RailwayReferenceMCO product, RailwayReferenceMCO nextProduct) {
    }

    public RailwayReferenceMCO getNextProduct(RailwayReferenceMCO product) {
        return null;
    }

    public void addRelatedProduct(RailwayReferenceMCO product, BaseProduct relatedProduct) {
        product.setRelatedProduct(relatedProduct);
    }

    public List<BaseProduct> getRelatedProducts(RailwayReferenceMCO product) {
        return product.getRelatedProduct() != null ? Collections.singletonList(product.getRelatedProduct()) : Collections.emptyList();
    }

    public ProductCancellationDetails getCancellationDetails(RailwayReferenceMCO product) {
        return null;
    }

    public ProductCategory getProductCategory(RailwayReferenceMCO product) {
        return null;
    }

    public MCOCategory getMCOCategory(RailwayReferenceMCO product) {
        return null;
    }

    public List<GeneralProductTax> getTaxes(RailwayReferenceMCO product) {
        return Collections.emptyList();
    }

    public DictionaryReference<BlankType> getBlankType(RailwayReferenceMCO product) {
        return product.getBlankType();
    }

    public BigDecimal getEquivalentFare(RailwayReferenceMCO product) {
        return null;
    }

    public BigDecimal getServiceFare(RailwayReferenceMCO product) {
        return null;
    }

    public BigDecimal getPenalty(RailwayReferenceMCO product) {
        return null;
    }

    public int getConjunction(RailwayReferenceMCO product) {
        return 0;
    }

    public String getRouteLine(RailwayReferenceMCO product) {
        return null;
    }

    public String getLocalizedRouteLine(RailwayReferenceMCO product) {
        return null;
    }

    public String getCodeRouteLine(RailwayReferenceMCO product) {
        return null;
    }

    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(RailwayReferenceMCO product) {
        return Collections.emptyList();
    }

    public SalesChain getSalesChain(RailwayReferenceMCO product) {
        SalesChain result = new SalesChain();
        result.setDescription(GeneralProductHelper.getPredefinedDescription((PredefinedSalesChainType)PredefinedSalesChainType.OWN, null));
        return result;
    }

    public void updateContractRelations(RailwayReferenceMCO product, List<GeneralProductContractRelationData> relations) {
    }

    public TicketType getTicketType(RailwayReferenceMCO product) {
        return product.getTicketType();
    }

    public void setTicketType(RailwayReferenceMCO product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    public String getPCC(RailwayReferenceMCO product) {
        return null;
    }

    public void updateProductFops(RailwayReferenceMCO product) {
    }

    public void setContractRulesApplied(RailwayReferenceMCO product, boolean value) {
    }

    public List<ValidationMessage> getValidationMessages(RailwayReferenceMCO product) {
        return product.getValidationMessages();
    }

    public EntityReference<Organization> getProvider(RailwayReferenceMCO product) {
        return null;
    }

    public PassengerStatus getPassengerStatus(RailwayReferenceMCO product) {
        return null;
    }

    public boolean isHoldable(RailwayReferenceMCO product) {
        return false;
    }

    public Date getUnholdDate(RailwayReferenceMCO product) {
        return null;
    }

    public String getValidatorNumber(RailwayReferenceMCO product) {
        ProductHandler handler = product.getRelatedProduct() != null ? GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct()) : null;
        return handler != null ? handler.getValidatorNumber(product.getRelatedProduct()) : null;
    }

    @Deprecated
    public DictionaryReference<PassengerType> getPassengerType(RailwayReferenceMCO product) {
        ProductHandler handler = product.getRelatedProduct() != null ? GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct()) : null;
        return handler != null ? handler.getPassengerType(product.getRelatedProduct()) : null;
    }

    public StatisticalData getStatisticalData(RailwayReferenceMCO product) {
        ProductHandler handler = product.getRelatedProduct() != null ? GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct()) : null;
        return handler != null ? handler.getStatisticalData(product.getRelatedProduct()) : null;
    }

    public boolean isStatisticalDataAvailable(RailwayReferenceMCO product) {
        ProductHandler handler = product.getRelatedProduct() != null ? GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct()) : null;
        return handler != null && handler.isStatisticalDataAvailable(product.getRelatedProduct());
    }

    public void newStatisticalData(RailwayReferenceMCO product) {
        ProductHandler handler;
        ProductHandler productHandler = handler = product.getRelatedProduct() != null ? GeneralProductHelper.getHandler((BaseProduct)product.getRelatedProduct()) : null;
        if (handler == null) {
            return;
        }
        handler.newStatisticalData(product.getRelatedProduct());
    }

    public BigDecimal getAddCollect(RailwayReferenceMCO product) {
        return null;
    }

    public TravelSubject getDefaultTravelSubject() {
        return null;
    }

    public RailwayReferenceMCO newInstance() {
        return new RailwayReferenceMCO();
    }

    public String getCarrierNumber(RailwayReferenceMCO product) {
        return null;
    }

    public void setAgent(RailwayReferenceMCO product, EntityReference<Person> agent) {
    }

    public void setComments(RailwayReferenceMCO product, String comments) {
        product.setComments(comments);
    }

    public void setAgency(RailwayReferenceMCO product, EntityReference<Organization> agency) {
    }

    public void setBlankOwner(RailwayReferenceMCO product, EntityReference<Organization> blankOwner) {
    }

    public void setBranch(RailwayReferenceMCO product, EntityReference<Branch> branch) {
    }

    public void setSupplier(RailwayReferenceMCO product, EntityReference<Organization> supplier) {
    }

    public void setSubagency(RailwayReferenceMCO product, EntityReference<Organization> subagency) {
    }

    public void setSalesPoint(RailwayReferenceMCO product, EntityReference<SalesPoint> salesPoint) {
    }

    public void changeFopsPaymentTypes(RailwayReferenceMCO product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
    }

    public void changeFopsAgent(RailwayReferenceMCO product, EntityReference<Person> agent, ContractType contractType) {
    }

    public List<String> getFopsUids(RailwayReferenceMCO product, ContractType contractType) {
        return Collections.emptyList();
    }

    public void setBlankType(RailwayReferenceMCO product, DictionaryReference<BlankType> blankType) {
        product.setBlankType(blankType);
    }

    public Money getBspCommissionValue(RailwayReferenceMCO product) {
        return null;
    }

    public Double getBspCommissionRate(RailwayReferenceMCO product) {
        return null;
    }

    public boolean removeProduct(RailwayReferenceMCO product) {
        return RailwayReferenceMcoHelper.removeProduct(product);
    }

    public boolean removeRelatedProduct(RailwayReferenceMCO product, BaseProduct relatedProduct) {
        return RailwayReferenceMcoHelper.removeRelatedProduct(product, relatedProduct);
    }

    public boolean isAppropriateBillingItem(RailwayReferenceMCO product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return false;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE) {
            return true;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    public boolean isVatIncludeBillingItem(RailwayReferenceMCO product, VatViewMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem) {
        return mode == VatViewMode.ALWAYS || mode == VatViewMode.ALWAYS_EXCEPT_TICKET && billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
    }

    public String getCities(RailwayReferenceMCO product, Locale locale) {
        return null;
    }

    public String getCountries(RailwayReferenceMCO product, Locale locale) {
        return null;
    }

    public Date getFirstStartDate(RailwayReferenceMCO product) {
        return null;
    }

    public Date getLastStartDate(RailwayReferenceMCO product) {
        return null;
    }

    public Date getFirstEndDate(RailwayReferenceMCO product) {
        return null;
    }

    public Date getLastEndDate(RailwayReferenceMCO product) {
        return null;
    }

    public String getDescriptionLine(RailwayReferenceMCO product) {
        return null;
    }

    public DictionaryReference<Airline> getCarrier(RailwayReferenceMCO product) {
        return null;
    }

    public boolean isContractRulesApplied(RailwayReferenceMCO product) {
        return false;
    }

    public boolean isSystemNumberDuplicateAllowed(RailwayReferenceMCO product) {
        return false;
    }

    public String getRfic(RailwayReferenceMCO product) {
        return null;
    }

    public String getRfisc(RailwayReferenceMCO product) {
        return null;
    }

    public String getTourCode(RailwayReferenceMCO product) {
        return null;
    }

    public boolean isDuplicate(RailwayReferenceMCO product) {
        return false;
    }
}

