/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.model.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.railway.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;

public final class RailwayMcoProductHelper {
    public static BigDecimal calculateTotalEquivalentFare(RailwayMcoProduct product) {
        BigDecimal penalty;
        BigDecimal totalEquivalentFare = null;
        BigDecimal tariffEquivalentFare = product.getEquivalentFare();
        if (tariffEquivalentFare != null) {
            totalEquivalentFare = tariffEquivalentFare;
        }
        if ((penalty = product.getPenaltyFare()) != null) {
            totalEquivalentFare = totalEquivalentFare == null ? penalty.negate() : totalEquivalentFare.subtract(penalty);
        }
        return totalEquivalentFare;
    }

    public static BigDecimal calculateTotalEquivalentVat(RailwayMcoProduct product) {
        BigDecimal penaltyVat;
        BigDecimal totalEquivalentVat = null;
        BigDecimal tariffEquivalentVat = product.getEquivalentVat();
        if (tariffEquivalentVat != null) {
            totalEquivalentVat = tariffEquivalentVat;
        }
        if ((penaltyVat = product.getPenaltyVat()) != null) {
            totalEquivalentVat = totalEquivalentVat == null ? penaltyVat.negate() : totalEquivalentVat.subtract(penaltyVat);
        }
        return totalEquivalentVat;
    }

    public static String getRouteString(RailwayMcoProduct product) {
        return RailwayProductHelper.getRouteString(product.getSegments(), false);
    }

    public static List<String> getTravellersNames(RailwayMcoProduct product) {
        return RailwayProductHelper.getTravellersNames(product.getPassengers());
    }

    public static ServiceLocationType getServiceLocationType(RailwayMcoProduct product) {
        return RailwayMcoProductHelper.getTransportationType(product) == TransportationType.DOMESTIC ? ServiceLocationType.DOMESTIC : ServiceLocationType.INTERNATIONAL;
    }

    public static TransportationType getTransportationType(RailwayMcoProduct product) {
        if (product == null) {
            return null;
        }
        return RailwayProductHelper.getTransportationType(product.getSegments());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(RailwayMcoProduct source, RailwayMcoProduct target) throws Exception {
        Reservation sourceRes = source.getReservation();
        source.setReservation(null);
        RailwayMcoProduct sourcePrev = source.getPreviousProduct();
        source.setPreviousProduct(null);
        RailwayMcoProduct sourceNext = source.getNextProduct();
        source.setNextProduct(null);
        ArrayList relatedProducts = new ArrayList(source.getRelatedProducts());
        source.getRelatedProducts().clear();
        ArrayList travellers = new ArrayList(source.getPassengers());
        source.getPassengers().clear();
        ArrayList passengerTypes = new ArrayList(source.getPassengerTypes());
        source.getPassengerTypes().clear();
        HashSet excludedUids = new HashSet();
        travellers.forEach(traveller -> excludedUids.add(traveller.getUid()));
        StatisticalData sourceStatisticalData = source.getStatisticalData();
        if (sourceStatisticalData != null) {
            sourceStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        StatisticalData targetStatisticalData = (StatisticalData)XCloneHelper.clone((XCloneable)source.getStatisticalData(), (boolean)true, excludedUids);
        source.setStatisticalData(null);
        RailwayMcoProduct targetPrev = target.getPreviousProduct();
        target.setPreviousProduct(null);
        RailwayMcoProduct targetNext = target.getNextProduct();
        target.setNextProduct(null);
        try {
            XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        }
        finally {
            source.setReservation(sourceRes);
            source.setPreviousProduct(sourcePrev);
            source.setNextProduct(sourceNext);
            source.getRelatedProducts().addAll(relatedProducts);
            source.getPassengers().addAll(travellers);
            source.getPassengerTypes().addAll(passengerTypes);
            source.setStatisticalData(sourceStatisticalData);
            target.setReservation(sourceRes);
            target.setPreviousProduct(targetPrev);
            target.setNextProduct(targetNext);
            target.getPassengers().addAll(travellers);
            target.getPassengerTypes().addAll(passengerTypes);
            target.setStatisticalData(targetStatisticalData);
            target.setContractRulesApplied(false);
            target.setChecked(false);
            target.setCompleted(false);
            target.getPrepaymentDocuments().clear();
            target.getFopDetalizations().clear();
            if (source.getReservation() != null && !source.getReservation().getProducts().contains(target)) {
                source.getReservation().getProducts().add(target);
            }
        }
    }

    public static SalesChain getSalesChain(RailwayMcoProduct product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static GeneralProductContractRelationData getClientContractRelation(RailwayMcoProduct prod) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)prod);
    }

    public static List<GeneralProductContractRelationData> getContractRelations(RailwayMcoProduct prod) {
        return GeneralProductHelper.getContractRelationsByReflection((BaseProduct)prod);
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(RailwayMcoProduct product, ContractType contractType) {
        return GeneralProductHelper.getUnmodifiableCommissionsByReflection((BaseProduct)product, (ContractType)contractType);
    }

    public static List<GeneralProductFop> getVendorFops(RailwayMcoProduct prod) {
        return RailwayMcoProductHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(RailwayMcoProduct prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = RailwayMcoProductHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(RailwayMcoProduct prod) {
        return RailwayMcoProductHelper.getClientContractRelation(prod).getFops();
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(RailwayMcoProduct prod, boolean autoUpdateSalesChain) {
        return GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)prod, (boolean)autoUpdateSalesChain);
    }

    private static GeneralProductContractRelationData getVendorContractRelation(RailwayMcoProduct prod) {
        return GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)prod);
    }

    public static EntityReference<Organization> getSupplier(RailwayMcoProduct product) {
        return GeneralProductHelper.getContractor((SalesChain)RailwayMcoProductHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(RailwayMcoProduct product, EntityReference<Organization> value) {
        GeneralProductHelper.setContractor((SalesChain)RailwayMcoProductHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(RailwayMcoProduct product) {
        return GeneralProductHelper.getContractor((SalesChain)RailwayMcoProductHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.AGENCY);
    }

    public static void setAgency(RailwayMcoProduct product, EntityReference<Organization> value) {
        GeneralProductHelper.setContractor((SalesChain)RailwayMcoProductHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(RailwayMcoProduct product) {
        return GeneralProductHelper.getContractor((SalesChain)RailwayMcoProductHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY);
    }

    public static boolean isFareFopsRelevant(RailwayMcoProduct product) {
        return GeneralProductHelper.getHandler((BaseProduct)product).isFareFopsRelevant((BaseProduct)product);
    }

    public static void setSubagency(RailwayMcoProduct product, EntityReference<Organization> value) {
        GeneralProductHelper.setContractor((SalesChain)RailwayMcoProductHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, value);
    }

    public static boolean removeProduct(RailwayMcoProduct product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(RailwayMcoProduct product, BaseProduct relatedProduct) {
        product.getRelatedProducts().remove(relatedProduct);
        return true;
    }

    public static String getCities(RailwayMcoProduct product, Locale locale) {
        return RailwayProductHelper.getCities(product.getSegments(), locale);
    }

    public static String getCountries(RailwayMcoProduct product, Locale locale) {
        return RailwayProductHelper.getCountries(product.getSegments(), locale);
    }

    public static void setPassengerType(RailwayMcoProduct product, Traveller traveller, DictionaryReference<PassengerType> passengerType) {
        if (product == null || traveller == null) {
            return;
        }
        product.getPassengerTypes().removeIf(passengerTypeReference -> traveller.equals((Object)passengerTypeReference.getTraveller()));
        if (passengerType == null) {
            return;
        }
        PassengerTypeReference passengerTypeReference2 = new PassengerTypeReference();
        passengerTypeReference2.setTraveller(traveller);
        passengerTypeReference2.setPassengerType(passengerType);
        product.getPassengerTypes().add(passengerTypeReference2);
    }

    @Deprecated
    public static DictionaryReference<PassengerType> getMainPassengerType(RailwayMcoProduct product) {
        LinkedHashSet<DictionaryReference<PassengerType>> passengerTypes = new LinkedHashSet<DictionaryReference<PassengerType>>(RailwayMcoProductHelper.getPassengerTypes(product));
        return RailwayProductHelper.getPassengerTypeDictionaryReference(passengerTypes);
    }

    public static List<DictionaryReference<PassengerType>> getPassengerTypes(RailwayMcoProduct product) {
        return product.getPassengers().stream().map(passenger -> RailwayMcoProductHelper.getPassengerType(product, passenger)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static DictionaryReference<PassengerType> getPassengerType(RailwayMcoProduct product, Traveller traveller) {
        if (traveller == null) {
            return null;
        }
        return product.getPassengerTypes().stream().filter(p -> MiscUtil.equals((Object)p.getTraveller(), (Object)traveller)).map(PassengerTypeReference::getPassengerType).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static int getSeatsCount(RailwayMcoProduct prod) {
        return prod.getSegments().stream().map(s -> s.getPlaces().size()).max(Integer::compareTo).orElse(0);
    }
}

