/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.model.helpers;

import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCardType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public final class RailwayProductDictionaryHelper {
    public static RailwayStation findStationByName(String name) {
        if (TextUtil.isBlank((String)name)) {
            return null;
        }
        Collection<RailwayStation> railwayStations = RailwayProductDictionaryHelper.findStationsByName(name);
        Iterator<RailwayStation> iterator = railwayStations.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public static Collection<RailwayStation> findStationsByName(String name) {
        if (TextUtil.isBlank((String)name)) {
            return Collections.emptySet();
        }
        DictionaryCache cache = DictionaryCache.get();
        Collection railwayStations = cache.search(RailwayStation.class, name).stream().filter(item -> item.getTranslations().values().contains(name)).collect(Collectors.toSet());
        return railwayStations;
    }

    public static Collection<RailwayStation> findStationsByTranslationOrSpellVariant(String name) {
        return RailwayProductDictionaryHelper.findStationsByTranslationOrSpellVariant(name, null);
    }

    public static Collection<RailwayStation> findStationsByTranslationOrSpellVariant(String name, RailwayStationVendorCardType type) {
        if (TextUtil.isBlank((String)name)) {
            return Collections.emptySet();
        }
        return DictionaryCache.get().search(RailwayStation.class, name).stream().filter(item -> item.getTranslations().values().contains(name) || item.getSpellVariants().contains(name)).filter(item -> type == null || item.getVendorCards().size() == 0 || item.getVendorCards().stream().anyMatch(card -> card.getType() == type)).collect(Collectors.toSet());
    }

    public static RailwayStation findStationByCodeVariant(String codeVariant) {
        if (TextUtil.isBlank((String)codeVariant)) {
            return null;
        }
        Collection<RailwayStation> railwayStations = RailwayProductDictionaryHelper.findStationsByAnyCodeVariant(codeVariant);
        Iterator<RailwayStation> iterator = railwayStations.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public static Collection<RailwayStation> findStationsByAnyCodeVariant(String codeVariant) {
        if (TextUtil.isBlank((String)codeVariant)) {
            return Collections.emptySet();
        }
        String[] allCodeSystems = (String[])Arrays.stream(CodeSystem.values()).map(Enum::name).toArray(String[]::new);
        return RailwayProductDictionaryHelper.findStationsByCodeVariant(codeVariant, allCodeSystems);
    }

    public static Collection<RailwayStation> findStationsByCodeVariant(String codeVariant, String ... codeSystems) {
        if (TextUtil.isBlank((String)codeVariant)) {
            return Collections.emptySet();
        }
        return DictionaryCache.get().lookup(RailwayStation.class, codeVariant, codeSystems);
    }

    public static RailwayStation findStationByShortName(String shortName) {
        if (TextUtil.isBlank((String)shortName)) {
            return null;
        }
        Collection<RailwayStation> railwayStations = RailwayProductDictionaryHelper.findStationsByShortName(shortName);
        Iterator<RailwayStation> iterator = railwayStations.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public static Collection<RailwayStation> findStationsByShortName(String shortName) {
        return RailwayProductDictionaryHelper.findStationsByShortName(shortName, null);
    }

    public static Collection<RailwayStation> findStationsByShortName(String shortName, RailwayStationVendorCardType type) {
        if (TextUtil.isBlank((String)shortName)) {
            return Collections.emptySet();
        }
        DictionaryCache cache = DictionaryCache.get();
        Set<Object> railwayStations = new HashSet<RailwayStation>(cache.search(RailwayStation.class, DictSearchCriterion.contains((String)RailwayStation.Property.shortNames.name(), (Object)shortName)));
        railwayStations.addAll(cache.search(RailwayStation.class, DictSearchCriterion.eq((String)RailwayStation.Property.shortName.name(), (Object)shortName)));
        if (type != null) {
            railwayStations = railwayStations.stream().filter(item -> item.getVendorCards().size() == 0 || item.getVendorCards().stream().anyMatch(card -> card.getType() == type)).collect(Collectors.toSet());
        }
        return railwayStations;
    }

    public static Country getCountry(DictionaryReference<RailwayStation> station) {
        DictionaryCache cache = DictionaryCache.get();
        RailwayStation railwayStation = (RailwayStation)cache.resolveReference(station);
        if (railwayStation != null) {
            DictionaryReference countryReference = railwayStation.getCountry();
            return (Country)cache.resolveReference(countryReference);
        }
        return null;
    }
}

