/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.model.rules.standart;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.railway.CarriageType;
import com.gridnine.xtrip.common.model.booking.railway.ServiceClass;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.BasicCommonTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.ClientCreditCardVendorProvider;
import com.gridnine.xtrip.common.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.model.rules.standard.ReservationPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.rules.standart.RailwayProductPropertiesProvider;
import com.gridnine.xtrip.common.railway.model.rules.standart.Targets;
import com.gridnine.xtrip.common.railway.model.rules.standart.ValueTypes;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.slf4j.LoggerFactory;

public enum Properties implements RuleProperty
{
    RAILWAY_PASSENGER_TYPE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONFINED_TO.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PassengerTypes);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PASSENGER_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_PassengerTypes_info), cond.getDisplayName(), RulesHelper.toString((Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            RuleCondition correctedCondition = condition;
            if (condition == Conditions.EQUALS) {
                correctedCondition = Conditions.INCLUDE;
            } else if (condition == Conditions.NOT_EQUALS) {
                correctedCondition = Conditions.EXCLUDE;
            }
            if (Conditions.INCLUDE.equals((Object)correctedCondition)) {
                return RulesHelper.matchesDictRestriction(ps.getPassengerTypes(), (List)((List)value), (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)correctedCondition)) {
                return RulesHelper.matchesDictRestriction(ps.getPassengerTypes(), (List)((List)value), (boolean)false);
            }
            return RulesHelper.matchesContainsOnlyDictRestriction(ps.getPassengerTypes(), (List)((List)value), (boolean)true);
        }
    }
    ,
    RAILWAY_PASSENGER_TYPE_CATEGORIES{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONFINED_TO.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PassengerTypesCategories);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PASSENGER_TYPE_CATEGORY.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_PassengerTypesCategories_info), cond.getDisplayName(), RulesHelper.toString((Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesDictRestriction(ps.getPassengerTypeCategories(), (List)((List)value), (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesDictRestriction(ps.getPassengerTypeCategories(), (List)((List)value), (boolean)false);
            }
            return RulesHelper.matchesContainsOnlyDictRestriction(ps.getPassengerTypeCategories(), (List)((List)value), (boolean)true);
        }
    }
    ,
    RAILWAY_BLANK_OWNERS{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_BLANK_OWNERS);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_BLANK_OWNERS_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction(ps.getBlankOwners(), (Object)value, (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction(ps.getBlankOwners(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    RAILWAY_ISSUE_DATE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ISSUED);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.DATE_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval dateInterval = (DateInterval)value;
            if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return;
            }
            DateFormat dateFormat = 4.getDateFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (dateInterval.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_issueDateIsBefore, (Object[])new Object[]{dateFormat.format(dateInterval.getEndDate())}));
                } else if (dateInterval.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_issueDateIsAfter, (Object[])new Object[]{dateFormat.format(dateInterval.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_issueDateIsInRange, (Object[])new Object[]{dateFormat.format(dateInterval.getBeginDate()), dateFormat.format(dateInterval.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (dateInterval.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_issueDateIsAfter, (Object[])new Object[]{dateFormat.format(dateInterval.getEndDate())}));
                } else if (dateInterval.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_issueDateIsBefore, (Object[])new Object[]{dateFormat.format(dateInterval.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_issueDateIsNotInRange, (Object[])new Object[]{dateFormat.format(dateInterval.getBeginDate()), dateFormat.format(dateInterval.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return true;
            }
            Date date = ps.getIssueDate();
            if (Conditions.PERIOD_WITHIN.equals((Object)condition)) {
                if (di.getBeginDate() == null) {
                    return date != null && date.getTime() <= di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return date != null && date.getTime() >= di.getBeginDate().getTime();
                }
                return date != null && date.getTime() >= di.getBeginDate().getTime() && date.getTime() <= di.getEndDate().getTime();
            }
            if (Conditions.PERIOD_BEYOND.equals((Object)condition)) {
                if (di.getBeginDate() == null) {
                    return date != null && date.getTime() > di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return date != null && date.getTime() < di.getBeginDate().getTime();
                }
                return date != null && (date.getTime() < di.getBeginDate().getTime() || date.getTime() > di.getEndDate().getTime());
            }
            return true;
        }
    }
    ,
    RAILWAY_ISSUE_WEEK_DAY{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_IssueWeekDay);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.WEEK_DAY.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_IssueWeekDay_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)((List)value))}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction((String)DictHelper.getWeekDay((int)propertiesProvider.getIssueDate().getDay()), (List)((List)value), (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction((String)DictHelper.getWeekDay((int)propertiesProvider.getIssueDate().getDay()), (List)((List)value), (boolean)false);
            }
            return true;
        }
    }
    ,
    RAILWAY_ISSUE_TIME{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_IssueTime);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.TIME_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval dateInterval = (DateInterval)value;
            if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return;
            }
            DateFormat timeFormat = RulesEnvironment.getTimeFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (dateInterval.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_IssueTime_info1, (Object[])new Object[]{timeFormat.format(dateInterval.getEndDate())}));
                } else if (dateInterval.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_IssueTime_info2, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_IssueTime_info3, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate()), timeFormat.format(dateInterval.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (dateInterval.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_IssueTime_info2, (Object[])new Object[]{timeFormat.format(dateInterval.getEndDate())}));
                } else if (dateInterval.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_IssueTime_info1, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_issueTimeIsNotInRange, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate()), timeFormat.format(dateInterval.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            DateInterval dateInterval = (DateInterval)value;
            if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return true;
            }
            if (propertiesProvider.getIssueDate() != null) {
                if (Conditions.PERIOD_WITHIN.equals((Object)condition)) {
                    int issueTime = MiscUtil.getTime((Date)propertiesProvider.getIssueDate());
                    int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                    int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                    if (dateInterval.getBeginDate() == null) {
                        return issueTime <= endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return issueTime >= beginTime;
                    }
                    if (beginTime > endTime) {
                        return issueTime >= beginTime || issueTime <= endTime;
                    }
                    return issueTime >= beginTime && issueTime <= endTime;
                }
                if (Conditions.PERIOD_BEYOND.equals((Object)condition)) {
                    int issueTime = MiscUtil.getTime((Date)propertiesProvider.getIssueDate());
                    int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                    int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                    if (dateInterval.getBeginDate() == null) {
                        return issueTime > endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return issueTime < beginTime;
                    }
                    if (beginTime > endTime) {
                        return issueTime < beginTime && issueTime > endTime;
                    }
                    return issueTime < beginTime || issueTime > endTime;
                }
            }
            return true;
        }
    }
    ,
    RAILWAY_VALIDATOR_CODE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_VALIDATOR);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_VALIDATOR_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)ps.getValidatorCode(), (Object)value, (boolean)true);
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)ps.getValidatorCode(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    RAILWAY_DEPARTURE_TIME_LOCAL{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_DepartureTimeLocal);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.TIME_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval dateInterval = (DateInterval)value;
            if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return;
            }
            DateFormat timeFormat = RulesEnvironment.getTimeFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (dateInterval.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_TIME_LOCAL_BEFORE, (Object[])new Object[]{timeFormat.format(dateInterval.getEndDate())}));
                } else if (dateInterval.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_TIME_LOCAL_AFTER, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_TIME_LOCAL_IN_RANGE, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate()), timeFormat.format(dateInterval.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (dateInterval.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_TIME_LOCAL_AFTER, (Object[])new Object[]{timeFormat.format(dateInterval.getEndDate())}));
                } else if (dateInterval.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_TIME_LOCAL_BEFORE, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_TIME_LOCAL_NOT_IN_RANGE, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate()), timeFormat.format(dateInterval.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            DateInterval dateInterval = (DateInterval)value;
            if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return true;
            }
            if (propertiesProvider.getDepartureDateLocal() != null) {
                if (Conditions.PERIOD_WITHIN.equals((Object)condition)) {
                    int issueTime = MiscUtil.getTime((Date)propertiesProvider.getDepartureDateLocal());
                    int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                    int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                    if (dateInterval.getBeginDate() == null) {
                        return issueTime <= endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return issueTime >= beginTime;
                    }
                    if (beginTime > endTime) {
                        return issueTime >= beginTime || issueTime <= endTime;
                    }
                    return issueTime >= beginTime && issueTime <= endTime;
                }
                if (Conditions.PERIOD_BEYOND.equals((Object)condition)) {
                    int issueTime = MiscUtil.getTime((Date)propertiesProvider.getDepartureDateLocal());
                    int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                    int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                    if (dateInterval.getBeginDate() == null) {
                        return issueTime > endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return issueTime < beginTime;
                    }
                    if (beginTime > endTime) {
                        return issueTime < beginTime && issueTime > endTime;
                    }
                    return issueTime < beginTime || issueTime > endTime;
                }
            }
            return true;
        }
    }
    ,
    RAILWAY_ARRIVAL_TIME_LOCAL{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ArrivalTimeLocal);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.TIME_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[0];
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval dateInterval = (DateInterval)value;
            if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return;
            }
            DateFormat timeFormat = RulesEnvironment.getTimeFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (dateInterval.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_TIME_LOCAL_BEFORE, (Object[])new Object[]{timeFormat.format(dateInterval.getEndDate())}));
                } else if (dateInterval.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_TIME_LOCAL_AFTER, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_TIME_LOCAL_IN_RANGE, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate()), timeFormat.format(dateInterval.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (dateInterval.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_TIME_LOCAL_AFTER, (Object[])new Object[]{timeFormat.format(dateInterval.getEndDate())}));
                } else if (dateInterval.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_TIME_LOCAL_BEFORE, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ARRIVAL_TIME_LOCAL_NOT_IN_RANGE, (Object[])new Object[]{timeFormat.format(dateInterval.getBeginDate()), timeFormat.format(dateInterval.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            DateInterval dateInterval = (DateInterval)value;
            if (dateInterval == null || dateInterval.getBeginDate() == null && dateInterval.getEndDate() == null) {
                return true;
            }
            if (propertiesProvider.getArrivalDateLocal() != null) {
                if (Conditions.PERIOD_WITHIN.equals((Object)condition)) {
                    int issueTime = MiscUtil.getTime((Date)propertiesProvider.getArrivalDateLocal());
                    int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                    int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                    if (dateInterval.getBeginDate() == null) {
                        return issueTime <= endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return issueTime >= beginTime;
                    }
                    if (beginTime > endTime) {
                        return issueTime >= beginTime || issueTime <= endTime;
                    }
                    return issueTime >= beginTime && issueTime <= endTime;
                }
                if (Conditions.PERIOD_BEYOND.equals((Object)condition)) {
                    int issueTime = MiscUtil.getTime((Date)propertiesProvider.getArrivalDateLocal());
                    int beginTime = MiscUtil.getTime((Date)dateInterval.getBeginDate());
                    int endTime = MiscUtil.getTime((Date)dateInterval.getEndDate());
                    if (dateInterval.getBeginDate() == null) {
                        return issueTime > endTime;
                    }
                    if (dateInterval.getEndDate() == null) {
                        return issueTime < beginTime;
                    }
                    if (beginTime > endTime) {
                        return issueTime < beginTime && issueTime > endTime;
                    }
                    return issueTime < beginTime || issueTime > endTime;
                }
            }
            return true;
        }
    }
    ,
    BRANCH{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_Branches);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.BRANCHES.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder stringBuilder, RuleCondition ruleCondition, Object value) {
            stringBuilder.append(String.format(L10n.get((String)Messages.RuleProperty_Branches_info), ruleCondition.getDisplayName(), RulesHelper.toString((Collection)((Collection)value), (Function)RulesHelper.toStringFunctionReference(Branch.class, ((Object)((Object)this)).getClass()))));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            List uids = (List)value;
            return RulesHelper.matchesStringRestriction((String)propertiesProvider.getBranchUid(), (Object)uids, (boolean)Conditions.EQUALS.equals((Object)condition));
        }
    }
    ,
    SALES_POINT{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HotelSalesPoint);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.SALES_POINTS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_HotelSalesPointArgs), cond.getDisplayName(), this.toString((List)value)));
        }

        private String toString(List<String> value) {
            if (value == null || value.isEmpty()) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String uid : value) {
                String title = "???";
                try {
                    EntityContainer container = EntityStorage.get().resolve(new EntityReference(uid, SalesPoint.class, null));
                    if (container != null) {
                        title = container.toReference().toString();
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("unable to resolve reference", (Throwable)e);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(title);
            }
            return stringBuilder.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            List uids = (List)value;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)propertiesProvider.getSalesPoint(), (Object)uids, (boolean)true);
            }
            return RulesHelper.matchesStringRestriction((String)propertiesProvider.getSalesPoint(), (Object)uids, (boolean)false);
        }
    }
    ,
    RAILWAY_PNR{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId()};
        }

        public String getDisplayName() {
            return "PNR";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10n.replace((String)"PNR {0} \"{1}\"", (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)ps.getPnr(), (Object)value, (boolean)true);
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return ps.getPnr() != null && RulesHelper.matchesStringRestriction((String)ps.getPnr(), (Object)value, (boolean)false);
            }
            if (Conditions.BEGINS_WITH.equals((Object)condition)) {
                return ps.getPnr() != null && RulesHelper.matchesStringStartsWithRestriction((String)ps.getPnr(), (Object)value, (boolean)true);
            }
            if (Conditions.ENDS_WITH.equals((Object)condition)) {
                return ps.getPnr() != null && RulesHelper.matchesStringEndsWithRestriction((String)ps.getPnr(), (Object)value, (boolean)true);
            }
            return true;
        }
    }
    ,
    RAILWAY_SEGMENTS_AMOUNT{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SegmentsCount);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SegmentsCount_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            int iv = value == null ? 0 : ((Double)value).intValue();
            int numOfSegments = ps.getSegmentsAmount();
            if (Conditions.EQUALS.equals((Object)condition)) {
                return numOfSegments == iv;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return numOfSegments != iv;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return numOfSegments > iv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return numOfSegments >= iv;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return numOfSegments < iv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return numOfSegments <= iv;
            }
            return true;
        }
    }
    ,
    RAILWAY_DEPARTURE_LOCATIONS{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_departStation);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departStationParameters, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicCommonTicketPropertiesProvider ps = (BasicCommonTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getDepartureLocations(), (Object)value, (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getDepartureLocations(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    RAILWAY_ARRIVE_LOCATIONS{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_destinationStation);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_destinationStationParameters, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicCommonTicketPropertiesProvider ps = (BasicCommonTicketPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getArrivalLocations(), (Object)value, (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getArrivalLocations(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    RAILWAY_TRAIN_NUMBERS{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_trainNumber);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_trainNumberParameters, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRangeRestriction(ps.getTrainNumbers(), (Object)value, (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRangeRestriction(ps.getTrainNumbers(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    RAILWAY_CARRIAGE_TYPES{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONTAINS_ONLY.getId(), Conditions.CONFINED_TO.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_coachType);
        }

        public String getRendererId() {
            return ValueTypes.CARRIAGE_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_coachTypeParameters, (Object[])new Object[]{cond.getDisplayName(), 17.values2desc((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getCarriageTypes(), (List)((List)value), (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getCarriageTypes(), (List)((List)value), (boolean)false);
            }
            if (Conditions.CONTAINS_ONLY.equals((Object)condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((CarriageType)items.get(n)).name());
                }
                return RulesHelper.includesOnly(ps.getCarriageTypes(), Collections.singletonList(buf.toString()));
            }
            if (Conditions.CONFINED_TO.equals((Object)condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((CarriageType)items.get(n)).name());
                }
                return RulesHelper.confinedTo((List)RulesHelper.to2DList(ps.getCarriageTypes()), Collections.singletonList(buf.toString()));
            }
            return true;
        }
    }
    ,
    RAILWAY_SERVICE_CLASSES{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONTAINS_ONLY.getId(), Conditions.CONFINED_TO.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SERVICE_CLASSES);
        }

        public String getRendererId() {
            return ValueTypes.SERVICE_CLASS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SERVICE_CLASSES_info, (Object[])new Object[]{cond.getDisplayName(), 18.values2desc((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getServiceClasses(), (List)((List)value), (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getServiceClasses(), (List)((List)value), (boolean)false);
            }
            if (Conditions.CONTAINS_ONLY.equals((Object)condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((ServiceClass)items.get(n)).name());
                }
                return RulesHelper.includesOnly(ps.getServiceClasses(), Collections.singletonList(buf.toString()));
            }
            if (Conditions.CONFINED_TO.equals((Object)condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((ServiceClass)items.get(n)).name());
                }
                return RulesHelper.confinedTo((List)RulesHelper.to2DList(ps.getServiceClasses()), Collections.singletonList(buf.toString()));
            }
            return true;
        }
    }
    ,
    RAILWAY_DEPARTURE_DATES{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.PERIOD_WITHIN.getId(), Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_departureDatesSimple);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.DATE_INTERVAL.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return;
            }
            DateFormat dateFormat = 19.getDateFormat();
            if (Conditions.PERIOD_WITHIN.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departueDateIsBefore, (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departueDateIsAfter, (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departueDateIsInRange, (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
                return;
            }
            if (Conditions.PERIOD_BEYOND.getId().equals(cond.getId())) {
                if (di.getBeginDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departueDateIsAfter, (Object[])new Object[]{dateFormat.format(di.getEndDate())}));
                } else if (di.getEndDate() == null) {
                    buf.append(L10nResourcesManager.getStr((String)Messages.Properties_departueDateIsBefore, (Object[])new Object[]{dateFormat.format(di.getBeginDate())}));
                } else {
                    buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_DEPARTURE_info_beyond, (Object[])new Object[]{dateFormat.format(di.getBeginDate()), dateFormat.format(di.getEndDate())}));
                }
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            DateInterval di = (DateInterval)value;
            if (di == null || di.getBeginDate() == null && di.getEndDate() == null) {
                return true;
            }
            Date date = ps.getDepartureDate();
            if (Conditions.PERIOD_WITHIN.equals((Object)condition)) {
                if (di.getBeginDate() == null) {
                    return date != null && date.getTime() <= di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return date != null && date.getTime() >= di.getBeginDate().getTime();
                }
                return date != null && date.getTime() >= di.getBeginDate().getTime() && date.getTime() <= di.getEndDate().getTime();
            }
            if (Conditions.PERIOD_BEYOND.equals((Object)condition)) {
                if (di.getBeginDate() == null) {
                    return date != null && date.getTime() > di.getEndDate().getTime();
                }
                if (di.getEndDate() == null) {
                    return date != null && date.getTime() < di.getBeginDate().getTime();
                }
                return date != null && (date.getTime() < di.getBeginDate().getTime() || date.getTime() > di.getEndDate().getTime());
            }
            return true;
        }
    }
    ,
    RAILWAY_HOURS_BEFORE_DEPARTURE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_hoursBeforeDepartureDate);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_hoursBeforeDepartureDateWithValues, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            int dv = value == null ? 0 : ((Double)value).intValue();
            int hrs = this.getHoursBeforeDeparture(ps.getDepartureDate());
            if (Conditions.EQUALS.equals((Object)condition)) {
                return hrs == dv;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return hrs != dv;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return hrs > dv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs >= dv;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return hrs < dv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs <= dv;
            }
            return true;
        }

        private int getHoursBeforeDeparture(Date departureDate) {
            return (int)((departureDate.getTime() - new Date().getTime()) / 3600000L);
        }
    }
    ,
    RAILWAY_DAYS_BEFORE_DEPARTURE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_daysBeforeDepartureDate);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_daysBeforeDepartureDateWithValues, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            int dv = value == null ? 0 : ((Double)value).intValue();
            int hrs = this.getDaysBeforeDeparture(ps.getDepartureDate());
            if (Conditions.EQUALS.equals((Object)condition)) {
                return hrs == dv;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return hrs != dv;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return hrs > dv;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs >= dv;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return hrs < dv;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs <= dv;
            }
            return true;
        }

        private int getDaysBeforeDeparture(Date departureDate) {
            if (departureDate == null) {
                return 0;
            }
            Date date = MiscUtil.setDayEndTime((Date)departureDate);
            return (int)((date.getTime() - new Date().getTime()) / 86400000L);
        }
    }
    ,
    RAILWAY_FOP_TYPES{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.CONTAINS_ONLY.getId(), Conditions.CONFINED_TO.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PAYMENT_TYPE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PAYMENT_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_PAYMENT_TYPES_info, (Object[])new Object[]{cond.getDisplayName(), 22.values2desc((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getFopTypes(), (List)((List)value), (boolean)true);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction(ps.getFopTypes(), (List)((List)value), (boolean)false);
            }
            if (Conditions.CONTAINS_ONLY.equals((Object)condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((PaymentType)items.get(n)).name());
                }
                return RulesHelper.includesOnly(ps.getFopTypes(), Collections.singletonList(buf.toString()));
            }
            if (Conditions.CONFINED_TO.equals((Object)condition)) {
                List items = (List)value;
                StringBuilder buf = new StringBuilder();
                for (int n = 0; n < items.size(); ++n) {
                    if (n != 0) {
                        buf.append("-");
                    }
                    buf.append(((PaymentType)items.get(n)).name());
                }
                return RulesHelper.confinedTo((List)RulesHelper.to2DList(ps.getFopTypes()), Collections.singletonList(buf.toString()));
            }
            return true;
        }
    }
    ,
    RAILWAY_PASSENGER_STATUS{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_PassengerStatus);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PASSENGER_STATUS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_PassengerStatus_info), cond.getDisplayName(), RulesHelper.toString((Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction((String)ps.getPassengerStatus(), (List)((List)value), (boolean)true);
            }
            return RulesHelper.matchesEnumRestriction((String)ps.getPassengerStatus(), (List)((List)value), (boolean)false);
        }
    }
    ,
    RAILWAY_GDS_NAME{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_GDS);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.GDS_NAME.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_GDS_info, (Object[])new Object[]{cond.getDisplayName(), 24.values2desc((List)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction((String)ps.getGdsName(), (List)((List)value), (boolean)true);
            }
            return RulesHelper.matchesEnumRestriction((String)ps.getGdsName(), (List)((List)value), (boolean)false);
        }
    }
    ,
    RAILWAY_MCO_CATEGORY{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_RailwayMCO_Category);
        }

        public String getRendererId() {
            return ValueTypes.RAILWAY_MCO_CATEGORY.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_RailwayMCO_CategoryInfo, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            List railwayMcoCategories = (List)value;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return railwayMcoCategories.contains(propertiesProvider.getRailwayMcoCategory());
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return !railwayMcoCategories.contains(propertiesProvider.getRailwayMcoCategory());
            }
            return false;
        }
    }
    ,
    RAILWAY_E_TICKET{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_E_TICKET);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_E_TICKET_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return ps.isEticket() == (value != null && (Boolean)value != false);
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return ps.isEticket() != (value != null && (Boolean)value != false);
            }
            return true;
        }
    }
    ,
    RAILWAY_PREVIOUS_SELL_TOTAL_EQUIVALENT_FARE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SellTotal);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SellTotal_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BigDecimal productPreviousSellTotalEquivalentFare;
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            BigDecimal rulePreviousSellTotalEquivalentFare = value != null ? (BigDecimal)value : BigDecimal.ZERO;
            BigDecimal bigDecimal = productPreviousSellTotalEquivalentFare = propertiesProvider.getPreviousSellTotalEquivalentFare() != null ? propertiesProvider.getPreviousSellTotalEquivalentFare() : BigDecimal.ZERO;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return productPreviousSellTotalEquivalentFare.compareTo(rulePreviousSellTotalEquivalentFare) == 0;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return productPreviousSellTotalEquivalentFare.compareTo(rulePreviousSellTotalEquivalentFare) != 0;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return productPreviousSellTotalEquivalentFare.compareTo(rulePreviousSellTotalEquivalentFare) > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return productPreviousSellTotalEquivalentFare.compareTo(rulePreviousSellTotalEquivalentFare) >= 0;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return productPreviousSellTotalEquivalentFare.compareTo(rulePreviousSellTotalEquivalentFare) < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return productPreviousSellTotalEquivalentFare.compareTo(rulePreviousSellTotalEquivalentFare) <= 0;
            }
            return true;
        }
    }
    ,
    RAILWAY_TOTAL_EQUIVALENT_FARE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_totalCost);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.Properties_totalCost_info, (Object[])new Object[]{cond.getDisplayName(), LocaleManager.get().getCurrentLocaleData().getPriceFormat().format(value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BigDecimal productTotalEquivalentFare;
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            BigDecimal ruleTotalEquivalentFare = value != null ? (BigDecimal)value : BigDecimal.ZERO;
            BigDecimal bigDecimal = productTotalEquivalentFare = propertiesProvider.getTotalEquivalentFare() != null ? propertiesProvider.getTotalEquivalentFare() : BigDecimal.ZERO;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) == 0;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) != 0;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) > 0;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) >= 0;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) < 0;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return productTotalEquivalentFare.compareTo(ruleTotalEquivalentFare) <= 0;
            }
            return true;
        }
    }
    ,
    RAILWAY_CARRIERS{

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_carrier);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.Properties_carrier_info), cond.getDisplayName(), RulesHelper.toString((Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction(propertiesProvider.getCarriers(), (Object)value, (boolean)true);
            }
            return RulesHelper.matchesStringRestriction(propertiesProvider.getCarriers(), (Object)value, (boolean)false);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId()};
        }
    }
    ,
    RAILWAY_TRANSPORTATION_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TRANSPORTATION_TYPE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (cond.hasRightSide()) {
                buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TRANSPORTATION_TYPE_info1, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
            } else {
                buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TRANSPORTATION_TYPE_info2, (Object[])new Object[]{cond.getDisplayName()}));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider propertiesProvider = (RailwayProductPropertiesProvider)propertySet;
            TransportationType transportationType = propertiesProvider.getTransportationType();
            if (transportationType == null) {
                return false;
            }
            boolean isDomestic = Arrays.asList(TransportationType.DOMESTIC, TransportationType.NONE).contains(transportationType);
            if (Conditions.TRANSPORTATION_DOMESTIC.equals((Object)condition)) {
                return isDomestic;
            }
            if (Conditions.TRANSPORTATION_INTRENATIONAL.equals((Object)condition)) {
                return !isDomestic;
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.TRANSPORTATION_DOMESTIC.getId(), Conditions.TRANSPORTATION_INTRENATIONAL.getId()};
        }
    }
    ,
    RAILWAY_ROUTE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.INCLUDE.getId(), Conditions.EXCLUDE.getId(), Conditions.BEGINS_WITH.getId(), Conditions.NOT_BEGINS_WITH.getId(), Conditions.ENDS_WITH.getId(), Conditions.NOT_ENDS_WITH.getId(), Conditions.CONTAINS_ONLY.getId(), Conditions.CONFINED_TO.getId(), Conditions.NOT_CONFINED_TO.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ROUTE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ROUTE_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicCommonTicketPropertiesProvider ps = (BasicCommonTicketPropertiesProvider)propertySet;
            List values = RulesHelper.toStringCollection((Object)value);
            HashSet allLocations = new HashSet(ps.getDepartureLocations());
            allLocations.addAll(ps.getArrivalLocations());
            if (Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.collectionIncludes(allLocations, (List)values);
            }
            if (Conditions.EXCLUDE.equals((Object)condition)) {
                return !RulesHelper.collectionIncludes(allLocations, (List)values);
            }
            if (Conditions.BEGINS_WITH.equals((Object)condition)) {
                return RulesHelper.collectionIncludes((Collection)ps.getDepartureLocations(), (List)values);
            }
            if (Conditions.NOT_BEGINS_WITH.equals((Object)condition)) {
                return !RulesHelper.collectionIncludes((Collection)ps.getDepartureLocations(), (List)values);
            }
            if (Conditions.ENDS_WITH.equals((Object)condition)) {
                return RulesHelper.collectionIncludes((Collection)ps.getArrivalLocations(), (List)values);
            }
            if (Conditions.NOT_ENDS_WITH.equals((Object)condition)) {
                return !RulesHelper.collectionIncludes((Collection)ps.getArrivalLocations(), (List)values);
            }
            if (Conditions.CONTAINS_ONLY.equals((Object)condition)) {
                return RulesHelper.containsOnly((List)ps.getVisitedCities(), (List)values);
            }
            if (Conditions.CONFINED_TO.equals((Object)condition)) {
                return RulesHelper.confinedTo((List)ps.getVisitedCities(), (List)RulesHelper.getCorrectedValues((List)values));
            }
            if (Conditions.NOT_CONFINED_TO.equals((Object)condition)) {
                return !RulesHelper.confinedTo((List)ps.getVisitedCities(), (List)RulesHelper.getCorrectedValues((List)values));
            }
            return true;
        }
    }
    ,
    RAILWAY_TRAVEL_DURATION{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId(), Conditions.GREATER_THAN.getId(), Conditions.GREATER_THAN_OR_EQUALS.getId(), Conditions.LESS_THAN.getId(), Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_TRAVEL_DURATION);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_TRAVEL_DURATION_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            int val;
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            int travelDuration = ps.getTravelDuration();
            int n = val = value == null ? 0 : ((Number)value).intValue();
            if (Conditions.EQUALS.equals((Object)condition)) {
                return travelDuration == val;
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return travelDuration != val;
            }
            if (Conditions.GREATER_THAN.equals((Object)condition)) {
                return travelDuration > val;
            }
            if (Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return travelDuration >= val;
            }
            if (Conditions.LESS_THAN.equals((Object)condition)) {
                return travelDuration < val;
            }
            if (Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return travelDuration <= val;
            }
            return true;
        }
    }
    ,
    RAILWAY_CREDIT_CARD_TYPE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CreditCardType);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.CREDIT_CARD_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_CreditCardType_info), cond.getDisplayName(), RulesHelper.values2text((List)((List)value))));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (propertySet instanceof ClientCreditCardVendorProvider) {
                ClientCreditCardVendorProvider prov = (ClientCreditCardVendorProvider)propertySet;
                if (Conditions.EQUALS.equals((Object)condition)) {
                    return RulesHelper.matchesEnumRestriction((String)prov.getClientCreditCardVendor(), (List)((List)value), (boolean)true);
                }
                return RulesHelper.matchesEnumRestriction((String)prov.getClientCreditCardVendor(), (List)((List)value), (boolean)false);
            }
            return false;
        }
    }
    ,
    RAILWAY_ISSUE_AGENT{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RULES_PROPERTIES_ISSUING_AGENT);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PERSONS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RULES_PROPERTIES_ISSUING_AGENT_X, (Object[])new Object[]{cond.getDisplayName(), ((List)value).size() + L10n.get((String)Messages.Pieces)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (ps.getAgent() == null) {
                return false;
            }
            List uids = (List)value;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)ps.getAgent().getUid(), (Object)uids, (boolean)true);
            }
            return RulesHelper.matchesStringRestriction((String)ps.getAgent().getUid(), (Object)uids, (boolean)false);
        }
    }
    ,
    RAILWAY_RESERVATION_TYPE{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId(), Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ReservationType);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.RESERVATION_TYPE.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_ReservationType_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)((List)value))}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            RailwayProductPropertiesProvider ps = (RailwayProductPropertiesProvider)propertySet;
            if (Conditions.EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction((String)ps.getReservationType(), (List)((List)value), (boolean)true);
            }
            if (Conditions.NOT_EQUALS.equals((Object)condition)) {
                return RulesHelper.matchesEnumRestriction((String)ps.getReservationType(), (List)((List)value), (boolean)false);
            }
            return true;
        }
    }
    ,
    RAILWAY_CREATED_BY_CLIENT{

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CREATED_BY_CLIENT);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.RAILWAY_PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_CREATED_BY_CLIENT_info1) : L10n.get((String)Messages.RuleProperty_CREATED_BY_CLIENT_info2));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            ReservationPropertiesProvider ps = (ReservationPropertiesProvider)propertySet;
            return Boolean.valueOf(ps.isCreatedByClient()).equals(value);
        }
    };


    public String getId() {
        return this.name();
    }

    protected String buildRegularExpression(String prefix, String[] values, String suffix) {
        StringBuilder sb = new StringBuilder("^");
        for (int n = 0; n < values.length; ++n) {
            String value = values[n];
            if (n != 0) {
                sb.append("|");
            }
            if (!TextUtil.isBlank((String)prefix)) {
                sb.append(prefix);
            }
            sb.append(value);
            if (TextUtil.isBlank((String)suffix)) continue;
            sb.append(suffix);
        }
        sb.append("$");
        return sb.toString();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();

    protected String[] getValues(Object value) {
        List res = RulesHelper.toStringCollection((Object)value);
        return res.toArray(new String[0]);
    }

    protected static DateFormat getDateFormat() {
        return new SimpleDateFormat("yyyyMMdd");
    }

    static <E extends Enum<E>> String values2str(List<E> data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (Enum item : data) {
            if (item == null) continue;
            if (res.length() != 0) {
                res.append(",");
            }
            res.append(item.name());
        }
        return res.length() > 0 ? res.toString() : null;
    }

    static <E extends Enum<E>> List<E> str2values(String data, Class<E> cls) {
        if (TextUtil.isBlank((String)data)) {
            return Collections.emptyList();
        }
        ArrayList<Enum> enumList = new ArrayList<Enum>();
        for (String enumName : data.split(",")) {
            Enum[] enumConstants;
            if (TextUtil.isBlank((String)enumName)) continue;
            for (Enum enumConst : enumConstants = (Enum[])cls.getEnumConstants()) {
                if (!enumConst.name().equals(enumName)) continue;
                enumList.add(enumConst);
            }
        }
        return enumList;
    }

    static <E extends Enum<E>> String values2desc(List<E> data) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (Enum item : data) {
            if (item == null) continue;
            if (res.length() != 0) {
                res.append(",");
            }
            res.append(item);
        }
        return res.length() > 0 ? res.toString() : L10n.get((String)Messages.Properties_notSelected);
    }

    static <E extends Enum<E>> String[] values2array(List<E> data) {
        if (data == null || data.isEmpty()) {
            return new String[0];
        }
        String[] res = new String[data.size()];
        for (int n = 0; n < data.size(); ++n) {
            Enum item = (Enum)data.get(n);
            if (item == null) continue;
            res[n] = item.name();
        }
        return res;
    }
}

