/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.model.rules.standart;

import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayStationDictionaryHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class RailwayProxyHelper {
    public static Set<String> collectRailwayStationCodes(Set<String> codes) {
        if (codes.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet stations = new HashSet();
        for (String code : codes) {
            if (TextUtil.isBlank((String)code)) continue;
            stations.addAll(DictHelper.getDictionaryItemsByCode(RailwayStation.class, (String)code));
        }
        if (stations.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        DictionaryCache dictCache = DictionaryCache.get();
        for (RailwayStation station : stations) {
            Country country;
            Object value2;
            for (Object value2 : station.getCodeVariants().values()) {
                if (TextUtil.isBlank((String)value2)) continue;
                result.add((String)value2);
            }
            String shortName = RailwayStationDictionaryHelper.getAnyShortName(station);
            if (!TextUtil.isBlank((String)shortName)) {
                result.add(shortName);
            }
            value2 = station.getTranslations().values().iterator();
            while (value2.hasNext()) {
                String value3 = (String)value2.next();
                if (TextUtil.isBlank((String)value3)) continue;
                result.add(value3);
            }
            if (station.getCountry() != null && (country = (Country)dictCache.resolveReference(station.getCountry())) != null) {
                result.addAll(RulesHelper.collectCountryCodes((Country)country));
                for (String value4 : country.getTranslations().values()) {
                    if (TextUtil.isBlank((String)value4)) continue;
                    result.add(value4);
                }
            }
            result.addAll(RulesHelper.collectGeoCodes((DictionaryReference)station.getGeoLocation(), (boolean)false, (boolean)true));
        }
        if (codes.containsAll(result)) {
            return new HashSet<String>(codes);
        }
        return result;
    }
}

