/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.parsers.helpers;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class RailwayProductParsersHelper {
    public static TransactionType getTransactionType(ProductStatus status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case SELL: {
                return TransactionType.SELL;
            }
            case REFUND: {
                return TransactionType.REFUND;
            }
            case VOID: {
                return TransactionType.CANCEL;
            }
        }
        return null;
    }

    public static ProductStatus getStatus(TransactionType transactionType) {
        if (transactionType == null) {
            return null;
        }
        switch (transactionType) {
            case SELL: {
                return ProductStatus.SELL;
            }
            case REFUND: {
                return ProductStatus.REFUND;
            }
            case CANCEL: {
                return ProductStatus.VOID;
            }
        }
        return null;
    }

    public static Date parseIssueDateFromMoscowZone(DateFormat format, String string) throws ParseException {
        Date date = format.parse(string);
        TimeZone tzLocal = TimeZone.getDefault();
        TimeZone tzMoscow = TimeZone.getTimeZone("Europe/Moscow");
        int diff = tzLocal.getRawOffset() - tzMoscow.getRawOffset();
        Calendar calLocal = Calendar.getInstance();
        calLocal.setTime(date);
        calLocal.add(14, diff);
        return calLocal.getTime();
    }
}

