/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.reports.render.salesreports.spgd;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.railway.reports.render.salesreports.spgd.SPGDDivergencePoiWorksheetHandler;
import com.gridnine.xtrip.common.railway.reports.render.salesreports.spgd.SPGDDivergenceReportTicket;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.DivergenceReportDocument;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportBatchData;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.ReportHelper;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportType;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetDefinition;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import com.gridnine.xtrip.common.reports.render.ReportRenderHandler;
import com.gridnine.xtrip.common.reports.render.salesreports.BaseWorksheetData;
import com.gridnine.xtrip.common.util.IoUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class SPGDFilesDivergenceReportRenderHandler
implements ReportRenderHandler {
    public String getId() {
        return "spgd-files-report";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityContainer<? extends BaseReportDocument> renderReport(Map<String, Object> data) throws Exception {
        try (InputStream is = IoUtil.getResourceInputStream((File)this.getTemplateFile());){
            EntityContainer<DivergenceReportDocument> entityContainer;
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                this.prepareReport(wb, data);
                wb.write((OutputStream)os);
                ReportFile file = new ReportFile();
                String reportTitle = ReportHelper.cleanUpFileName((String)this.getReportTitle(data));
                file.setTitle(reportTitle);
                file.setContentType(ContentType.EXCEL);
                file.setContent(os.toByteArray());
                String value = reportTitle + ".xls";
                file.setName(value);
                EntityContainer<DivergenceReportDocument> result = this.createContainer(file, data);
                ((BaseReportDocument)result.getEntity()).setCreated(new Date());
                entityContainer = result;
            }
            catch (Throwable throwable) {
                os.close();
                throw throwable;
            }
            os.close();
            return entityContainer;
        }
    }

    protected void prepareReport(HSSFWorkbook wb, Map<String, Object> data) throws Exception {
        List<PoiWorksheetData<SPGDDivergenceReportTicket>> workbookData = this.createDataList();
        this.initializeDataList(workbookData, data);
        List messages = (List)data.get("key-messages");
        Collections.sort(workbookData, new Comparator<PoiWorksheetData<SPGDDivergenceReportTicket>>(){

            @Override
            public int compare(PoiWorksheetData<SPGDDivergenceReportTicket> t1, PoiWorksheetData<SPGDDivergenceReportTicket> t2) {
                return t1.getProirity() - t2.getProirity();
            }
        });
        for (PoiWorksheetData<SPGDDivergenceReportTicket> wData : workbookData) {
            PoiWorksheetDefinition definition = wData.getDefinition();
            if (definition == null) {
                SystemHelper.addMessage((Collection)messages, (String)("No definition defined for worksheet " + wData.getBatchId()), null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
                continue;
            }
            PoiWorksheetHandler handler = definition.getHandler();
            if (handler == null) {
                SystemHelper.addMessage((Collection)messages, (String)("No handler defined for worksheet " + wData.getBatchId()), null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
                continue;
            }
            HSSFSheet sheet = ExcelUtils.findSheet((HSSFWorkbook)wb, (String)definition.getWorksheetTemplateName());
            if (sheet == null) {
                SystemHelper.addMessage((Collection)messages, (String)("Unable to find sheet " + definition.getWorksheetTemplateName()), null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
                continue;
            }
            handler.fill(wb, sheet, wData, data);
        }
        HSSFFormulaEvaluator.evaluateAllFormulaCells((HSSFWorkbook)wb);
        wb.setActiveSheet(0);
        wb.setSelectedTab(0);
    }

    protected List<PoiWorksheetData<SPGDDivergenceReportTicket>> createDataList() {
        ArrayList<PoiWorksheetData<SPGDDivergenceReportTicket>> result = new ArrayList<PoiWorksheetData<SPGDDivergenceReportTicket>>();
        result.add((PoiWorksheetData<SPGDDivergenceReportTicket>)new BaseWorksheetData<SPGDDivergenceReportTicket>(){

            public String getBatchId() {
                return "batch_is_spgd";
            }

            public PoiWorksheetDefinition<SPGDDivergenceReportTicket> getDefinition() {
                return Definitions.SPGD;
            }

            public int getProirity() {
                return 1;
            }
        });
        return result;
    }

    protected EntityContainer<DivergenceReportDocument> createContainer(ReportFile file, Map<String, Object> data) {
        List messages = (List)data.get("key-messages");
        EntityContainer container = new EntityContainer(DivergenceReportDocument.class);
        ((DivergenceReportDocument)container.getEntity()).getFiles().add(file);
        ((DivergenceReportDocument)container.getEntity()).setReportType(ReportType.OTHER);
        ((DivergenceReportDocument)container.getEntity()).getMessages().addAll(messages);
        ((DivergenceReportDocument)container.getEntity()).setParameters((DivergenceReportParameters)data.get("key-report-params"));
        return container;
    }

    protected void initializeDataList(List<PoiWorksheetData<SPGDDivergenceReportTicket>> worksheetDataList, Map<String, Object> data) {
        List messages = (List)data.get("key-messages");
        List<ReportBatchData> batches = (List<ReportBatchData>)data.get("key-batch-data-list");
        if (batches == null) {
            SystemHelper.addMessage((Collection)messages, (String)"\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u0430\u043d\u043d\u044b\u0445 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442", null, (MessageType)MessageType.MESSAGE, (Object[])new Object[0]);
            batches = Collections.emptyList();
        }
        for (ReportBatchData batch : batches) {
            PoiWorksheetData<SPGDDivergenceReportTicket> currentWorksheetData = null;
            for (PoiWorksheetData<SPGDDivergenceReportTicket> worksheetData : worksheetDataList) {
                if (!worksheetData.getBatchId().equals(batch.getBatchId())) continue;
                currentWorksheetData = worksheetData;
                break;
            }
            if (currentWorksheetData == null) {
                SystemHelper.addMessage((Collection)messages, (String)String.format("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043b\u0438\u0441\u0442 \u0434\u043b\u044f \u0433\u0440\u0443\u043f\u043f\u044b \u0434\u0430\u043d\u043d\u044b\u0445 \"%s\"", batch.getBatchId()), null, (MessageType)MessageType.WARNING, (Object[])new Object[0]);
                continue;
            }
            currentWorksheetData.getTickets().addAll(batch.getTickets());
        }
    }

    protected String getReportTitle(Map<String, Object> data) {
        ReportParameters params = (ReportParameters)data.get("key-report-params");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Date periodBegin = params.getPeriodBegin();
        Date periodEnd = params.getPeriodEnd();
        StringBuilder stringBuilder = new StringBuilder();
        if (periodBegin != null) {
            stringBuilder.append(dateFormat.format(periodBegin));
        } else {
            stringBuilder.append("?");
        }
        stringBuilder.append("-");
        if (periodEnd != null) {
            stringBuilder.append(dateFormat.format(periodEnd));
        } else {
            stringBuilder.append("?");
        }
        return String.format("\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0441\u0432\u0435\u0440\u043a\u0435 \u0421\u041f\u0416\u0414 \u0437\u0430 %s", stringBuilder);
    }

    protected File getTemplateFile() throws IOException {
        File file = IoUtil.url2file((URL)this.getClass().getResource("/salesreports/" + this.getTemplateFileName()));
        if (!file.exists() || !file.canRead()) {
            throw new IOException("Template " + file.getCanonicalPath() + " was not found or can`t be read");
        }
        return file;
    }

    protected String getTemplateFileName() {
        return "divergence_spgd.xls";
    }

    public static enum Definitions implements PoiWorksheetDefinition<SPGDDivergenceReportTicket>
    {
        SPGD{

            @Override
            public PoiWorksheetHandler<SPGDDivergenceReportTicket> getHandler() {
                return new SPGDDivergencePoiWorksheetHandler();
            }
        };


        public String getWorksheetTemplateName() {
            return this.name();
        }

        public PoiWorksheetHandler<SPGDDivergenceReportTicket> getHandler() {
            return null;
        }
    }
}

