/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.sirena2000.console;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardAction;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.gds.sirena2000.console.ParametersData;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.sirena2000.SirenaRequest;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.TextUtil;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.scene.Node;

class SirenaConsolePane
extends BaseContentPane {
    private static final Charset UTF_8 = Charset.forName("utf-8");
    protected final ObservableMutex mutex;
    protected final ComboBoxWidget<GdsName> gdsWidget;
    protected final EntityBoxWidget<BaseGdsAccount> gdsAccountWidget;
    protected final EntityBoxWidget<Organization> agencyWidget;
    protected final EntityBoxWidget<Organization> subAgencyWidget;
    protected final EntityBoxWidget<Organization> clientWidget;
    protected final EntityBoxWidget<SalesPoint> salesPointWidget;
    protected final EntityBoxWidget<Person> agentWidget;
    protected final EntityBoxWidget<Person> customerWidget;
    protected final BooleanValueWidget securedWidget;
    protected final BooleanValueWidget privilegedWidget;
    protected final TextAreaWidget requestWidget;
    private final TextAreaWidget responseWidget;
    private final InvalidationListener acquiredListener;

    SirenaConsolePane(ObservableMutex mtx) {
        this.mutex = mtx;
        final CardsContainer cc = new CardsContainer();
        GridContainer parametersPane = new GridContainer(3);
        this.gdsWidget = new ComboBoxWidget(true);
        this.gdsWidget.setValue((Object)GdsName.SIRENA);
        parametersPane.getCells().add((Object)new GridCell("GDS", this.gdsWidget));
        this.gdsAccountWidget = new EntityBoxWidget(BaseGdsAccount.class, false);
        this.gdsAccountWidget.setListParametersSupplier(() -> {
            IndexListParameters result = new IndexListParameters();
            result.setIndexType(GdsAccountIndex.class);
            result.getSearchCriterions().add(SearchCriterion.eq((String)GdsAccountIndex.Property.gds.name(), (Object)GdsName.SIRENA));
            ListParametersHelper.setColumns((IndexListParameters)result, (String[])new String[]{GdsAccountIndex.Property.name.name(), GdsAccountIndex.Property.agency.name()});
            return result;
        });
        parametersPane.getCells().add((Object)new GridCell("\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", this.gdsAccountWidget));
        parametersPane.getCells().add((Object)GridCell.NEW_ROW_MARKER);
        this.agencyWidget = new EntityBoxWidget(Organization.class, false);
        this.agencyWidget.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        parametersPane.getCells().add((Object)new GridCell("\u0410\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e", this.agencyWidget));
        this.subAgencyWidget = new EntityBoxWidget(Organization.class, false);
        this.subAgencyWidget.setListParametersSupplier(ControllerInterceptorsHelper::getAgencies);
        parametersPane.getCells().add((Object)new GridCell("\u0421\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e", this.subAgencyWidget));
        this.clientWidget = new EntityBoxWidget(Organization.class, false);
        this.clientWidget.setListParametersSupplier(ControllerInterceptorsHelper::getClients);
        parametersPane.getCells().add((Object)new GridCell("\u041a\u043b\u0438\u0435\u043d\u0442", this.clientWidget));
        this.salesPointWidget = new EntityBoxWidget(SalesPoint.class, false);
        this.salesPointWidget.setListParametersSupplier(ControllerInterceptorsHelper::getSalesPoints);
        parametersPane.getCells().add((Object)new GridCell("\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u043e\u0434\u0430\u0436", this.salesPointWidget));
        this.agentWidget = new EntityBoxWidget(Person.class, false);
        this.agentWidget.setListParametersSupplier(ControllerInterceptorsHelper::getAgents);
        parametersPane.getCells().add((Object)new GridCell("\u0410\u0433\u0435\u043d\u0442", this.agentWidget));
        this.customerWidget = new EntityBoxWidget(Person.class, false);
        this.customerWidget.setListParametersSupplier(ControllerInterceptorsHelper::getPersonsSortByCode);
        parametersPane.getCells().add((Object)new GridCell("\u041f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044c", this.customerWidget));
        this.securedWidget = new BooleanValueWidget(false, false);
        parametersPane.getCells().add((Object)new GridCell("\u0417\u0430\u0449\u0438\u0449\u0451\u043d\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441", (Node)this.securedWidget));
        this.privilegedWidget = new BooleanValueWidget(false, false);
        parametersPane.getCells().add((Object)new GridCell("\u041f\u0440\u0438\u0432\u0438\u043b\u0435\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441", (Node)this.privilegedWidget));
        cc.getCards().add((Object)new Card("parameters", UiCardsContainer.Style.EXPANDED, "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", (Node)parametersPane));
        this.requestWidget = new TextAreaWidget(false);
        Card card = new Card("request", UiCardsContainer.Style.EXPANDED, "\u0417\u0430\u043f\u0440\u043e\u0441", (Node)this.requestWidget);
        card.setAdaptiveHeight(true);
        card.getActions().add((Object)new CardAction<TextAreaWidget>(){

            public boolean isEnabled(Card<TextAreaWidget> crd) {
                return !SirenaConsolePane.this.mutex.isAcquired() && !TextUtil.isBlank((String)SirenaConsolePane.this.requestWidget.getValue());
            }

            public double getWeight() {
                return 0.0;
            }

            public String getName(Card<TextAreaWidget> crd) {
                return "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c";
            }

            public String getDescription(Card<TextAreaWidget> crd) {
                return "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441";
            }

            public void execute(Card<TextAreaWidget> crd, boolean alt) {
                SirenaConsolePane.this.sendRequest();
            }
        });
        this.requestWidget.valueProperty().addListener((s, o, n) -> card.revalidateActions());
        this.acquiredListener = obj -> card.revalidateActions();
        this.mutex.acquiredProperty().addListener(this.acquiredListener);
        cc.getCards().add((Object)card);
        this.responseWidget = new TextAreaWidget(true);
        card = new Card("response", UiCardsContainer.Style.EXPANDED, "\u041e\u0442\u0432\u0435\u0442", (Node)this.responseWidget);
        card.setAdaptiveHeight(true);
        cc.getCards().add((Object)card);
        this.composePane((Node)new TilesSpace(1){
            {
                super(x0);
                this.addTiles(new Tile[]{new Tile("main", "\u0421\u0438\u0440\u0435\u043d\u0430-2000", null, (Node)cc)});
            }
        }, null, null, null);
        FxUtil.submitToFxThread(() -> ParametersData.restore(this));
    }

    public void dispose() {
        this.mutex.acquiredProperty().removeListener(this.acquiredListener);
        super.dispose();
    }

    protected void sendRequest() {
        ParametersData.save(this);
        SalesContext salesContext = new SalesContext();
        salesContext.setAgency(this.agencyWidget.getValue());
        salesContext.setSubagency(this.subAgencyWidget.getValue());
        salesContext.setClient(this.clientWidget.getValue());
        salesContext.setSalesPoint(this.salesPointWidget.getValue());
        salesContext.setAgent(this.agentWidget.getValue());
        salesContext.setCustomer(this.customerWidget.getValue());
        EntityReference gdsAccountRef = this.gdsAccountWidget.getValue();
        GdsName gds = (GdsName)this.gdsWidget.getValue();
        boolean secured = this.securedWidget.getValue();
        boolean privileged = this.privilegedWidget.getValue();
        byte[] reqData = this.requestWidget.getValue().getBytes(UTF_8);
        Notifications.get().submitTask(() -> {
            Map data = new HashMap<String, Object>();
            if (gdsAccountRef != null) {
                EntityContainer gdsAccountCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), gdsAccountRef);
                data.put("GDS_ACCOUNT", gdsAccountCtr);
                data.put("GDS", ((BaseGdsAccount)gdsAccountCtr.getEntity()).getGds());
            } else {
                data.put("GDS", gds);
            }
            data.put("SALES_CONTEXT", salesContext);
            SirenaRequest sirenaRequest = new SirenaRequest();
            sirenaRequest.setSecure(secured);
            sirenaRequest.setPrivileged(privileged);
            data.put("SIRENA_REQUEST", sirenaRequest);
            data.put("SIRENA_BINARY_REQUEST", reqData);
            data = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processSync(ServiceInvocationContext.get(), "gds:sirena:custom-request", data);
            byte[] resData = (byte[])data.get("SIRENA_BINARY_RESPONSE");
            FxUtil.submitToFxThread(() -> this.responseWidget.setValue(new String(resData, UTF_8)));
        }, this.mutex);
    }
}

