/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.boot;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.ObjectFactory;
import org.java.plugin.Plugin;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.ApplicationInitializer;
import org.java.plugin.boot.ApplicationPlugin;
import org.java.plugin.boot.BootErrorHandler;
import org.java.plugin.boot.DefaultPluginsCollector;
import org.java.plugin.boot.PluginsCollector;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestInfo;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.util.ExtendedProperties;
import org.java.plugin.util.IoUtil;
import org.java.plugin.util.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApplicationInitializer
implements ApplicationInitializer {
    protected static final String PARAM_APPLICATION_PLUGIN = "org.java.plugin.boot.applicationPlugin";
    protected static final String PARAM_INTEGRITY_CHECK_MODE = "org.java.plugin.boot.integrityCheckMode";
    protected static final String PARAM_PLUGINS_COLLECTOR = "org.java.plugin.boot.pluginsCollector";
    protected static final String PARAM_PLUGINS_WHITE_LIST = "org.java.plugin.boot.pluginsWhiteList";
    protected static final String PARAM_PLUGINS_BLACK_LIST = "org.java.plugin.boot.pluginsBlackList";
    private Log log;
    private ExtendedProperties config;
    private String integrityCheckMode;
    private PluginsCollector collector;
    private Set<String> whiteList;
    private Set<String> blackList;

    @Override
    public void configure(ExtendedProperties configuration) throws Exception {
        String log4jConfigKey = "log4j.configuration";
        if (System.getProperty(log4jConfigKey) == null) {
            File log4jConfig;
            if (configuration.containsKey(log4jConfigKey)) {
                log4jConfig = new File(configuration.getProperty(log4jConfigKey));
                if (log4jConfig.isFile()) {
                    System.setProperty(log4jConfigKey, IoUtil.file2url(log4jConfig).toExternalForm());
                } else {
                    System.setProperty(log4jConfigKey, configuration.getProperty(log4jConfigKey));
                }
            } else {
                log4jConfig = new File(configuration.getProperty("applicationRoot") + File.separator + "log4j.properties");
                if (!log4jConfig.isFile()) {
                    log4jConfig = new File(configuration.getProperty("applicationRoot") + File.separator + "log4j.xml");
                }
                if (log4jConfig.isFile()) {
                    try {
                        System.setProperty(log4jConfigKey, IoUtil.file2url(log4jConfig).toExternalForm());
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                }
            }
        }
        this.log = LogFactory.getLog(this.getClass());
        this.log.info((Object)"logging system initialized");
        this.log.info((Object)("application root is " + configuration.getProperty("applicationRoot")));
        this.config = configuration;
        this.integrityCheckMode = configuration.getProperty(PARAM_INTEGRITY_CHECK_MODE, "full");
        this.collector = this.getCollectorInstance(configuration.getProperty(PARAM_PLUGINS_COLLECTOR));
        this.collector.configure(configuration);
        this.log.debug((Object)("plug-ins collector is " + this.collector));
        try {
            this.whiteList = this.loadList(configuration.getProperty(PARAM_PLUGINS_WHITE_LIST, null));
        }
        catch (IOException ioe) {
            this.log.warn((Object)"failed loading white list", (Throwable)ioe);
        }
        if (this.whiteList != null) {
            this.log.debug((Object)"white list loaded");
        }
        try {
            this.blackList = this.loadList(configuration.getProperty(PARAM_PLUGINS_BLACK_LIST, null));
        }
        catch (IOException ioe) {
            this.log.warn((Object)"failed loading black list", (Throwable)ioe);
        }
        if (this.blackList != null) {
            this.log.debug((Object)"black list loaded");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> loadList(String location) throws IOException {
        if (location == null) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(location), "UTF-8"));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                result.add(line);
            }
        }
        finally {
            reader.close();
        }
        this.log.debug((Object)("read " + result.size() + " list items from " + location));
        return result;
    }

    private PluginsCollector getCollectorInstance(String className) {
        if (className != null) {
            try {
                return (PluginsCollector)Class.forName(className).newInstance();
            }
            catch (InstantiationException ie) {
                this.log.warn((Object)("failed instantiating plug-ins collector " + className), (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                this.log.warn((Object)("failed instantiating plug-ins collector " + className), (Throwable)iae);
            }
            catch (ClassNotFoundException cnfe) {
                this.log.warn((Object)("failed instantiating plug-ins collector " + className), (Throwable)cnfe);
            }
        }
        return new DefaultPluginsCollector();
    }

    @Override
    public Application initApplication(BootErrorHandler errorHandler, String[] args) throws Exception {
        this.log.debug((Object)"collecting plug-in locations");
        Collection<PluginManager.PluginLocation> pluginLocations = this.collector.collectPluginLocations();
        this.log.debug((Object)("collected " + pluginLocations.size() + " plug-in locations, instantiating plug-in manager"));
        PluginManager pluginManager = ObjectFactory.newInstance(this.config).createManager();
        pluginLocations = this.filterPluginLocations(pluginManager.getRegistry(), pluginLocations);
        this.log.debug((Object)(pluginLocations.size() + " plug-in locations remain after " + "applying filters, publishing plug-ins"));
        pluginManager.publishPlugins(pluginLocations.toArray(new PluginManager.PluginLocation[pluginLocations.size()]));
        if (!"off".equalsIgnoreCase(this.integrityCheckMode)) {
            this.log.debug((Object)"checking plug-ins set integrity");
            IntegrityCheckReport integrityCheckReport = pluginManager.getRegistry().checkIntegrity("light".equalsIgnoreCase(this.integrityCheckMode) ? null : pluginManager.getPathResolver());
            this.log.info((Object)("integrity check done: errors - " + integrityCheckReport.countErrors() + ", warnings - " + integrityCheckReport.countWarnings()));
            if (integrityCheckReport.countErrors() != 0) {
                this.log.info((Object)this.integrityCheckReport2str(integrityCheckReport));
                if (!errorHandler.handleError(ResourceManager.getMessage("org.java.plugin.boot", "integrityCheckFailed"), integrityCheckReport)) {
                    return null;
                }
            } else if (this.log.isDebugEnabled() && (integrityCheckReport.countErrors() > 0 || integrityCheckReport.countWarnings() > 0)) {
                this.log.debug((Object)this.integrityCheckReport2str(integrityCheckReport));
            }
        }
        String appPluginId = this.config.getProperty(PARAM_APPLICATION_PLUGIN);
        this.log.info((Object)("application plug-in is " + appPluginId));
        Plugin appPlugin = pluginManager.getPlugin(appPluginId);
        this.log.debug((Object)("got application plug-in " + appPlugin + ", initializing application"));
        if (!(appPlugin instanceof ApplicationPlugin)) {
            this.log.error((Object)("application plug-in class " + appPlugin.getClass().getName() + " doesn't assignable with " + ApplicationPlugin.class.getName()));
            throw new ClassCastException(appPlugin.getClass().getName());
        }
        return ((ApplicationPlugin)appPlugin).initApplication(this.config.getSubset(appPluginId + "."), args);
    }

    protected String integrityCheckReport2str(IntegrityCheckReport report) {
        StringBuilder buf = new StringBuilder();
        buf.append("integrity check report:\r\n");
        buf.append("-------------- REPORT BEGIN -----------------\r\n");
        for (IntegrityCheckReport.ReportItem item : report.getItems()) {
            buf.append("\tseverity=").append((Object)item.getSeverity()).append("; code=").append((Object)item.getCode()).append("; message=").append(item.getMessage()).append("; source=").append(item.getSource()).append("\r\n");
        }
        buf.append("-------------- REPORT END -----------------");
        return buf.toString();
    }

    protected Collection<PluginManager.PluginLocation> filterPluginLocations(PluginRegistry registry, Collection<PluginManager.PluginLocation> pluginLocations) throws ManifestProcessingException {
        if (this.whiteList == null && this.blackList == null) {
            return pluginLocations;
        }
        LinkedList<PluginManager.PluginLocation> result = new LinkedList<PluginManager.PluginLocation>();
        for (PluginManager.PluginLocation pluginLocation : pluginLocations) {
            ManifestInfo manifestInfo = registry.readManifestInfo(pluginLocation.getManifestLocation());
            if (this.whiteList != null) {
                if (!this.isPluginInList(registry, manifestInfo, this.whiteList)) continue;
                result.add(pluginLocation);
                continue;
            }
            if (this.isPluginInList(registry, manifestInfo, this.blackList)) continue;
            result.add(pluginLocation);
        }
        return result;
    }

    private boolean isPluginInList(PluginRegistry registry, ManifestInfo manifestInfo, Set<String> list) {
        if (list.contains(manifestInfo.getId())) {
            return true;
        }
        return list.contains(registry.makeUniqueId(manifestInfo.getId(), manifestInfo.getVersion()));
    }
}

