/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.gds.model.ChartersSettingsVM;
import com.gridnine.xtrip.client.fx.gds.settings.model.ChartersSettingsContainer;
import com.gridnine.xtrip.client.fx.gds.settings.model.ChartersSettingsContainerController;
import com.gridnine.xtrip.client.fx.gds.settings.model.ChartersSettingsContainerGeneralVM;
import com.gridnine.xtrip.client.fx.gds.settings.model.ChartersSettingsContainerVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.BaseRootEntityHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.gds.model.ChartersCityListEntry;
import com.gridnine.xtrip.common.gds.model.ChartersSettings;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.system.BasicSystemSettingsIndex;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class ChartersSettingsHandler
extends BaseRootEntityHandler<ChartersSettings, Void, ChartersSettingsContainerVM, ChartersSettingsContainer> {
    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return BasicSystemSettingsIndex.class;
    }

    protected void configureController(List<BiConsumer<DataTransferPackage<ChartersSettings, Void>, ChartersSettingsContainerVM>> toVM, List<BiConsumer<ChartersSettingsContainerVM, DataTransferPackage<ChartersSettings, Void>>> fromVM) {
        toVM.add((dtp, vm) -> {
            ChartersSettings model = (ChartersSettings)dtp.getContainer().getEntity();
            ChartersSettingsContainerGeneralVM generalPanel = vm.getGeneralPanel();
            generalPanel.setName(model.getName());
            generalPanel.setBefore(Integer.valueOf(model.getSearchDaysBefore()));
            generalPanel.setAfter(Integer.valueOf(model.getSearchDaysAfter()));
            generalPanel.setBack(Integer.valueOf(model.getSearchDaysToBack()));
            model.getCityList().forEach(city -> {
                ChartersSettingsVM result = new ChartersSettingsVM();
                result.setDepart(city.getOrigin());
                result.setArrive(city.getDestinations().stream().collect(Collectors.joining(", ")));
                vm.getCitiesPanel().add(result);
            });
        });
        fromVM.add((vm, dtp) -> {
            ChartersSettings model = (ChartersSettings)dtp.getContainer().getEntity();
            ChartersSettingsContainerGeneralVM generalPanel = vm.getGeneralPanel();
            model.setName(generalPanel.getName());
            model.setSearchDaysBefore(generalPanel.getBefore().intValue());
            model.setSearchDaysAfter(generalPanel.getAfter().intValue());
            model.setSearchDaysToBack(generalPanel.getBack().intValue());
            vm.getCitiesPanel().forEach(cityVM -> {
                ChartersCityListEntry result = new ChartersCityListEntry();
                HashSet<String> arriveCityHashSet = new HashSet<String>(Arrays.asList(cityVM.getArrive().split(", ")));
                result.setOrigin(cityVM.getDepart());
                result.getDestinations().clear();
                result.getDestinations().addAll(arriveCityHashSet);
                model.getCityList().add(result);
            });
        });
    }

    protected ViewController<ChartersSettingsContainer, ChartersSettingsContainerVM> createSpaceController(boolean readonly) {
        return new ChartersSettingsContainerController(readonly);
    }

    protected ChartersSettingsContainerVM createVM() {
        return new ChartersSettingsContainerVM();
    }

    public Class<ChartersSettings> getEntityClass() {
        return ChartersSettings.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }
}

