/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.pg.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BillingTransactionCategory;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionStatus;
import com.gridnine.xtrip.common.model.system.BillingTransactionType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;

public class BillingTransactionQueryBuilder {
    private final SearchQuery query = new SearchQuery();

    public BillingTransactionQueryBuilder withAgency(EntityReference<Organization> agency) {
        this.addCriteria(SearchCriterion.eq((String)BillingTransactionIndex.Property.agency.name(), agency));
        return this;
    }

    private void addCriteria(SearchCriterion criterion) {
        this.query.getCriteria().getCriterions().add(criterion);
    }

    public BillingTransactionQueryBuilder withClient(EntityReference<Organization> client) {
        this.addCriteria(SearchCriterion.eq((String)BillingTransactionIndex.Property.client.name(), client));
        return this;
    }

    public BillingTransactionQueryBuilder withAuthCode(String code) {
        this.addCriteria(SearchCriterion.eq((String)BillingTransactionIndex.Property.authCode.name(), (Object)code));
        return this;
    }

    public BillingTransactionQueryBuilder withFinDocNumber(String finDocNumber) {
        this.addCriteria(SearchCriterion.eq((String)BillingTransactionIndex.Property.finDocNumber.name(), (Object)finDocNumber));
        return this;
    }

    public BillingTransactionQueryBuilder withReference(EntityReference<? extends BaseEntity> ref) {
        this.addCriteria(SearchCriterion.eq((String)BillingTransactionIndex.Property.referencedEntity.name(), ref));
        return this;
    }

    public BillingTransactionQueryBuilder withCategory(BillingTransactionCategory category) {
        this.addCriteria(SearchCriterion.eq((String)BillingTransactionIndex.Property.category.name(), (Object)category));
        return this;
    }

    public BillingTransactionQueryBuilder withPaymentType(PaymentType pt) {
        this.addCriteria(SearchCriterion.eq((String)BillingTransactionIndex.Property.paymentType.name(), (Object)pt));
        return this;
    }

    public BillingTransactionQueryBuilder withContractType(ContractType ct) {
        this.addCriteria(SearchCriterion.eq((String)BillingTransactionIndex.Property.contractType.name(), (Object)ct));
        return this;
    }

    public BillingTransactionQueryBuilder withStatus(BillingTransactionStatus status) {
        this.addCriteria(SearchCriterion.eq((String)BillingTransactionIndex.Property.status.name(), (Object)status));
        return this;
    }

    public BillingTransactionQueryBuilder withType(BillingTransactionType ct) {
        this.addCriteria(SearchCriterion.eq((String)BillingTransactionIndex.Property.type.name(), (Object)ct));
        return this;
    }

    public BillingTransactionQueryBuilder withTransactionCode(String code) {
        this.addCriteria(SearchCriterion.eq((String)BillingTransactionIndex.Property.transactionCode.name(), (Object)code));
        return this;
    }

    public BillingTransactionQueryBuilder withResultMode(ResultMode resultMode) {
        this.query.setResultMode(resultMode);
        return this;
    }

    public SearchQuery getInstance() {
        return this.query;
    }
}

