/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.pg.rules;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.pg.model.PgName;
import com.gridnine.xtrip.common.pg.rules.PGParametersActionsProvider;
import com.gridnine.xtrip.common.pg.rules.Targets;
import com.gridnine.xtrip.common.pg.rules.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.net.URL;
import java.util.Arrays;

public enum Actions implements RuleAction
{
    APPLICABLE_PG{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            PgName[] pg = (PgName[])value;
            if (pg.length == 0) {
                return;
            }
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleAction_PGSetApplicable_info, (Object[])new Object[]{CollectionUtil.collectionToString(Arrays.asList(pg), (String)", ", (boolean)false)}));
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_PGSetApplicable);
        }

        public String getRendererId() {
            return ValueTypes.PG_LIST.name();
        }

        public boolean hasValue() {
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PG_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"applicable-PG\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            PGParametersActionsProvider as = (PGParametersActionsProvider)proxy.getActionSet();
            for (PgName pg : (PgName[])value) {
                as.addApplicablePG(pg.name());
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    PG_ACCOUNT{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_PGSetAccount);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleAction_PGSetAccount_info, (Object[])new Object[]{value}));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PG_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"pg-account\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            PGParametersActionsProvider as = (PGParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setPgAccount((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    PG_PASSWORD{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_PGSetPassword);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(L10n.get((String)Messages.RuleAction_PGSetPassword_info));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PG_PARAMETERS.getId()};
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"pg-password\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            PGParametersActionsProvider as = (PGParametersActionsProvider)proxy.getActionSet();
            if (!TextUtil.isBlank((String)((String)value))) {
                as.setPgPassword((String)value);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    PG_SERVICE_URL{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_PGSetAddress);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            String str = (String)value;
            buf.append(L10n.get((String)Messages.RuleAction_PGSetAddress_info) + " " + str);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"pg-address\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            PGParametersActionsProvider as = (PGParametersActionsProvider)proxy.getActionSet();
            String str = (String)value;
            boolean hasScheme = str.contains("://");
            if (!hasScheme) {
                str = "http://" + str;
            }
            URL url = new URL(str);
            as.setPgServiceUrl(url);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PG_PARAMETERS.getId()};
        }
    }
    ,
    PG_RETURN_URL{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_PGSetRedirect);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            String str = (String)value;
            buf.append(L10n.get((String)Messages.RuleAction_PGSetRedirect_info) + " " + str);
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "\"pg-redirect-address\"";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            PGParametersActionsProvider as = (PGParametersActionsProvider)proxy.getActionSet();
            String str = (String)value;
            boolean hasScheme = str.contains("://");
            if (!hasScheme) {
                str = "http://" + str;
            }
            URL url = new URL(str);
            as.setPgRedirectUrl(url);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PG_PARAMETERS.getId()};
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();
}

