/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.rpc;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public abstract class BaseRefundReceiptProperties
implements Serializable,
XSerializable {
    private final Collection<EntityReference<TemplateDocument>> templateRefs = new ArrayList<EntityReference<TemplateDocument>>();
    private final Map<String, EntityReference<BookingFile>> productUids2BookingFileRefs = new HashMap<String, EntityReference<BookingFile>>();
    private final List<DictionaryReference<InformationNote>> notes = new ArrayList<DictionaryReference<InformationNote>>();
    private boolean isPrint;

    protected BaseRefundReceiptProperties() {
    }

    protected BaseRefundReceiptProperties(Collection<EntityReference<TemplateDocument>> templateRefs, Map<String, EntityReference<BookingFile>> productUids2BookingFileRefs, List<DictionaryReference<InformationNote>> notesRefs) {
        this.templateRefs.addAll(templateRefs);
        this.productUids2BookingFileRefs.putAll(productUids2BookingFileRefs);
        this.notes.addAll(notesRefs);
    }

    public Collection<EntityReference<TemplateDocument>> getTemplateRefs() {
        return this.templateRefs;
    }

    public Map<String, EntityReference<BookingFile>> getProductsWithBookings() {
        return this.productUids2BookingFileRefs;
    }

    public List<DictionaryReference<InformationNote>> getNotes() {
        return this.notes;
    }

    public boolean isPrint() {
        return this.isPrint;
    }

    public void setPrint(boolean print) {
        this.isPrint = print;
    }

    public void fromXML(Element elm) throws Exception {
        this.templateRefs.clear();
        for (Element objElm : XmlUtil.getElements((Element)elm, (String)"templateRef")) {
            EntityReference templateRef;
            if (objElm == null) continue;
            String className = objElm.getAttribute("class");
            if (TextUtil.isBlank((String)className)) {
                String ecUid = XmlUtil.getValue((Element)objElm, (String)"uid");
                String refCaption = XmlUtil.getValue((Element)objElm, (String)"caption");
                Class etType = XHelper.getClass((String)XmlUtil.getValue((Element)objElm, (String)"type"));
                templateRef = new EntityReference(ecUid, etType, refCaption);
            } else {
                templateRef = (EntityReference)XHelper.readObject((Element)elm, (String)"templateRef");
            }
            this.templateRefs.add((EntityReference<TemplateDocument>)templateRef);
        }
        this.notes.clear();
        this.notes.addAll(XHelper.readCollection((Element)elm, (String)"notes"));
    }

    public void toXML(Element elm) throws Exception {
        for (EntityReference<TemplateDocument> templateRef : this.templateRefs) {
            XHelper.writeObject((Element)elm, (String)"templateRef", templateRef);
        }
        XHelper.writeCollection((Element)elm, (String)"notes", this.notes);
    }
}

