/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.rpc;

import com.gridnine.xtrip.common.fx.rpc.BaseItineraryReceiptProperties;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PersonPositionReference;
import com.gridnine.xtrip.common.model.profile.Signature;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.sun.org.apache.xerces.internal.dom.DeferredElementImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CertificateOfCompletedFlightProperties
extends BaseItineraryReceiptProperties {
    private static final long serialVersionUID = 5330432879157175420L;
    private final List<EntityReference<TemplateDocument>> templateRefs = new ArrayList<EntityReference<TemplateDocument>>();
    private Boolean useFacsimile;
    private final Map<String, EntityReference<BookingFile>> productUids2BookingFileRefs = new HashMap<String, EntityReference<BookingFile>>();
    private final List<Signature> signatures = new ArrayList<Signature>();

    public CertificateOfCompletedFlightProperties() {
    }

    public CertificateOfCompletedFlightProperties(Collection<EntityReference<TemplateDocument>> templateRefs, Boolean useFacsimile, Map<String, EntityReference<BookingFile>> productUids2BookingFileRefs, List<Signature> signatures) {
        this.templateRefs.addAll(templateRefs);
        this.useFacsimile = useFacsimile;
        this.productUids2BookingFileRefs.clear();
        this.productUids2BookingFileRefs.putAll(productUids2BookingFileRefs);
        this.signatures.addAll(signatures);
    }

    public Collection<EntityReference<TemplateDocument>> getTemplateRefs() {
        return this.templateRefs;
    }

    public Boolean isUseFacsimile() {
        return this.useFacsimile;
    }

    @Override
    public Map<String, EntityReference<BookingFile>> getProductsWithBookings() {
        return this.productUids2BookingFileRefs;
    }

    public List<Signature> getSignatures() {
        return this.signatures;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        Element[] items;
        String value;
        this.templateRefs.clear();
        Element objElm = XmlUtil.getElement((Element)elm, (String)"templateRef");
        if (objElm != null) {
            String className = objElm.getAttribute("class");
            if (TextUtil.isBlank((String)className)) {
                String ecUid = XmlUtil.getValue((Element)objElm, (String)"uid");
                String refCaption = XmlUtil.getValue((Element)objElm, (String)"caption");
                Class etType = XHelper.getClass((String)XmlUtil.getValue((Element)objElm, (String)"type"));
                this.templateRefs.add((EntityReference<TemplateDocument>)new EntityReference(ecUid, etType, refCaption));
            } else {
                this.templateRefs.add((EntityReference<TemplateDocument>)XHelper.readObject((Element)elm, (String)"templateRef"));
            }
        } else {
            this.templateRefs.addAll(XHelper.readCollection((Element)elm, (String)"templateRefs"));
        }
        objElm = XmlUtil.getElement((Element)elm, (String)"useFacsimile");
        this.useFacsimile = objElm != null ? (TextUtil.isBlank((String)(value = XmlUtil.getValue((Element)objElm))) ? Boolean.FALSE : Boolean.valueOf(value)) : Boolean.FALSE;
        objElm = XmlUtil.getElement((Element)elm, (String)"signatures");
        if (objElm != null && (items = XmlUtil.getElements((Element)objElm, (String)"item")).length > 0) {
            for (Element element : items) {
                Signature signature = new Signature();
                String uid = XmlUtil.getValue((Element)element, (String)"uid");
                String comment = XmlUtil.getValue((Element)element, (String)"comment");
                L10nString title = XHelper.readLocalizationString((Element)element, (String)"title");
                String position = XmlUtil.getValue((Element)element, (String)"position");
                String useAgent = XmlUtil.getValue((Element)element, (String)"useAgent");
                Element signer = XmlUtil.getElement((Element)element, (String)"signer");
                if (signer == null) {
                    return;
                }
                EntityReference personEntityReference = new EntityReference();
                personEntityReference.fromXML(signer);
                PersonPositionReference positionReference = null;
                if (!TextUtil.isBlank((String)position)) {
                    positionReference = new PersonPositionReference();
                    positionReference.fromXML(element);
                    positionReference.setCode(position);
                    XPathFactory xPathFactory = XPathFactory.newInstance();
                    XPath xPath = xPathFactory.newXPath();
                    XPathExpression xPathExpression = xPath.compile(".//position[@caption]");
                    NodeList nl = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODE);
                    String caption = ((DeferredElementImpl)nl).getAttribute("caption");
                    positionReference.setCaption(caption);
                }
                if (!TextUtil.isBlank((String)useAgent)) {
                    signature.setUseAgent(Boolean.parseBoolean(useAgent));
                }
                signature.setUid(uid);
                signature.setComment(comment);
                if (title != null) {
                    signature.getTitle().getValues().clear();
                    signature.getTitle().getValues().putAll(title.getValues());
                }
                signature.setPosition((DictionaryReference)positionReference);
                signature.setSigner(personEntityReference);
                this.signatures.add(signature);
            }
        }
    }

    @Override
    public void toXML(Element elm) throws Exception {
        XHelper.writeCollection((Element)elm, (String)"templateRefs", this.templateRefs);
        XHelper.writeObject((Element)elm, (String)"useFacsimile", (Object)this.useFacsimile);
        XHelper.writeObject((Element)elm, (String)"signatures", this.signatures);
    }
}

