/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.security.acl;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclPrincipal;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.DoubleKeyHashMap;
import com.gridnine.xtrip.common.util.DoubleKeyMap;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class AclChangeRegistry
implements Serializable {
    private static final long serialVersionUID = 9115280873632480943L;
    private final Map<String, AclChange<AclGroup, AclGroupData>> groups = new HashMap<String, AclChange<AclGroup, AclGroupData>>();
    private final Map<String, AclChange<AclUser, AclUserData>> users = new HashMap<String, AclChange<AclUser, AclUserData>>();
    private final DoubleKeyMap<String, String, AclEntryChange> entries = new DoubleKeyHashMap();

    public Map<String, AclChange<AclGroup, AclGroupData>> getGroups() {
        return this.groups;
    }

    public Map<String, AclChange<AclUser, AclUserData>> getUsers() {
        return this.users;
    }

    public DoubleKeyMap<String, String, AclEntryChange> getEntries() {
        return this.entries;
    }

    public void add(AclGroupData group) {
        AclChange<Object, AclGroupData> change = this.groups.get(((AclGroup)group.getPrincipal()).getId());
        if (change == null) {
            change = new AclChange();
            this.groups.put(((AclGroup)group.getPrincipal()).getId(), change);
        } else if (change.getType() == AclChangeType.DELETE) {
            ((AclGroup)group.getPrincipal()).setUid(((AclGroup)change.getData().getPrincipal()).getUid());
        }
        if (change.getType() != AclChangeType.DELETE) {
            change.setType(AclChangeType.ADD);
        } else {
            change.setType(AclChangeType.EDIT);
        }
        change.setData(group);
        this.debug("add group");
    }

    public void edit(AclGroupData group) {
        AclChange<Object, AclGroupData> change = this.groups.get(((AclGroup)group.getPrincipal()).getId());
        if (change == null) {
            change = new AclChange();
            this.groups.put(((AclGroup)group.getPrincipal()).getId(), change);
        } else if (change.getType() == AclChangeType.DELETE) {
            ((AclGroup)group.getPrincipal()).setUid(((AclGroup)change.getData().getPrincipal()).getUid());
        }
        if (change.getType() != AclChangeType.ADD) {
            change.setType(AclChangeType.EDIT);
        } else {
            change.setType(AclChangeType.ADD);
        }
        change.setData(group);
        this.debug("edit group");
    }

    public void delete(AclGroupData group) {
        AclChange<Object, AclGroupData> change = this.groups.get(((AclGroup)group.getPrincipal()).getId());
        if (change == null) {
            change = new AclChange();
            this.groups.put(((AclGroup)group.getPrincipal()).getId(), change);
        }
        if (change.getType() == AclChangeType.ADD) {
            this.groups.remove(((AclGroup)group.getPrincipal()).getId());
        }
        change.setType(AclChangeType.DELETE);
        change.setData(group);
        this.debug("delete group");
    }

    public void add(AclUserData user) {
        AclChange<Object, AclUserData> change = this.users.get(((AclUser)user.getPrincipal()).getId());
        if (change == null) {
            change = new AclChange();
            this.users.put(((AclUser)user.getPrincipal()).getId(), change);
        } else if (change.getType() == AclChangeType.DELETE) {
            ((AclUser)user.getPrincipal()).setUid(((AclUser)change.getData().getPrincipal()).getUid());
            user.getAccount().setUid(change.getData().getAccount().getUid());
        }
        if (change.getType() != AclChangeType.DELETE) {
            change.setType(AclChangeType.ADD);
        } else {
            change.setType(AclChangeType.EDIT);
        }
        change.setData(user);
        this.debug("add user");
    }

    public void edit(AclUserData user) {
        AclChange<Object, AclUserData> change = this.users.get(((AclUser)user.getPrincipal()).getId());
        if (change == null) {
            change = new AclChange();
            this.users.put(((AclUser)user.getPrincipal()).getId(), change);
        } else if (change.getType() == AclChangeType.DELETE) {
            ((AclUser)user.getPrincipal()).setUid(((AclUser)change.getData().getPrincipal()).getUid());
        }
        if (change.getType() != AclChangeType.ADD) {
            change.setType(AclChangeType.EDIT);
        } else {
            change.setType(AclChangeType.ADD);
        }
        change.setData(user);
        this.debug("edit user");
    }

    public void delete(AclUserData data) {
        AclChange<Object, AclUserData> change = this.users.get(((AclUser)data.getPrincipal()).getId());
        if (change == null) {
            change = new AclChange();
            this.users.put(((AclUser)data.getPrincipal()).getId(), change);
        }
        if (change.getType() == AclChangeType.ADD) {
            this.users.remove(((AclUser)data.getPrincipal()).getId());
        }
        change.setType(AclChangeType.DELETE);
        change.setData(data);
        this.debug("delete user");
    }

    public void add(AclEntryData entry) {
        AclEntryChange change = (AclEntryChange)this.entries.get((Object)entry.getEntry().getPrincipalId(), (Object)entry.getEntry().getResourceId());
        if (change == null) {
            change = new AclEntryChange();
            this.entries.put((Object)entry.getEntry().getPrincipalId(), (Object)entry.getEntry().getResourceId(), (Object)change);
        } else if (change.getType() == AclChangeType.DELETE) {
            entry.getEntry().setUid(change.getData().getEntry().getUid());
        }
        if (change.getType() != AclChangeType.DELETE) {
            change.setType(AclChangeType.ADD);
        } else {
            change.setType(AclChangeType.EDIT);
        }
        change.setData(entry);
        this.debug("add entry");
    }

    public void edit(AclEntryData entry) {
        AclEntryChange change = (AclEntryChange)this.entries.get((Object)entry.getEntry().getPrincipalId(), (Object)entry.getEntry().getResourceId());
        if (change == null) {
            change = new AclEntryChange();
            this.entries.put((Object)entry.getEntry().getPrincipalId(), (Object)entry.getEntry().getResourceId(), (Object)change);
        } else if (change.getType() == AclChangeType.DELETE) {
            entry.getEntry().setUid(change.getData().getEntry().getUid());
        }
        if (change.getType() != AclChangeType.ADD) {
            change.setType(AclChangeType.EDIT);
        } else {
            change.setType(AclChangeType.ADD);
        }
        change.setData(entry);
        this.debug("edit entry");
    }

    public void delete(AclEntryData entry) {
        AclEntryChange change = (AclEntryChange)this.entries.get((Object)entry.getEntry().getPrincipalId(), (Object)entry.getEntry().getResourceId());
        if (change == null) {
            change = new AclEntryChange();
            this.entries.put((Object)entry.getEntry().getPrincipalId(), (Object)entry.getEntry().getResourceId(), (Object)change);
        }
        if (change.getType() == AclChangeType.ADD) {
            this.entries.remove((Object)entry.getEntry().getPrincipalId(), (Object)entry.getEntry().getResourceId());
        }
        change.setType(AclChangeType.DELETE);
        change.setData(entry);
        this.debug("delete entry");
    }

    public boolean isEmpty() {
        return this.groups.isEmpty() && this.users.isEmpty() && this.entries.isEmpty();
    }

    public void clear() {
        this.groups.clear();
        this.users.clear();
        this.entries.clear();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Groups");
        stringBuilder.append("\n");
        for (AclChange<AclGroup, AclGroupData> aclChange : this.groups.values()) {
            stringBuilder.append("\t" + ((AclGroup)aclChange.getData().getPrincipal()).getId() + " | " + (Object)((Object)aclChange.getType()));
            stringBuilder.append("\n");
        }
        stringBuilder.append("Users");
        stringBuilder.append("\n");
        for (AclChange<Object, AclPrincipalData> aclChange : this.users.values()) {
            stringBuilder.append("\t" + ((AclUser)((AclUserData)aclChange.getData()).getPrincipal()).getId() + " | " + (Object)((Object)aclChange.getType()));
            stringBuilder.append("\n");
        }
        stringBuilder.append("Entries");
        stringBuilder.append("\n");
        for (AclEntryChange aclEntryChange : this.entries.values()) {
            stringBuilder.append("\t" + aclEntryChange.getData().getEntry().getPrincipalId() + "/" + aclEntryChange.getData().getEntry().getResourceId() + " | " + (Object)((Object)aclEntryChange.getType()));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private void debug(String title) {
    }

    public static class AclEntryData
    implements Serializable {
        private static final long serialVersionUID = 6353783127747191811L;
        private AclEntry entry;

        public AclEntry getEntry() {
            return this.entry;
        }

        public void setEntry(AclEntry entry) {
            this.entry = entry;
        }

        public String toString() {
            return this.getEntry() != null ? this.getEntry().toString() : null;
        }
    }

    public static class AclUserData
    extends AclPrincipalData<AclUser> {
        private static final long serialVersionUID = -43438381411305640L;
        private UserAccount account;
        private String password;
        private EntityReference<Person> profile;
        private boolean userChanged;
        private boolean accountChanged;
        private boolean profileChanged;

        public UserAccount getAccount() {
            return this.account;
        }

        public void setAccount(UserAccount account) {
            this.account = account;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setProfile(EntityReference<Person> profile) {
            this.profile = profile;
        }

        public EntityReference<Person> getProfile() {
            return this.profile;
        }

        public boolean isUserChanged() {
            return this.userChanged;
        }

        public void setUserChanged(boolean userChanged) {
            this.userChanged = userChanged;
        }

        public boolean isAccountChanged() {
            return this.accountChanged;
        }

        public void setAccountChanged(boolean accountChanged) {
            this.accountChanged = accountChanged;
        }

        public boolean isProfileChanged() {
            return this.profileChanged;
        }

        public void setProfileChanged(boolean profileChanged) {
            this.profileChanged = profileChanged;
        }
    }

    public static class AclGroupData
    extends AclPrincipalData<AclGroup> {
        private static final long serialVersionUID = -4908693082030668007L;
    }

    public static abstract class AclPrincipalData<P extends AclPrincipal>
    implements Serializable {
        private static final long serialVersionUID = 6697260535631026286L;
        private P principal;

        public P getPrincipal() {
            return this.principal;
        }

        public void setPrincipal(P principal) {
            this.principal = principal;
        }

        public String toString() {
            return this.principal != null ? this.principal.toString() : null;
        }
    }

    public static class AclEntryChange
    implements Serializable {
        private static final long serialVersionUID = -8360395865574906105L;
        private AclChangeType type;
        private AclEntryData data;

        public AclChangeType getType() {
            return this.type;
        }

        public void setType(AclChangeType type) {
            this.type = type;
        }

        public AclEntryData getData() {
            return this.data;
        }

        public void setData(AclEntryData data) {
            this.data = data;
        }
    }

    public static class AclChange<P extends AclPrincipal, D extends AclPrincipalData<P>>
    implements Serializable {
        private static final long serialVersionUID = 2095090248739050705L;
        private AclChangeType action;
        private D data;

        public AclChangeType getType() {
            return this.action;
        }

        public void setType(AclChangeType action) {
            this.action = action;
        }

        public D getData() {
            return this.data;
        }

        public void setData(D data) {
            this.data = data;
        }
    }

    public static enum AclChangeType {
        ADD,
        EDIT,
        DELETE;

    }
}

