/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.standard.helpers;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FxProductsHelper {
    static Comparator<ProductsGraphNode> comparator = new Comparator<ProductsGraphNode>(){

        @Override
        public int compare(ProductsGraphNode o1, ProductsGraphNode o2) {
            int res = this.getRelationIndex(o1) - this.getRelationIndex(o2);
            if (res != 0) {
                return res;
            }
            return TextUtil.compare((String)o1.caption, (String)o2.caption, (boolean)false, (boolean)true);
        }

        private int getRelationIndex(ProductsGraphNode o1) {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)o1.prod);
            if (handler.getPreviousProduct(o1.prod) != null) {
                if (handler.getStatus(o1.prod) == ProductStatus.EXCHANGE) {
                    return 0;
                }
                if (handler.getStatus(o1.prod) == ProductStatus.SELL) {
                    return 1;
                }
                if (handler.getStatus(o1.prod) == ProductStatus.REFUND) {
                    return 2;
                }
            }
            return 3;
        }
    };

    public static Map<BaseProduct, String> collectProductsWithNames(BookingFile bookingFile) {
        List allProducts = BookingHelper.getProducts((BookingFile)bookingFile);
        HashMap<BaseProduct, BaseProduct> parents = new HashMap<BaseProduct, BaseProduct>();
        allProducts.forEach(prod -> {
            parents.put((BaseProduct)prod, (BaseProduct)null);
            allProducts.forEach(prod2 -> {
                if (prod2 != prod) {
                    ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)prod);
                    if (handler.getPreviousProduct(prod) == prod2) {
                        if (handler.getStatus(prod2) == ProductStatus.EXCHANGE) {
                            parents.put((BaseProduct)prod, handler.getPreviousProduct(prod2));
                        } else {
                            parents.put((BaseProduct)prod, (BaseProduct)prod2);
                        }
                    }
                    if (handler.getRelatedProducts(prod).contains(prod2)) {
                        BaseProduct parent = prod2;
                        parents.put((BaseProduct)prod, parent);
                    }
                }
            });
        });
        HashSet<BaseProduct> processed = new HashSet<BaseProduct>();
        ArrayList<ProductsGraphNode> nodes = new ArrayList<ProductsGraphNode>();
        FxProductsHelper.process(nodes, null, parents, processed);
        FxProductsHelper.sort(nodes);
        LinkedHashMap<BaseProduct, String> result = new LinkedHashMap<BaseProduct, String>();
        FxProductsHelper.fillResult(result, nodes, 0);
        return result;
    }

    private static void fillResult(Map<BaseProduct, String> result, List<ProductsGraphNode> nodes, int n) {
        nodes.forEach(node -> {
            if (n == 0) {
                result.put(node.prod, node.caption);
            } else {
                StringBuilder sb = new StringBuilder();
                for (int m = 0; m < n; ++m) {
                    sb.append("     ");
                }
                sb.append(node.caption);
                result.put(node.prod, sb.toString());
            }
            FxProductsHelper.fillResult(result, node.children, n + 1);
        });
    }

    private static void sort(List<ProductsGraphNode> result) {
        Collections.sort(result, comparator);
        for (ProductsGraphNode node : result) {
            if (node.children.isEmpty()) continue;
            FxProductsHelper.sort(node.children);
        }
    }

    private static void process(List<ProductsGraphNode> result, BaseProduct parent, Map<BaseProduct, BaseProduct> parents, Set<BaseProduct> processed) {
        parents.entrySet().forEach(entry -> {
            if (processed.contains(entry.getKey())) {
                return;
            }
            if (MiscUtil.equals((Object)parent, entry.getValue())) {
                ProductsGraphNode node = new ProductsGraphNode((BaseProduct)entry.getKey());
                result.add(node);
                processed.add((BaseProduct)entry.getKey());
                FxProductsHelper.process(node.children, (BaseProduct)entry.getKey(), parents, processed);
            }
        });
    }

    private FxProductsHelper() {
    }

    static class ProductsGraphNode {
        final BaseProduct prod;
        final List<ProductsGraphNode> children = new ArrayList<ProductsGraphNode>();
        final String caption;

        ProductsGraphNode(BaseProduct prod) {
            this.prod = prod;
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)prod);
            if (!handler.isUseShortName()) {
                this.caption = BookingHelper.generateProductName((BaseProduct)prod);
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(handler.generateShortProductName(prod));
            int n = 0;
            for (Traveller trav : handler.getTravellers(prod)) {
                if (trav.getName() != null) {
                    if (n == 0) {
                        sb.append(" ");
                    } else {
                        sb.append(", ");
                    }
                    sb.append(trav.getName());
                }
                ++n;
            }
            this.caption = sb.toString();
        }
    }
}

