/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.sabre;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import java.util.ArrayList;
import java.util.List;

public class SplitHelper {
    public static boolean isSplitAllowed(Reservation res, List<String> uidsToVoid, List<Message> messages) {
        ArrayList<Product> remainingProducts = new ArrayList<Product>();
        for (BaseProduct bp : res.getProducts()) {
            if (!(bp instanceof Product)) continue;
            Product prod = (Product)bp;
            if (uidsToVoid.contains(prod.getUid())) {
                if (SplitHelper.isValidForRefund(prod)) continue;
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u0431\u0438\u043b\u0435\u0442 {0} \u043d\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d. \u0441\u043f\u043b\u0438\u0442 \u043d\u0435\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u043d\u044b\u0445 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f", (Object[])new Object[]{prod.getUid()}));
                return false;
            }
            if (SplitHelper.isValidForRefund(prod)) continue;
            remainingProducts.add(prod);
        }
        int adults = 0;
        int infants = 0;
        for (Product prod : remainingProducts) {
            PassengerTypeValue ptv = DictHelper.getPassengerTypeValue((DictionaryReference)prod.getPassengerType());
            if (ptv == null) continue;
            switch (ptv) {
                case ADULT: {
                    ++adults;
                    break;
                }
                case INFANT: {
                    ++infants;
                    break;
                }
            }
        }
        if (infants > adults) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043f\u043e\u0441\u043b\u0435 \u0441\u043f\u043b\u0438\u0442\u0430 \u0432 \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u043c \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u043b\u0430\u0434\u0435\u043d\u0446\u0435\u0432 \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0442\u044c \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0432\u0437\u0440\u043e\u0441\u043b\u044b\u0445, \u0447\u0442\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e", (Object[])new Object[0]));
            return false;
        }
        if (adults == 0) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043f\u043e\u0441\u043b\u0435 \u0441\u043f\u043b\u0438\u0442\u0430 \u0432 \u0438\u0441\u0445\u043e\u0434\u043d\u043e\u043c \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043d\u0435 \u043e\u0441\u0442\u0430\u043d\u0435\u0442\u0441\u044f \u0432\u0437\u0440\u043e\u0441\u043b\u044b\u0445, \u0447\u0442\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static boolean isValidForRefund(Product prod) {
        return prod.getStatus() == ProductStatus.SELL && prod.getNextProduct() == null;
    }
}

