/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.sabre.reports;

import com.gridnine.xtrip.common.gds.sabre.model.SabreSalesCompareReportRow;
import com.gridnine.xtrip.common.model.excel.ExcelUtils;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetData;
import com.gridnine.xtrip.common.reports.render.PoiWorksheetHandler;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;

public class SabreSalesCompareWorksheetHandler
implements PoiWorksheetHandler<SabreSalesCompareReportRow> {
    private static final String TRUE_MARK = "X";
    private static final String FALSE_MARK = "";

    public void fill(HSSFWorkbook wb, HSSFSheet sheet, PoiWorksheetData<SabreSalesCompareReportRow> data, Map<String, Object> globalData) throws Exception {
        ReportParameters params = (ReportParameters)globalData.get("key-report-params");
        ExcelUtils.replace((HSSFSheet)sheet, (String)"${date}", (String)new SimpleDateFormat("dd.MM.yyyy").format(params.getPeriodBegin()));
        int r = 4;
        HSSFCellStyle markStyle = wb.createCellStyle();
        markStyle.cloneStyleFrom(ExcelUtils.getCellStyle((HSSFSheet)sheet, (int)4, (int)1));
        markStyle.setFillForegroundColor(new HSSFColor.YELLOW().getIndex());
        markStyle.setFillPattern((short)1);
        for (SabreSalesCompareReportRow row : data.getTickets()) {
            int c = 1;
            ExcelUtils.copyRows((HSSFSheet)sheet, (int)r, (int)r);
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)r, (int)c++, (String)row.getTicketNumber());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)r, (int)c++, (String)row.getPassenger());
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)r, (int)c++, (String)(row.isGds() ? TRUE_MARK : FALSE_MARK));
            ExcelUtils.setCellValue((HSSFSheet)sheet, (int)1, (int)1, (int)r, (int)c++, (String)(row.isMom() ? TRUE_MARK : FALSE_MARK));
            if (row.isGds() != row.isMom()) {
                for (c = 1; c < 5; ++c) {
                    ExcelUtils.setCellStyle((HSSFSheet)sheet, (int)r, (int)c, (HSSFCellStyle)markStyle);
                }
            }
            ++r;
        }
    }
}

