/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.BaseReportDocumentEntityHandler;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.ReportDocumentHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.ReportLaunchHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.TemplateReportParametersHelper;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.model.AgentTemplateReportDocumentPane;
import com.gridnine.xtrip.client.fx.reports.model.AgentTemplateReportDocumentPaneController;
import com.gridnine.xtrip.client.fx.reports.model.AgentTemplateReportDocumentPaneVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.uidata.AgentTemplateReportDocumentUIData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;

public class AgentTemplateReportDocumentHandler
extends BaseReportDocumentEntityHandler<AgentTemplateReportDocument, AgentTemplateReportDocumentUIData, AgentTemplateReportDocumentPaneVM, AgentTemplateReportDocumentPane> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<AgentTemplateReportDocument, AgentTemplateReportDocumentUIData>, AgentTemplateReportDocumentPaneVM>> toVM, List<BiConsumer<AgentTemplateReportDocumentPaneVM, DataTransferPackage<AgentTemplateReportDocument, AgentTemplateReportDocumentUIData>>> fromVM) {
        super.configureController(toVM, fromVM);
        toVM.add((dtp, vm) -> {
            AgentTemplateReportDocument model = (AgentTemplateReportDocument)dtp.getContainer().getEntity();
            ReportDocumentHelper.reportFileToVm(model.getFile(), vm.getFile());
            AgentTemplateReportDescription description = ((AgentTemplateReportDocumentUIData)dtp.getSupplement()).getDescription();
            if (description != null) {
                vm.getParameters().getMain().setDescription(description);
                if (vm.getParameters().getMain().getRequestedParameters() == null) {
                    vm.getParameters().getMain().setRequestedParameters(new LinkedHashMap());
                    TemplateReportParametersHelper.createRequestedParameters(description.getRequestedParameters(), vm.getParameters().getMain().getRequestedParameters(), Boolean.TRUE);
                }
                ReportLaunchHelper.toVMAgentTemplateReportParameters(model.getParameters(), vm.getParameters(), (EntityReference<Worklog>)model.getParameters().getWorklog());
            } else {
                vm.getParameters().getMain().setRequestedParameters(new LinkedHashMap());
                Notifications.get().showMessages(new Message[]{MessageHelper.createWarningMessage((String)Messages.Report_template_not_found, (Object[])new Object[0])});
            }
            ReportDocumentHelper.toVMMessages(model.getMessages(), vm.getMessages());
        });
        fromVM.add((vm, dtp) -> {
            AgentTemplateReportDocument model = (AgentTemplateReportDocument)dtp.getContainer().getEntity();
            ReportLaunchHelper.toModelAgentTemplateReportParameters(vm.getParameters(), model.getParameters());
            ReportFile file = model.getFile();
            if (file == null) {
                file = new ReportFile();
                model.setFile(file);
            }
            ReportDocumentHelper.reportFileFromVm(file, vm.getFile());
        });
    }

    public Class<AgentTemplateReportDocument> getEntityClass() {
        return AgentTemplateReportDocument.class;
    }

    public Class<AgentTemplateReportDocumentUIData> getSupplementClass() {
        return AgentTemplateReportDocumentUIData.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return AgentTemplateReportDocumentIndex.class;
    }

    protected AgentTemplateReportDocumentPaneVM createVM() {
        return new AgentTemplateReportDocumentPaneVM();
    }

    @Override
    protected Class<? extends ViewController<AgentTemplateReportDocumentPane, AgentTemplateReportDocumentPaneVM>> getSpaceControllerClass() {
        return AgentTemplateReportDocumentPaneController.class;
    }
}

