/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.BaseReportDocumentEntityHandler;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.ReportDocumentHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.ReportLaunchHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.TemplateReportParametersHelper;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.model.InsuranceAccidentTemplateReportDocumentPane;
import com.gridnine.xtrip.client.fx.reports.model.InsuranceAccidentTemplateReportDocumentPaneController;
import com.gridnine.xtrip.client.fx.reports.model.InsuranceAccidentTemplateReportDocumentPaneVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.reports.model.InsuranceAccidentTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.InsuranceAccidentTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import com.gridnine.xtrip.common.reports.model.TemplateReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.uidata.InsuranceAccidentTemplateReportDocumentUIData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiConsumer;

public class InsuranceAccidentTemplateReportDocumentHandler
extends BaseReportDocumentEntityHandler<InsuranceAccidentTemplateReportDocument, InsuranceAccidentTemplateReportDocumentUIData, InsuranceAccidentTemplateReportDocumentPaneVM, InsuranceAccidentTemplateReportDocumentPane> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<InsuranceAccidentTemplateReportDocument, InsuranceAccidentTemplateReportDocumentUIData>, InsuranceAccidentTemplateReportDocumentPaneVM>> toVM, List<BiConsumer<InsuranceAccidentTemplateReportDocumentPaneVM, DataTransferPackage<InsuranceAccidentTemplateReportDocument, InsuranceAccidentTemplateReportDocumentUIData>>> fromVM) {
        super.configureController(toVM, fromVM);
        toVM.add((dtp, vm) -> {
            InsuranceAccidentTemplateReportDocument model = (InsuranceAccidentTemplateReportDocument)dtp.getContainer().getEntity();
            ReportDocumentHelper.reportFileToVm(model.getFile(), vm.getFile());
            InsuranceAccidentTemplateReportDescription description = ((InsuranceAccidentTemplateReportDocumentUIData)dtp.getSupplement()).getDescription();
            if (description != null) {
                vm.getParameters().getMain().setDescription(description);
                if (vm.getParameters().getMain().getRequestedParameters() == null) {
                    vm.getParameters().getMain().setRequestedParameters(new LinkedHashMap());
                    TemplateReportParametersHelper.createRequestedParameters(description.getRequestedParameters(), vm.getParameters().getMain().getRequestedParameters(), Boolean.TRUE);
                }
                ReportLaunchHelper.toVMInsuranceAccidentTemplateReportParameters(model.getParameters(), vm.getParameters());
            } else {
                vm.getParameters().getMain().setRequestedParameters(new LinkedHashMap());
                Notifications.get().showMessages(new Message[]{MessageHelper.createWarningMessage((String)Messages.Report_template_not_found, (Object[])new Object[0])});
            }
            ReportDocumentHelper.toVMMessages(model.getMessages(), vm.getMessages());
        });
        fromVM.add((vm, dtp) -> {
            InsuranceAccidentTemplateReportDocument model = (InsuranceAccidentTemplateReportDocument)dtp.getContainer().getEntity();
            ReportLaunchHelper.toModelInsuranceAccidentTemplateReportParameters(vm.getParameters(), model.getParameters());
            ReportFile file = model.getFile();
            if (file == null) {
                file = new ReportFile();
                model.setFile(file);
            }
            ReportDocumentHelper.reportFileFromVm(file, vm.getFile());
        });
    }

    public Class<InsuranceAccidentTemplateReportDocument> getEntityClass() {
        return InsuranceAccidentTemplateReportDocument.class;
    }

    public Class<InsuranceAccidentTemplateReportDocumentUIData> getSupplementClass() {
        return InsuranceAccidentTemplateReportDocumentUIData.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return TemplateReportDocumentIndex.class;
    }

    protected InsuranceAccidentTemplateReportDocumentPaneVM createVM() {
        return new InsuranceAccidentTemplateReportDocumentPaneVM();
    }

    @Override
    protected Class<? extends ViewController<InsuranceAccidentTemplateReportDocumentPane, InsuranceAccidentTemplateReportDocumentPaneVM>> getSpaceControllerClass() {
        return InsuranceAccidentTemplateReportDocumentPaneController.class;
    }
}

