/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.BaseReportDocumentEntityHandler;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.ReportDocumentHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.ReportLaunchHelper;
import com.gridnine.xtrip.client.fx.reports.model.ProductReportDocumentPane;
import com.gridnine.xtrip.client.fx.reports.model.ProductReportDocumentPaneController;
import com.gridnine.xtrip.client.fx.reports.model.ProductReportDocumentPaneVM;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.reports.model.ProductReportDocument;
import com.gridnine.xtrip.common.reports.model.ProductReportDocumentIndex;
import com.gridnine.xtrip.common.reports.model.ReportFile;
import java.util.List;
import java.util.function.BiConsumer;

public class ProductReportDocumentHandler
extends BaseReportDocumentEntityHandler<ProductReportDocument, Void, ProductReportDocumentPaneVM, ProductReportDocumentPane> {
    @Override
    protected void configureController(List<BiConsumer<DataTransferPackage<ProductReportDocument, Void>, ProductReportDocumentPaneVM>> toVM, List<BiConsumer<ProductReportDocumentPaneVM, DataTransferPackage<ProductReportDocument, Void>>> fromVM) {
        super.configureController(toVM, fromVM);
        toVM.add((dtp, vm) -> {
            ProductReportDocument model = (ProductReportDocument)dtp.getContainer().getEntity();
            ReportDocumentHelper.reportFileToVm(model.getFile(), vm.getFile());
            ReportLaunchHelper.toVMProductReportParameters(model.getParameters(), vm.getParameters());
            ReportDocumentHelper.toVMMessages(model.getMessages(), vm.getMessages());
        });
        fromVM.add((vm, dtp) -> {
            ProductReportDocument model = (ProductReportDocument)dtp.getContainer().getEntity();
            ReportLaunchHelper.toModelProductReportParameters(vm.getParameters(), model.getParameters());
            ReportFile file = model.getFile();
            if (file == null) {
                file = new ReportFile();
                model.setFile(file);
            }
            ReportDocumentHelper.reportFileFromVm(file, vm.getFile());
        });
    }

    public Class<ProductReportDocument> getEntityClass() {
        return ProductReportDocument.class;
    }

    public Class<Void> getSupplementClass() {
        return Void.class;
    }

    public Class<? extends EntityIndex<?>> getStandardIndexClass() {
        return ProductReportDocumentIndex.class;
    }

    protected ProductReportDocumentPaneVM createVM() {
        return new ProductReportDocumentPaneVM();
    }

    @Override
    protected Class<? extends ViewController<ProductReportDocumentPane, ProductReportDocumentPaneVM>> getSpaceControllerClass() {
        return ProductReportDocumentPaneController.class;
    }
}

