/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors;

import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.model.booking.TemplateReportPagesContainerCustomParametersVM;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.renderer.StandardNodeRenderer;
import com.gridnine.xtrip.common.model.system.RequestedParameterCustomType;
import com.gridnine.xtrip.common.util.Pair;
import java.util.ArrayList;
import javafx.util.StringConverter;

public class TemplateReportControllerInterceptorHelper {
    private static StringConverter<Pair<String>> TEMPLATE_CONVERTER = new StringConverter<Pair<String>>(){

        public String toString(Pair<String> template) {
            if (template != null && template.getFirst() != null) {
                return (String)template.getFirst();
            }
            return null;
        }

        public Pair<String> fromString(String string) {
            return null;
        }
    };

    static void configurePageParametersTable(TableWidget<TemplateReportPagesContainerCustomParametersVM> parametersNode) {
        ArrayList<RendererWidgetColumn<TemplateReportPagesContainerCustomParametersVM>> columns = new ArrayList<RendererWidgetColumn<TemplateReportPagesContainerCustomParametersVM>>(parametersNode.getColumns());
        columns.add(TemplateReportControllerInterceptorHelper.createColumnWidget());
        parametersNode.setColumns(columns);
        parametersNode.addEventHandler(TableRowEvent.ROW_ADD, event -> {
            Integer ind = event.getRowIndex();
            ComboBoxWidget typeWidget = (ComboBoxWidget)parametersNode.getColumn("type").getWidget(ind.intValue());
            ArrayList<RequestedParameterCustomType> types = new ArrayList<RequestedParameterCustomType>();
            types.add(RequestedParameterCustomType.NUMBER);
            types.add(RequestedParameterCustomType.STRING);
            types.add(RequestedParameterCustomType.BOOLEAN);
            typeWidget.setItemsSupplier(() -> types);
            RendererWidget rendererWidget = (RendererWidget)parametersNode.getColumn("value").getWidget(ind.intValue());
            rendererWidget.setRenderer(TemplateReportControllerInterceptorHelper.createNodeRenderer((RequestedParameterCustomType)typeWidget.getValue()));
            typeWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
                rendererWidget.setValue(null);
                rendererWidget.setRenderer(TemplateReportControllerInterceptorHelper.createNodeRenderer(newValue));
            });
        });
    }

    private static RendererWidgetColumn<TemplateReportPagesContainerCustomParametersVM> createColumnWidget() {
        RendererWidgetColumn column = new RendererWidgetColumn(vm -> vm.getValueObject(), (vm, value) -> vm.setValueObject(value));
        column.setId("value");
        column.setCaption(Messages.Value);
        return column;
    }

    private static NodeRenderer createNodeRenderer(RequestedParameterCustomType customType) {
        if (customType == null) {
            return null;
        }
        switch (customType) {
            case BOOLEAN: {
                return StandardNodeRenderer.BOOLEAN_COMPACT;
            }
            case NUMBER: {
                return StandardNodeRenderer.PRICE;
            }
        }
        return StandardNodeRenderer.TEXTFIELD;
    }

    public static void configureTemplateWidget(ComboBoxWidget<Pair<String>> templateNode) {
        templateNode.setConverter(TEMPLATE_CONVERTER);
    }
}

