/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentInfo;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.AirTicketsTemplateReportParametersControllerInterceptor;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.AirTicketsTemplateReportParametersPaneControllerInterceptor;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.AllProductsTemplateReportParametersControllerInterceptor;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.IndexBasedTemplateReportParametersControllerInterceptor;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.InsuranceAccidentTemplateReportParametersControllerInterceptor;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.MultipleFilesTemplateReportParametersControllerInterceptor;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.TemplateReportPeriodParametersControllerInterceptor;
import com.gridnine.xtrip.client.fx.reports.handlers.TemplateReportsHelper;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.TemplateReportDocumentIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Date;

public class BaseTemplateDocumentHandler
implements ReportDocumentHandler<BaseTemplateReportDocument, TemplateReportDocumentIndex> {
    protected BaseTemplateDocumentHandler() {
        ControllersRegistry.register((ControllerInterceptor)new TemplateReportPeriodParametersControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new AirTicketsTemplateReportParametersPaneControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new AirTicketsTemplateReportParametersControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new AllProductsTemplateReportParametersControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new InsuranceAccidentTemplateReportParametersControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new IndexBasedTemplateReportParametersControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new MultipleFilesTemplateReportParametersControllerInterceptor());
    }

    @Override
    public Class<BaseTemplateReportDocument> getEntityType() {
        return BaseTemplateReportDocument.class;
    }

    @Override
    public Class<TemplateReportDocumentIndex> getIndexType() {
        return TemplateReportDocumentIndex.class;
    }

    @Override
    public SearchQuery createRecentDocumentsQuery() {
        SearchQuery result = new SearchQuery();
        result.getCriteria().getOrders().put(TemplateReportDocumentIndex.Property.created.name(), SortOrder.DESC);
        result.getPreferredProperties().add(TemplateReportDocumentIndex.Property.created.name());
        result.getPreferredProperties().add(TemplateReportDocumentIndex.Property.periodBegin.name());
        result.getPreferredProperties().add(TemplateReportDocumentIndex.Property.periodEnd.name());
        return result;
    }

    @Override
    public ReportDocumentInfo<BaseTemplateReportDocument> buildDocumentInfo(TemplateReportDocumentIndex idx) {
        ReportDocumentInfo<BaseTemplateReportDocument> result = new ReportDocumentInfo<BaseTemplateReportDocument>();
        result.setSource(idx.getSource());
        result.setCreated(DateUtils.asLocalDate((Date)idx.getCreated()));
        result.setPeriodBegin(DateUtils.asLocalDate((Date)idx.getPeriodBegin()));
        result.setPeriodEnd(DateUtils.asLocalDate((Date)idx.getPeriodEnd()));
        return result;
    }

    @Override
    public BaseReportParameters getReportParameters(BaseTemplateReportDocument document) {
        return TemplateReportsHelper.getReportParameters(document);
    }

    @Override
    public String getReportLaunchHandlerUid(BaseTemplateReportDocument document) {
        return TemplateReportsHelper.getReportLaunchHandlerUid(document);
    }
}

