/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentInfo;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.ReportParametersControllerInterceptor;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportDocument;
import com.gridnine.xtrip.common.reports.model.SalesReportDocumentIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Date;

class SalesReportDocumentHandler
implements ReportDocumentHandler<ReportDocument, SalesReportDocumentIndex> {
    SalesReportDocumentHandler() {
        ControllersRegistry.register((ControllerInterceptor)new ReportParametersControllerInterceptor());
    }

    @Override
    public Class<ReportDocument> getEntityType() {
        return ReportDocument.class;
    }

    @Override
    public Class<SalesReportDocumentIndex> getIndexType() {
        return SalesReportDocumentIndex.class;
    }

    @Override
    public SearchQuery createRecentDocumentsQuery() {
        SearchQuery result = new SearchQuery();
        result.getCriteria().getOrders().put(SalesReportDocumentIndex.Property.created.name(), SortOrder.DESC);
        result.getPreferredProperties().add(SalesReportDocumentIndex.Property.created.name());
        result.getPreferredProperties().add(SalesReportDocumentIndex.Property.periodBegin.name());
        result.getPreferredProperties().add(SalesReportDocumentIndex.Property.periodEnd.name());
        return result;
    }

    @Override
    public ReportDocumentInfo<ReportDocument> buildDocumentInfo(SalesReportDocumentIndex idx) {
        ReportDocumentInfo<ReportDocument> result = new ReportDocumentInfo<ReportDocument>();
        result.setSource(idx.getSource());
        result.setCreated(DateUtils.asLocalDate((Date)idx.getCreated()));
        result.setPeriodBegin(DateUtils.asLocalDate((Date)idx.getPeriodBegin()));
        result.setPeriodEnd(DateUtils.asLocalDate((Date)idx.getPeriodEnd()));
        return result;
    }

    @Override
    public BaseReportParameters getReportParameters(ReportDocument document) {
        return document.getParameters();
    }

    @Override
    public String getReportLaunchHandlerUid(ReportDocument document) {
        return document.getParameters().getReportId();
    }
}

