/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentInfo;
import com.gridnine.xtrip.client.fx.reports.entity.handlers.interceptors.TripartiteReportParametersControllerInterceptor;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.TripartiteReportDocument;
import com.gridnine.xtrip.common.reports.model.TripartiteReportDocumentIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import java.util.Date;

class TripartiteReportDocumentHandler
implements ReportDocumentHandler<TripartiteReportDocument, TripartiteReportDocumentIndex> {
    TripartiteReportDocumentHandler() {
        ControllersRegistry.register((ControllerInterceptor)new TripartiteReportParametersControllerInterceptor());
    }

    @Override
    public Class<TripartiteReportDocument> getEntityType() {
        return TripartiteReportDocument.class;
    }

    @Override
    public Class<TripartiteReportDocumentIndex> getIndexType() {
        return TripartiteReportDocumentIndex.class;
    }

    @Override
    public SearchQuery createRecentDocumentsQuery() {
        SearchQuery result = new SearchQuery();
        result.getCriteria().getOrders().put(TripartiteReportDocumentIndex.Property.created.name(), SortOrder.DESC);
        result.getPreferredProperties().add(TripartiteReportDocumentIndex.Property.created.name());
        result.getPreferredProperties().add(TripartiteReportDocumentIndex.Property.periodBegin.name());
        result.getPreferredProperties().add(TripartiteReportDocumentIndex.Property.periodEnd.name());
        return result;
    }

    @Override
    public ReportDocumentInfo<TripartiteReportDocument> buildDocumentInfo(TripartiteReportDocumentIndex idx) {
        ReportDocumentInfo<TripartiteReportDocument> result = new ReportDocumentInfo<TripartiteReportDocument>();
        result.setSource(idx.getSource());
        result.setCreated(DateUtils.asLocalDate((Date)idx.getCreated()));
        result.setPeriodBegin(DateUtils.asLocalDate((Date)idx.getPeriodBegin()));
        result.setPeriodEnd(DateUtils.asLocalDate((Date)idx.getPeriodEnd()));
        return result;
    }

    @Override
    public BaseReportParameters getReportParameters(TripartiteReportDocument document) {
        return document.getParameters();
    }

    @Override
    public String getReportLaunchHandlerUid(TripartiteReportDocument document) {
        return document.getParameters().getReportId();
    }
}

