/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers.launch;

import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.reports.api.ReportCategories;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchHandler;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.AgentReportParametersPaneControllerInterceptor;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.ReportLaunchHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.ReportParametersLauncherValidator;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.model.AgentReportParametersPaneController;
import com.gridnine.xtrip.client.fx.reports.model.AgentReportParametersPaneVM;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.reports.model.AgentReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.restriction.resource.ReportsRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.ArrayList;
import javafx.scene.Node;

public class AgentReportLaunchHandler
implements ReportLaunchHandler {
    private static final AclQuery ACL_QUERY = new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ReportsRestrictionEntityResources.ENTITY_AGENT_REPORT_DOCUMENT.getId());

    @Override
    public String getUid() {
        return "agent-report";
    }

    @Override
    public FactoryToolCategory getCategory() {
        return ReportCategories.INTERNAL;
    }

    @Override
    public String getName() {
        return Messages.Daily_agent_report_new_form;
    }

    @Override
    public void launch(Node parent, Runnable callback) {
        ControllersRegistry.register((ControllerInterceptor)new AgentReportParametersPaneControllerInterceptor());
        ReportLaunchHelper.launch(this.getUid(), this.getUid(), this.getName(), parent, callback, new AgentReportParameters(), new AgentReportParametersPaneVM(), new AgentReportParametersPaneController(false), ReportLaunchHelper::toVMAgentReportParameters, ReportLaunchHelper::toModelAgentReportParameters, params -> {
            ArrayList<String> listMessageError = new ArrayList<String>();
            ReportParametersLauncherValidator.init(listMessageError, (BaseReportParameters)params).validateReportPeriod().validateAgency();
            return listMessageError;
        });
    }

    @Override
    public void relaunch(Node parent, EntityContainer<? extends BaseReportDocument> document, Runnable callback) {
        ReportLaunchHelper.relaunch(this.getUid(), this.getName(), callback, ((AgentReportDocument)document.getEntity()).getParameters(), (EntityReference<? extends BaseReportDocument>)document.toReference());
    }

    @Override
    public AclQuery getACLQuery() {
        return ACL_QUERY;
    }
}

