/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers.launch;

import com.gridnine.xtrip.client.fx.reports.handlers.launch.BaseTemplateReportLaunchHandler;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.ReportLaunchHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.TemplateReportParametersHelper;
import com.gridnine.xtrip.client.fx.reports.model.AgentTemplateReportParametersPaneController;
import com.gridnine.xtrip.client.fx.reports.model.AgentTemplateReportParametersPaneVM;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.WorklogService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDocument;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.TemplateReportDescriptionIndex;
import com.gridnine.xtrip.common.reports.restriction.resource.ReportsRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import javafx.scene.Node;

public class AgentTemplateReportLaunchHandler
extends BaseTemplateReportLaunchHandler<AgentTemplateReportDescription> {
    private static final AclQuery ACL_QUERY = new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ReportsRestrictionEntityResources.ENTITY_AGENT_TEMPLATE_REPORT_DOCUMENT.getId());
    private EntityReference<Worklog> worklog;

    public AgentTemplateReportLaunchHandler(TemplateReportDescriptionIndex idx) {
        super(idx);
    }

    @Override
    public AclQuery getACLQuery() {
        return ACL_QUERY;
    }

    @Override
    protected void launch(AgentTemplateReportDescription descr, Node parent, Runnable callback) {
        ReportLaunchHelper.launch("agent-template-report", this.getUid(), this.getName(), parent, callback, this.prepareParams(), this.prepareParamsVM(descr), new AgentTemplateReportParametersPaneController(false), (model, vm) -> ReportLaunchHelper.toVMAgentTemplateReportParameters(model, vm, this.worklog), ReportLaunchHelper::toModelAgentTemplateReportParameters, params -> {
            ArrayList result = new ArrayList();
            this.validatePeriod((BaseTemplateReportParameters)params, descr, result::add);
            return result;
        });
    }

    @Override
    protected void relaunch(AgentTemplateReportDescription descr, Node parent, EntityContainer<? extends BaseReportDocument> document, Runnable callback) {
        ReportLaunchHelper.relaunch("agent-template-report", this.getName(), callback, ((AgentTemplateReportDocument)document.getEntity()).getParameters(), (EntityReference<? extends BaseReportDocument>)document.toReference());
    }

    @Override
    protected void prepare() throws Exception {
        this.worklog = ((WorklogService)RpcServiceManager.get().getService(WorklogService.class)).getCurrentWorklog(ServiceInvocationContext.get());
    }

    private AgentTemplateReportParameters prepareParams() {
        AgentTemplateReportParameters result = new AgentTemplateReportParameters();
        result.setDescription(this.getIndex().getSource());
        return result;
    }

    private AgentTemplateReportParametersPaneVM prepareParamsVM(AgentTemplateReportDescription descr) {
        AgentTemplateReportParametersPaneVM result = new AgentTemplateReportParametersPaneVM();
        result.getMain().setRequestedParameters(new LinkedHashMap());
        result.getMain().setDescription(descr);
        result.getPeriod().setPeriodUse(descr.getPeriodUse());
        TemplateReportParametersHelper.createRequestedParameters(descr.getRequestedParameters(), result.getMain().getRequestedParameters(), Boolean.FALSE);
        return result;
    }

    @Override
    protected void validatePeriod(BaseTemplateReportParameters params, AgentTemplateReportDescription description, Consumer<String> errors) {
        AgentTemplateReportParameters agentParams = (AgentTemplateReportParameters)params;
        if (agentParams.getWorklog() == null) {
            super.validatePeriod(params, description, errors);
        }
    }
}

