/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers.launch;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchEvent;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportsHelper;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.TemplateReportParametersHelper;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.model.AgentReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.AgentReportParametersSupplierVM;
import com.gridnine.xtrip.client.fx.reports.model.AgentTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.AirTicketsTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.AllProductsTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.ClientDebtParametersVendorVM;
import com.gridnine.xtrip.client.fx.reports.model.ClientDebtReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.DivergenceReportParameters1PaneVM;
import com.gridnine.xtrip.client.fx.reports.model.DivergenceReportParameters2PaneVM;
import com.gridnine.xtrip.client.fx.reports.model.IndexBasedTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.InsuranceAccidentTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainAgentReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainAgentTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainAirTicketsTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainAllProductsTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainClientDebtParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainDivergenceParameters1PaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainDivergenceParameters2PaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainIndexBasedTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainInsuranceAccidentTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainProductParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainStockBlankTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MainTripartiteParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.MultipleFilesTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.ProductReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.ReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.StockBlankTemplateReportParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.TemplateReportPeriodParametersPaneVM;
import com.gridnine.xtrip.client.fx.reports.model.TripartiteReportParametersPaneVM;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.reports.rpc.ReportsService;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.GeneralFxService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.RequestedParameterControlType;
import com.gridnine.xtrip.common.model.system.RequestedParameterCustomType;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.reports.model.AgentReportParameters;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AgentTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AirTicketsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.AllProductsTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.AllProductsTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import com.gridnine.xtrip.common.reports.model.BaseReportParameters;
import com.gridnine.xtrip.common.reports.model.BaseSingleFileTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.ClientDebtReportParameters;
import com.gridnine.xtrip.common.reports.model.DivergenceReportParameters;
import com.gridnine.xtrip.common.reports.model.GeneralAgentTemplateReportFilteringParameters;
import com.gridnine.xtrip.common.reports.model.GeneralProductsTemplateReportFilteringParameters;
import com.gridnine.xtrip.common.reports.model.IndexBasedTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.InsuranceAccidentTemplateReportDescription;
import com.gridnine.xtrip.common.reports.model.InsuranceAccidentTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.MultipleFilesTemplateReportParameters;
import com.gridnine.xtrip.common.reports.model.ProductReportParameters;
import com.gridnine.xtrip.common.reports.model.ReportParameters;
import com.gridnine.xtrip.common.reports.model.StockBlankReportDescription;
import com.gridnine.xtrip.common.reports.model.StockBlankReportFilteringParameters;
import com.gridnine.xtrip.common.reports.model.StockBlankReportParameters;
import com.gridnine.xtrip.common.reports.model.TemplateReportPeriodUse;
import com.gridnine.xtrip.common.reports.model.TemplateReportRequestedParameter;
import com.gridnine.xtrip.common.reports.model.TemplateReportRequestedParameterBusinessType;
import com.gridnine.xtrip.common.reports.model.TripartiteReportParameters;
import com.gridnine.xtrip.common.reports.restriction.resource.ReportsRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.restriction.util.RestrictionsUtil;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.slf4j.LoggerFactory;

public class ReportLaunchHelper {
    public static final AclQuery REPORT_DOCUMENT_ACL_QUERY = new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ReportsRestrictionEntityResources.ENTITY_SUPPLIER_REPORT_DOCUMENT.getId());
    public static final AclQuery DIVERGENCE_DOCUMENT_ACL_QUERY = new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ReportsRestrictionEntityResources.ENTITY_DIVERGENCE_REPORT_DOCUMENT.getId());

    public static <D extends BaseReportDocument> void relaunch(Node node, EntityContainer<D> document) {
        ReportDocumentHandler<?, ?> documentHandler = ReportsHelper.getDocumentHandler(document.getEntityType());
        if (documentHandler == null) {
            ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.Report_doc_worker_not_found, (Object[])new Object[0]));
            return;
        }
        String launcherUid = documentHandler.getReportLaunchHandlerUid((BaseReportDocument)document.getEntity());
        Notifications.get().submitTask(() -> {
            ReportLaunchHandler launchHandler = null;
            ArrayList handlers = new ArrayList();
            ReportsHelper.enumerateAvailableHandlers(handlers::add, false);
            for (ReportLaunchHandler handler : handlers) {
                if (!handler.getUid().equals(launcherUid)) continue;
                launchHandler = handler;
                break;
            }
            if (launchHandler == null) {
                Notifications.get().showFlashNotification(Messages.Report_running_worker_not_found, null);
                return;
            }
            ReportLaunchHandler launchHandlerFinal = launchHandler;
            FxUtil.submitToFxThread(() -> launchHandlerFinal.relaunch(node, (EntityContainer<? extends BaseReportDocument>)document, () -> EventBus.get().publishAsync((Event)new ReportLaunchEvent(launchHandlerFinal))));
        }, Messages.Prepare_Running);
    }

    public static <P extends BaseReportParameters, V> void launch(String reportId, String reportParamsId, String name, Node parent, Runnable callback, P params, V vmParams, ViewController<?, V> controller, BiConsumer<P, V> methodToVM, BiConsumer<V, P> methodToModel, Function<P, List<String>> validateData) {
        Notifications.get().submitTask(() -> {
            ReportLaunchHelper.loadParams(reportParamsId, params);
            methodToVM.accept(params, vmParams);
            controller.readData(vmParams);
            Dialog dialog = new Dialog();
            dialog.setTitle(TextUtil.isBlank((String)name) ? Messages.Without_name : name).setBody(controller.getView()).setBody(controller.getView()).setAutoClose(false).setExpandToParent(true).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Form, () -> {
                Pane pane = (Pane)controller.getView();
                pane.getChildren().removeAll((Collection)pane.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
                controller.writeData(vmParams);
                methodToModel.accept(vmParams, params);
                List listMessage = (List)validateData.apply(params);
                if (listMessage != null && !listMessage.isEmpty()) {
                    listMessage.forEach(message -> pane.getChildren().add(0, (Object)MessagePane.error((String)message)));
                    return;
                }
                dialog.close();
                ReportLaunchHelper.saveParams(reportParamsId, params);
                ReportLaunchHelper.scheduleTask(params, reportId, name, callback, null);
            });
            FxUtil.submitToFxThread(() -> dialog.show(parent));
        }, Messages.Prepare_Running);
    }

    public static <P extends BaseReportParameters, V> void relaunch(String reportId, String name, Runnable callback, P params, EntityReference<? extends BaseReportDocument> reportDocument) {
        ReportLaunchHelper.scheduleTask(params, reportId, name, callback, reportDocument);
    }

    private static <P extends BaseReportParameters> P loadParams(String reportId, P params) {
        File file = new File(Environment.getDataFolder(), "settings/report-params-" + reportId + ".xml");
        if (file.isFile()) {
            try {
                params.fromXML(DocumentBuilderHelper.parse((File)file).getDocumentElement());
                return (P)((BaseReportParameters)((GeneralFxService)RpcServiceManager.get().getService(GeneralFxService.class)).actualize(ServiceInvocationContext.get(), params));
            }
            catch (Exception e) {
                LoggerFactory.getLogger(ReportLaunchHelper.class).warn("failed loading report parameters from " + file, (Throwable)e);
            }
        }
        return params;
    }

    private static <P extends BaseReportParameters> void saveParams(String reportId, P params) {
        File file = new File(Environment.getDataFolder(), "settings/report-params-" + reportId + ".xml");
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            XUtil.serialize(params, (OutputStream)out);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ReportLaunchHelper.class).warn("failed saving report parameters to " + file, (Throwable)e);
        }
    }

    private static void scheduleTask(BaseReportParameters params, String reportId, String name, Runnable callback, EntityReference<? extends BaseReportDocument> reportDocument) {
        params.setReportId(reportId);
        Notifications.get().submitTask(() -> {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            ReportsService reportsService = (ReportsService)RpcServiceManager.get().getService(ReportsService.class);
            if (reportDocument == null) {
                reportsService.createTask(sic, params, name);
            } else {
                reportsService.recreateTask(sic, params, name, reportDocument);
            }
            callback.run();
        }, Messages.Sending_forming_report_task);
    }

    public static void toVMReportParameters(ReportParameters model, ReportParametersPaneVM vm) {
        MainParametersPaneVM mainVM = vm.getMain();
        mainVM.setPeriodBegin(DateUtils.asLocalDate((Date)model.getPeriodBegin()));
        mainVM.setPeriodEnd(DateUtils.asLocalDate((Date)model.getPeriodEnd()));
        mainVM.setSupplier(model.getSupplier());
        mainVM.setAgency(model.getAgency());
        mainVM.setSubagency(model.getSubagency());
        mainVM.setSalesPoint(model.getSalesPoint());
        mainVM.setBlankOwner(model.getBlankOwner());
        mainVM.setDatePropertyName(model.getDatePropertyName());
        mainVM.setEtVoidStatus(SearchQueryHelper.isExcludeVoidETickets((Set)model.getAdditionalCriterions()));
        vm.getAdditional().setRestrictionId(ProductIndex.class.getName());
        vm.getAdditional().getRestrictions().addAll(RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)model.getAdditionalCriterions(), ProductIndex.class, Collections.emptyList()));
    }

    public static void toModelReportParameters(ReportParametersPaneVM vm, ReportParameters model) {
        MainParametersPaneVM mainVM = vm.getMain();
        model.setPeriodBegin(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodBegin())));
        model.setPeriodEnd(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodEnd())));
        model.setSupplier(mainVM.getSupplier());
        model.setAgency(mainVM.getAgency());
        model.setSubagency(mainVM.getSubagency());
        model.setSalesPoint(mainVM.getSalesPoint());
        model.setBlankOwner(mainVM.getBlankOwner());
        model.setDatePropertyName(mainVM.getDatePropertyName());
        LinkedHashSet<SearchCriterion> additionalCriterions = new LinkedHashSet<SearchCriterion>();
        vm.getAdditional().getRestrictionId();
        additionalCriterions.addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)vm.getAdditional().getRestrictions(), ProductIndex.class, Collections.emptyList()));
        if (mainVM.isEtVoidStatus()) {
            if (!SearchQueryHelper.isExcludeVoidETickets(additionalCriterions)) {
                additionalCriterions.add(SearchQueryHelper.getExcludeVoidETicketsCriterion());
            }
        } else {
            additionalCriterions.remove(SearchQueryHelper.getExcludeVoidETicketsCriterion(additionalCriterions));
        }
        model.getAdditionalCriterions().clear();
        model.getAdditionalCriterions().addAll(additionalCriterions);
    }

    public static void toVMClientDebtReportParameters(ClientDebtReportParameters model, ClientDebtReportParametersPaneVM vm) {
        MainClientDebtParametersPaneVM mainVM = vm.getMain();
        mainVM.setPeriodBegin(DateUtils.asLocalDate((Date)model.getPeriodBegin()));
        mainVM.setPeriodEnd(DateUtils.asLocalDate((Date)model.getPeriodEnd()));
        mainVM.setAgent(model.getAgent());
        mainVM.setSubagency(model.getSubagency());
        mainVM.setSalesPoint(model.getSalesPoint());
        mainVM.setAgency(model.getAgency());
        vm.getVendors().clear();
        for (EntityReference ref : model.getVendors()) {
            ClientDebtParametersVendorVM vendorVM = new ClientDebtParametersVendorVM();
            vendorVM.setVendor(ref);
            vm.getVendors().add(vendorVM);
        }
        vm.getAdditional().setRestrictionId(ProductIndex.class.getName());
        vm.getAdditional().getRestrictions().addAll(RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)model.getAdditionalCriterions(), ProductIndex.class, Collections.emptyList()));
    }

    public static void toModelClientDebtReportParameters(ClientDebtReportParametersPaneVM vm, ClientDebtReportParameters model) {
        MainClientDebtParametersPaneVM mainVM = vm.getMain();
        model.setPeriodBegin(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodBegin())));
        model.setPeriodEnd(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodEnd())));
        model.setAgent(mainVM.getAgent());
        model.setSubagency(mainVM.getSubagency());
        model.setSalesPoint(mainVM.getSalesPoint());
        model.setAgency(mainVM.getAgency());
        model.getVendors().clear();
        for (ClientDebtParametersVendorVM vendorVM : vm.getVendors()) {
            if (vendorVM.getVendor() == null) continue;
            model.getVendors().add(vendorVM.getVendor());
        }
        LinkedHashSet additionalCriterions = new LinkedHashSet();
        vm.getAdditional().getRestrictionId();
        additionalCriterions.addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)vm.getAdditional().getRestrictions(), ProductIndex.class, Collections.emptyList()));
        model.getAdditionalCriterions().clear();
        model.getAdditionalCriterions().addAll(additionalCriterions);
    }

    public static void toVMTripartiteReportParameters(TripartiteReportParameters model, TripartiteReportParametersPaneVM vm) {
        MainTripartiteParametersPaneVM mainVM = vm.getMain();
        TripartiteReportParametersDateHelper dateHelper = new TripartiteReportParametersDateHelper(model.getPeriodBegin());
        mainVM.setYear(dateHelper.year);
        mainVM.setMonth(dateHelper.month);
        mainVM.setAgency(model.getAgency());
        mainVM.setContract(model.getContract());
        vm.getAdditional().setRestrictionId(ProductIndex.class.getName());
        vm.getAdditional().getRestrictions().addAll(RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)model.getAdditionalCriterions(), ProductIndex.class, Collections.emptyList()));
    }

    public static void toModelTripartiteReportParameters(TripartiteReportParametersPaneVM vm, TripartiteReportParameters model) {
        MainTripartiteParametersPaneVM mainVM = vm.getMain();
        TripartiteReportParametersDateHelper dateHelper = new TripartiteReportParametersDateHelper(mainVM.getYear(), mainVM.getMonth());
        model.setPeriodBegin(MiscUtil.clearTime((Date)dateHelper.getBeginDate()));
        model.setPeriodEnd(MiscUtil.setDayEndTime((Date)dateHelper.getEndDate()));
        model.setAgency(mainVM.getAgency());
        model.setContract(mainVM.getContract());
        model.setClient(mainVM.getClient());
        model.setTourCode(mainVM.getTourCode());
        LinkedHashSet additionalCriterions = new LinkedHashSet();
        vm.getAdditional().getRestrictionId();
        additionalCriterions.addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)vm.getAdditional().getRestrictions(), ProductIndex.class, Collections.emptyList()));
        model.getAdditionalCriterions().clear();
        model.getAdditionalCriterions().addAll(additionalCriterions);
    }

    public static void toVMDivergenceReportParameters1(DivergenceReportParameters model, DivergenceReportParameters1PaneVM vm) {
        MainDivergenceParameters1PaneVM mainVM = vm.getMain();
        mainVM.setPeriodBegin(DateUtils.asLocalDate((Date)model.getPeriodBegin()));
        mainVM.setPeriodEnd(DateUtils.asLocalDate((Date)model.getPeriodEnd()));
        mainVM.setAgency(model.getAgency());
        mainVM.setBlankOwner(model.getBlankOwner());
        mainVM.setSupplier(model.getSupplier());
        mainVM.getValidator().setCode(model.getValidator());
        mainVM.setExcludeNullableTickets(model.isExcludeNullableTickets());
        mainVM.setExcludeDate(model.isExcludeDate());
        mainVM.setExcludeIT(model.isExcludeIT());
        mainVM.setExcludeName(model.isExcludeName());
    }

    public static void toModelDivergenceReportParameters1(DivergenceReportParameters1PaneVM vm, DivergenceReportParameters model) {
        MainDivergenceParameters1PaneVM mainVM = vm.getMain();
        model.setPeriodBegin(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodBegin())));
        model.setPeriodEnd(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodEnd())));
        model.setAgency(mainVM.getAgency());
        model.setBlankOwner(mainVM.getBlankOwner());
        model.setSupplier(mainVM.getSupplier());
        if (mainVM.getValidator() != null) {
            model.setValidator(mainVM.getValidator().getCode());
        }
        model.setExcludeNullableTickets(mainVM.isExcludeNullableTickets());
        model.setExcludeDate(mainVM.isExcludeDate());
        model.setExcludeIT(mainVM.isExcludeIT());
        model.setExcludeName(mainVM.isExcludeName());
    }

    public static void toVMDivergenceReportParameters2(DivergenceReportParameters model, DivergenceReportParameters2PaneVM vm) {
        MainDivergenceParameters2PaneVM mainVM = vm.getMain();
        mainVM.setPeriodBegin(DateUtils.asLocalDate((Date)model.getPeriodBegin()));
        mainVM.setPeriodEnd(DateUtils.asLocalDate((Date)model.getPeriodEnd()));
        mainVM.setAgency(model.getAgency());
        mainVM.setSupplier(model.getSupplier());
        mainVM.setExcludePaperTickets(model.isExcludePaperTickets());
        mainVM.setDatePropertyName(model.getDatePropertyName());
    }

    public static void toModelDivergenceReportParameters2(DivergenceReportParameters2PaneVM vm, DivergenceReportParameters model) {
        MainDivergenceParameters2PaneVM mainVM = vm.getMain();
        model.setPeriodBegin(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodBegin())));
        model.setPeriodEnd(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodEnd())));
        model.setAgency(mainVM.getAgency());
        model.setSupplier(mainVM.getSupplier());
        model.setExcludePaperTickets(mainVM.isExcludePaperTickets());
        model.setDatePropertyName(mainVM.getDatePropertyName());
    }

    public static void toVMAgentReportParameters(AgentReportParameters model, AgentReportParametersPaneVM vm) {
        MainAgentReportParametersPaneVM mainVM = vm.getMain();
        mainVM.setPeriodBegin(DateUtils.asLocalDate((Date)model.getPeriodBegin()));
        mainVM.setPeriodEnd(DateUtils.asLocalDate((Date)model.getPeriodEnd()));
        mainVM.setAgency(model.getAgency());
        mainVM.setAgent(model.getAgent());
        vm.getVendors().clear();
        for (EntityReference ref : model.getVendors()) {
            AgentReportParametersSupplierVM vendorVM = new AgentReportParametersSupplierVM();
            vendorVM.setSupplier(ref);
            vm.getVendors().add(vendorVM);
        }
        vm.getAdditional().setRestrictionId(ProductIndex.class.getName());
        vm.getAdditional().getRestrictions().addAll(RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)model.getAdditionalCriterions(), ProductIndex.class, Collections.emptyList()));
    }

    public static void toModelAgentReportParameters(AgentReportParametersPaneVM vm, AgentReportParameters model) {
        MainAgentReportParametersPaneVM mainVM = vm.getMain();
        model.setPeriodBegin(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodBegin())));
        model.setPeriodEnd(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodEnd())));
        model.setAgency(mainVM.getAgency());
        model.setAgent(mainVM.getAgent());
        model.getVendors().clear();
        for (AgentReportParametersSupplierVM vendorVM : vm.getVendors()) {
            if (vendorVM.getSupplier() == null) continue;
            model.getVendors().add(vendorVM.getSupplier());
        }
        LinkedHashSet additionalCriterions = new LinkedHashSet();
        vm.getAdditional().getRestrictionId();
        additionalCriterions.addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)vm.getAdditional().getRestrictions(), ProductIndex.class, Collections.emptyList()));
        model.getAdditionalCriterions().clear();
        model.getAdditionalCriterions().addAll(additionalCriterions);
    }

    public static void toVMProductReportParameters(ProductReportParameters model, ProductReportParametersPaneVM vm) {
        MainProductParametersPaneVM mainVM = vm.getMain();
        mainVM.setPeriodBegin(DateUtils.asLocalDate((Date)model.getPeriodBegin()));
        mainVM.setPeriodEnd(DateUtils.asLocalDate((Date)model.getPeriodEnd()));
        mainVM.setAgency(model.getAgency());
        mainVM.setSubagency(model.getSubagency());
        mainVM.setSalesPoint(model.getSalesPoint());
        mainVM.setSupplier(model.getSupplier());
        mainVM.setVendor(model.getVendor());
        vm.getAdditional().setRestrictionId(ProductIndex.class.getName());
        vm.getAdditional().getRestrictions().addAll(RestrictionsUtil.toRestrictionGroupsFromQuery((Collection)model.getAdditionalCriterions(), ProductIndex.class, Collections.emptyList()));
    }

    public static void toModelProductReportParameters(ProductReportParametersPaneVM vm, ProductReportParameters model) {
        MainProductParametersPaneVM mainVM = vm.getMain();
        model.setPeriodBegin(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodBegin())));
        model.setPeriodEnd(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)mainVM.getPeriodEnd())));
        model.setAgency(mainVM.getAgency());
        model.setSubagency(mainVM.getSubagency());
        model.setSalesPoint(mainVM.getSalesPoint());
        model.setSupplier(mainVM.getSupplier());
        model.setVendor(mainVM.getVendor());
        LinkedHashSet additionalCriterions = new LinkedHashSet();
        vm.getAdditional().getRestrictionId();
        additionalCriterions.addAll(RestrictionsUtil.toQueryFromRestrictionGroups((Collection)vm.getAdditional().getRestrictions(), ProductIndex.class, Collections.emptyList()));
        model.getAdditionalCriterions().clear();
        model.getAdditionalCriterions().addAll(additionalCriterions);
    }

    public static void toVMPeriodParameters(TemplateReportPeriodParametersPaneVM vm, TemplateReportPeriodUse periodUse, Date periodBegin, Date periodEnd) {
        vm.setPeriodUse(periodUse);
        if (periodUse == TemplateReportPeriodUse.DATE || periodUse == null) {
            vm.setPeriodBegin(DateUtils.asLocalDate((Date)periodBegin));
            vm.setPeriodEnd(DateUtils.asLocalDate((Date)periodEnd));
        } else if (periodUse == TemplateReportPeriodUse.DATE_TIME) {
            vm.setPeriodBeginWithTime(DateUtils.asLocalDateTime((Date)periodBegin));
            vm.setPeriodEndWithTime(DateUtils.asLocalDateTime((Date)periodEnd));
        }
    }

    public static void toModelPeriodParameters(TemplateReportPeriodParametersPaneVM vm, TemplateReportPeriodUse periodUse, BaseReportParameters params) {
        if (periodUse == TemplateReportPeriodUse.DATE || periodUse == null) {
            params.setPeriodBegin(MiscUtil.clearTime((Date)DateUtils.asDate((LocalDate)vm.getPeriodBegin())));
            params.setPeriodEnd(MiscUtil.setDayEndTime((Date)DateUtils.asDate((LocalDate)vm.getPeriodEnd())));
        } else if (periodUse == TemplateReportPeriodUse.DATE_TIME) {
            params.setPeriodBegin(DateUtils.asDate((LocalDateTime)vm.getPeriodBeginWithTime()));
            params.setPeriodEnd(DateUtils.asDate((LocalDateTime)vm.getPeriodEndWithTime()));
        }
    }

    public static void toVMAgentTemplateReportParameters(AgentTemplateReportParameters model, AgentTemplateReportParametersPaneVM vm, EntityReference<Worklog> worklog) {
        ReportLaunchHelper.toVMPeriodParameters(vm.getPeriod(), vm.getMain().getDescription().getPeriodUse(), model.getPeriodBegin(), model.getPeriodEnd());
        MainAgentTemplateReportParametersPaneVM mainVM = vm.getMain();
        List params = mainVM.getDescription().getGlobalFilteringParameters();
        if (params.contains(GeneralAgentTemplateReportFilteringParameters.WORKLOG)) {
            mainVM.setWorklog(worklog != null ? worklog : model.getWorklog());
        }
        if (params.contains(GeneralAgentTemplateReportFilteringParameters.AGENT)) {
            mainVM.setAgent(model.getAgent());
        }
        if (params.contains(GeneralAgentTemplateReportFilteringParameters.CASH)) {
            mainVM.setCash(model.getCash());
        }
        if (params.contains(GeneralAgentTemplateReportFilteringParameters.CASH_REGISTER)) {
            mainVM.setCashRegister(model.getCashRegister());
        }
        if (params.contains(GeneralAgentTemplateReportFilteringParameters.CASH_REGISTER_WORKPLACE)) {
            mainVM.setCashRegisterWorkplace(model.getCashRegisterWorkplace());
        }
        if (params.contains(GeneralAgentTemplateReportFilteringParameters.SALES_POINT)) {
            mainVM.setSalesPoint(model.getSalesPoint());
        }
        if (params.contains(GeneralAgentTemplateReportFilteringParameters.SUBAGENCY)) {
            mainVM.setSubagency(model.getSubagency());
        }
        if (params.contains(GeneralAgentTemplateReportFilteringParameters.USE_NEW_CASH_REMAINS)) {
            mainVM.setUseNewCashRemains(model.isUseNewCashRemains());
        }
        TemplateReportParametersHelper.toVMTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), mainVM.getRequestedParameters());
    }

    public static void toModelAgentTemplateReportParameters(AgentTemplateReportParametersPaneVM vm, AgentTemplateReportParameters model) {
        ReportLaunchHelper.toModelPeriodParameters(vm.getPeriod(), vm.getMain().getDescription().getPeriodUse(), (BaseReportParameters)model);
        MainAgentTemplateReportParametersPaneVM mainVM = vm.getMain();
        model.setAgent(mainVM.getAgent());
        model.setCash(mainVM.getCash());
        model.setCashRegister(mainVM.getCashRegister());
        model.setCashRegisterWorkplace(mainVM.getCashRegisterWorkplace());
        model.setSalesPoint(mainVM.getSalesPoint());
        model.setWorklog(mainVM.getWorklog());
        model.setSubagency(mainVM.getSubagency());
        model.setUseNewCashRemains(mainVM.isUseNewCashRemains());
        TemplateReportParametersHelper.toModelTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), mainVM.getRequestedParameters());
    }

    public static void toVMAirTicketsTemplateReportParameters(AirTicketsTemplateReportParameters model, AirTicketsTemplateReportParametersPaneVM vm) {
        ReportLaunchHelper.toVMPeriodParameters(vm.getPeriod(), vm.getMain().getDescription().getPeriodUse(), model.getPeriodBegin(), model.getPeriodEnd());
        MainAirTicketsTemplateReportParametersPaneVM mainVM = vm.getMain();
        List params = mainVM.getDescription().getGlobalFilteringParameters();
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.AGENT)) {
            mainVM.setAgent(model.getAgent());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.AGENCY)) {
            mainVM.setAgency(model.getAgency());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.BLANK_OWNER)) {
            mainVM.setBlankOwner(model.getBlankOwner());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.CLIENT)) {
            mainVM.setClient(model.getClient());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.SUPPLIER)) {
            mainVM.setSupplier(model.getSupplier());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.SALES_POINT)) {
            mainVM.setSalesPoint(model.getSalesPoint());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.SUBAGENCY)) {
            mainVM.setSubagency(model.getSubagency());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.HIDE_VOID_ETICKETS)) {
            mainVM.setHideVoidedTickets(SearchQueryHelper.isExcludeVoidETickets((Set)model.getAdditionalCriterions()));
        }
        TemplateReportParametersHelper.toVMTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), mainVM.getRequestedParameters());
    }

    public static void toModelAirTicketsTemplateReportParameters(AirTicketsTemplateReportParametersPaneVM vm, AirTicketsTemplateReportParameters model) {
        MainAirTicketsTemplateReportParametersPaneVM mainVM = vm.getMain();
        ReportLaunchHelper.toModelPeriodParameters(vm.getPeriod(), mainVM.getDescription().getPeriodUse(), (BaseReportParameters)model);
        model.setAgent(mainVM.getAgent());
        model.setAgency(mainVM.getAgency());
        model.setBlankOwner(mainVM.getBlankOwner());
        model.setClient(mainVM.getClient());
        model.setSupplier(mainVM.getSupplier());
        model.setSalesPoint(mainVM.getSalesPoint());
        model.setSubagency(mainVM.getSubagency());
        LinkedHashSet<SearchCriterion> additionalCriterions = new LinkedHashSet<SearchCriterion>();
        if (mainVM.isHideVoidedTickets()) {
            if (!SearchQueryHelper.isExcludeVoidETickets(additionalCriterions)) {
                additionalCriterions.add(SearchQueryHelper.getExcludeVoidETicketsCriterion());
            }
        } else {
            additionalCriterions.remove(SearchQueryHelper.getExcludeVoidETicketsCriterion(additionalCriterions));
        }
        model.getAdditionalCriterions().clear();
        model.getAdditionalCriterions().addAll(additionalCriterions);
        TemplateReportParametersHelper.toModelTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), mainVM.getRequestedParameters());
    }

    public static void toVMAllProductsTemplateReportParameters(AllProductsTemplateReportParameters model, AllProductsTemplateReportParametersPaneVM vm) {
        MainAllProductsTemplateReportParametersPaneVM mainVM = vm.getMain();
        ReportLaunchHelper.toVMPeriodParameters(vm.getPeriod(), mainVM.getDescription().getPeriodUse(), model.getPeriodBegin(), model.getPeriodEnd());
        List params = mainVM.getDescription().getGlobalFilteringParameters();
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.AGENT)) {
            mainVM.setAgent(model.getAgent());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.AGENCY)) {
            mainVM.setAgency(model.getAgency());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.BLANK_OWNER)) {
            mainVM.setBlankOwner(model.getBlankOwner());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.CLIENT)) {
            mainVM.setClient(model.getClient());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.SUPPLIER)) {
            mainVM.setSupplier(model.getSupplier());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.SALES_POINT)) {
            mainVM.setSalesPoint(model.getSalesPoint());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.SUBAGENCY)) {
            mainVM.setSubagency(model.getSubagency());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.HIDE_VOID_ETICKETS)) {
            mainVM.setHideVoidedTickets(SearchQueryHelper.isExcludeVoidETickets((Set)model.getAdditionalCriterions()));
        }
        TemplateReportParametersHelper.toVMTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), vm.getMain().getRequestedParameters());
    }

    public static void toModelAllProductsTemplateReportParameters(AllProductsTemplateReportParametersPaneVM vm, AllProductsTemplateReportParameters model) {
        MainAllProductsTemplateReportParametersPaneVM mainVM = vm.getMain();
        ReportLaunchHelper.toModelPeriodParameters(vm.getPeriod(), mainVM.getDescription().getPeriodUse(), (BaseReportParameters)model);
        model.setAgent(mainVM.getAgent());
        model.setAgency(mainVM.getAgency());
        model.setBlankOwner(mainVM.getBlankOwner());
        model.setClient(mainVM.getClient());
        model.setSupplier(mainVM.getSupplier());
        model.setSalesPoint(mainVM.getSalesPoint());
        model.setSubagency(mainVM.getSubagency());
        LinkedHashSet<SearchCriterion> additionalCriterions = new LinkedHashSet<SearchCriterion>();
        if (mainVM.isHideVoidedTickets()) {
            if (!SearchQueryHelper.isExcludeVoidETickets(additionalCriterions)) {
                additionalCriterions.add(SearchQueryHelper.getExcludeVoidETicketsCriterion());
            }
        } else {
            additionalCriterions.remove(SearchQueryHelper.getExcludeVoidETicketsCriterion(additionalCriterions));
        }
        model.getAdditionalCriterions().clear();
        model.getAdditionalCriterions().addAll(additionalCriterions);
        TemplateReportParametersHelper.toModelTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), vm.getMain().getRequestedParameters());
    }

    public static void toVMInsuranceAccidentTemplateReportParameters(InsuranceAccidentTemplateReportParameters model, InsuranceAccidentTemplateReportParametersPaneVM vm) {
        MainInsuranceAccidentTemplateReportParametersPaneVM mainVM = vm.getMain();
        ReportLaunchHelper.toVMPeriodParameters(vm.getPeriod(), mainVM.getDescription().getPeriodUse(), model.getPeriodBegin(), model.getPeriodEnd());
        List params = mainVM.getDescription().getGlobalFilteringParameters();
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.AGENT)) {
            mainVM.setAgent(model.getAgent());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.AGENCY)) {
            mainVM.setAgency(model.getAgency());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.BLANK_OWNER)) {
            mainVM.setBlankOwner(model.getBlankOwner());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.CLIENT)) {
            mainVM.setClient(model.getClient());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.SUPPLIER)) {
            mainVM.setSupplier(model.getSupplier());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.SALES_POINT)) {
            mainVM.setSalesPoint(model.getSalesPoint());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.SUBAGENCY)) {
            mainVM.setSubagency(model.getSubagency());
        }
        if (params.contains(GeneralProductsTemplateReportFilteringParameters.HIDE_VOID_ETICKETS)) {
            mainVM.setHideVoidedTickets(SearchQueryHelper.isExcludeVoidETickets((Set)model.getAdditionalCriterions()));
        }
        TemplateReportParametersHelper.toVMTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), vm.getMain().getRequestedParameters());
    }

    public static void toModelInsuranceAccidentTemplateReportParameters(InsuranceAccidentTemplateReportParametersPaneVM vm, InsuranceAccidentTemplateReportParameters model) {
        MainInsuranceAccidentTemplateReportParametersPaneVM mainVM = vm.getMain();
        ReportLaunchHelper.toModelPeriodParameters(vm.getPeriod(), mainVM.getDescription().getPeriodUse(), (BaseReportParameters)model);
        model.setAgent(mainVM.getAgent());
        model.setAgency(mainVM.getAgency());
        model.setBlankOwner(mainVM.getBlankOwner());
        model.setClient(mainVM.getClient());
        model.setSupplier(mainVM.getSupplier());
        model.setSalesPoint(mainVM.getSalesPoint());
        model.setSubagency(mainVM.getSubagency());
        LinkedHashSet<SearchCriterion> additionalCriterions = new LinkedHashSet<SearchCriterion>();
        if (mainVM.isHideVoidedTickets()) {
            if (!SearchQueryHelper.isExcludeVoidETickets(additionalCriterions)) {
                additionalCriterions.add(SearchQueryHelper.getExcludeVoidETicketsCriterion());
            }
        } else {
            additionalCriterions.remove(SearchQueryHelper.getExcludeVoidETicketsCriterion(additionalCriterions));
        }
        model.getAdditionalCriterions().clear();
        model.getAdditionalCriterions().addAll(additionalCriterions);
        TemplateReportParametersHelper.toModelTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), vm.getMain().getRequestedParameters());
    }

    public static void toVMStockBlankTemplateReportParameters(StockBlankReportParameters model, StockBlankTemplateReportParametersPaneVM vm) {
        MainStockBlankTemplateReportParametersPaneVM mainVM = vm.getMain();
        ReportLaunchHelper.toVMPeriodParameters(vm.getPeriod(), mainVM.getDescription().getPeriodUse(), model.getPeriodBegin(), model.getPeriodEnd());
        List params = mainVM.getDescription().getGlobalFilteringParameters();
        if (params.contains(StockBlankReportFilteringParameters.BLANK_OWNER)) {
            mainVM.setBlankOwner(model.getBlankOwner());
        }
        if (params.contains(StockBlankReportFilteringParameters.LOCATION)) {
            mainVM.setLocation(model.getLocation());
        }
        if (params.contains(StockBlankReportFilteringParameters.WORKLOG)) {
            mainVM.setWorklog(model.getWorklog());
        }
        TemplateReportParametersHelper.toVMTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), vm.getMain().getRequestedParameters());
    }

    public static void toModelStockBlankTemplateReportParameters(StockBlankTemplateReportParametersPaneVM vm, StockBlankReportParameters model) {
        MainStockBlankTemplateReportParametersPaneVM mainVM = vm.getMain();
        ReportLaunchHelper.toModelPeriodParameters(vm.getPeriod(), mainVM.getDescription().getPeriodUse(), (BaseReportParameters)model);
        model.setBlankOwner(mainVM.getBlankOwner());
        model.setLocation(mainVM.getLocation());
        model.setWorklog(mainVM.getWorklog());
        TemplateReportParametersHelper.toModelTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), vm.getMain().getRequestedParameters());
    }

    public static void toVMIndexBasedTemplateReportParameters(IndexBasedTemplateReportParameters model, IndexBasedTemplateReportParametersPaneVM vm) {
        MainIndexBasedTemplateReportParametersPaneVM mainVM = vm.getMain();
        ReportLaunchHelper.toVMPeriodParameters(vm.getPeriod(), mainVM.getDescription().getPeriodUse(), model.getPeriodBegin(), model.getPeriodEnd());
        TemplateReportParametersHelper.toVMTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), vm.getMain().getRequestedParameters());
    }

    public static void toModelIndexBasedTemplateReportParameters(IndexBasedTemplateReportParametersPaneVM vm, IndexBasedTemplateReportParameters model) {
        MainIndexBasedTemplateReportParametersPaneVM mainVM = vm.getMain();
        ReportLaunchHelper.toModelPeriodParameters(vm.getPeriod(), mainVM.getDescription().getPeriodUse(), (BaseReportParameters)model);
        TemplateReportParametersHelper.toModelTemplateReportRequestedParameters(mainVM.getDescription().getRequestedParameters(), model.getRequestedParameters(), vm.getMain().getRequestedParameters());
    }

    public static void toVMMultipleFilesTemplateReportParameters(MultipleFilesTemplateReportParameters model, MultipleFilesTemplateReportParametersPaneVM vm) {
        ReportLaunchHelper.toVMPeriodParameters(vm.getPeriod(), vm.getMain().getDescription().getPeriodUse(), model.getPeriodBegin(), model.getPeriodEnd());
        TemplateReportParametersHelper.toVMTemplateReportRequestedParameters(vm.getMain().getRequestedParametersDescriptions(), model.getRequestedParameters(), vm.getMain().getRequestedParameters());
    }

    public static void toModelMultipleFilesTemplateReportParameters(MultipleFilesTemplateReportParametersPaneVM vm, MultipleFilesTemplateReportParameters model) {
        ReportLaunchHelper.toModelPeriodParameters(vm.getPeriod(), vm.getMain().getDescription().getPeriodUse(), (BaseReportParameters)model);
        TemplateReportParametersHelper.toModelTemplateReportRequestedParameters(vm.getMain().getRequestedParametersDescriptions(), model.getRequestedParameters(), vm.getMain().getRequestedParameters());
    }

    public static List<TemplateReportRequestedParameter> collectParametersForMultipleFilesReport(List<BaseSingleFileTemplateReportDescription> subDescriptions) {
        ArrayList<TemplateReportRequestedParameter> params = new ArrayList<TemplateReportRequestedParameter>();
        for (BaseSingleFileTemplateReportDescription d : subDescriptions) {
            if (d instanceof AgentTemplateReportDescription) {
                params.addAll(ReportLaunchHelper.createAgentParameters(((AgentTemplateReportDescription)d).getGlobalFilteringParameters()));
            } else if (d instanceof AirTicketsTemplateReportDescription) {
                params.addAll(ReportLaunchHelper.createGeneralParameters(((AirTicketsTemplateReportDescription)d).getGlobalFilteringParameters()));
            } else if (d instanceof AllProductsTemplateReportDescription) {
                params.addAll(ReportLaunchHelper.createGeneralParameters(((AllProductsTemplateReportDescription)d).getGlobalFilteringParameters()));
            } else if (d instanceof InsuranceAccidentTemplateReportDescription) {
                params.addAll(ReportLaunchHelper.createGeneralParameters(((InsuranceAccidentTemplateReportDescription)d).getGlobalFilteringParameters()));
            } else if (d instanceof StockBlankReportDescription) {
                params.addAll(ReportLaunchHelper.createStockBlankParameters(((StockBlankReportDescription)d).getGlobalFilteringParameters()));
            }
            params.addAll(d.getRequestedParameters());
        }
        return params;
    }

    private static List<TemplateReportRequestedParameter> createAgentParameters(List<GeneralAgentTemplateReportFilteringParameters> params) {
        ArrayList<TemplateReportRequestedParameter> result = new ArrayList<TemplateReportRequestedParameter>();
        for (GeneralAgentTemplateReportFilteringParameters item : params) {
            switch (item) {
                case SUBAGENCY: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), TemplateReportRequestedParameterBusinessType.SUBAGENCY, RequestedParameterCustomType.AGENCY, Organization.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case SALES_POINT: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), TemplateReportRequestedParameterBusinessType.SALES_POINT, RequestedParameterCustomType.SALES_POINT, SalesPoint.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case CASH: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), null, RequestedParameterCustomType.CASH, Cash.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case CASH_REGISTER: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), null, RequestedParameterCustomType.CASH_REGISTER, CashRegister.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case CASH_REGISTER_WORKPLACE: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), null, RequestedParameterCustomType.CASH_REGISTER_WORKPLACE, CashRegisterWorkplace.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case AGENT: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), TemplateReportRequestedParameterBusinessType.AGENT, RequestedParameterCustomType.AGENT, null, RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case WORKLOG: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), null, RequestedParameterCustomType.WORKLOG, Worklog.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
            }
        }
        return result;
    }

    private static List<TemplateReportRequestedParameter> createGeneralParameters(List<GeneralProductsTemplateReportFilteringParameters> params) {
        ArrayList<TemplateReportRequestedParameter> result = new ArrayList<TemplateReportRequestedParameter>();
        for (GeneralProductsTemplateReportFilteringParameters item : params) {
            switch (item) {
                case AGENCY: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), TemplateReportRequestedParameterBusinessType.AGENCY, RequestedParameterCustomType.AGENCY, Organization.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case AGENT: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), TemplateReportRequestedParameterBusinessType.AGENT, RequestedParameterCustomType.AGENT, Person.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case BLANK_OWNER: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), TemplateReportRequestedParameterBusinessType.BLANK_OWNER, RequestedParameterCustomType.BLANK_OWNER, Organization.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case CLIENT: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), TemplateReportRequestedParameterBusinessType.CLIENT, RequestedParameterCustomType.CLIENT, Organization.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case SALES_POINT: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), TemplateReportRequestedParameterBusinessType.SALES_POINT, RequestedParameterCustomType.SALES_POINT, SalesPoint.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case SUBAGENCY: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), TemplateReportRequestedParameterBusinessType.SUBAGENCY, RequestedParameterCustomType.AGENCY, Organization.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case SUPPLIER: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), TemplateReportRequestedParameterBusinessType.SUPPLIER, RequestedParameterCustomType.SUPPLIER, Organization.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case HIDE_VOID_ETICKETS: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), null, RequestedParameterCustomType.BOOLEAN, null, RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
            }
        }
        return result;
    }

    private static List<TemplateReportRequestedParameter> createStockBlankParameters(List<StockBlankReportFilteringParameters> params) {
        ArrayList<TemplateReportRequestedParameter> result = new ArrayList<TemplateReportRequestedParameter>();
        for (StockBlankReportFilteringParameters item : params) {
            switch (item) {
                case BLANK_OWNER: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), TemplateReportRequestedParameterBusinessType.BLANK_OWNER, RequestedParameterCustomType.BLANK_OWNER, Organization.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case WORKLOG: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), null, RequestedParameterCustomType.ENTITY, Worklog.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
                case LOCATION: {
                    result.add(ReportLaunchHelper.createParameter(item.name(), item.toString(), null, RequestedParameterCustomType.ENTITY, BaseProfile.class.getName(), RequestedParameterControlType.SINGLE_VALUE));
                    break;
                }
            }
        }
        return result;
    }

    private static TemplateReportRequestedParameter createParameter(String key, String name, TemplateReportRequestedParameterBusinessType businessType, RequestedParameterCustomType type, String subtype, RequestedParameterControlType controlType) {
        TemplateReportRequestedParameter result = new TemplateReportRequestedParameter();
        result.setBusinessType(businessType);
        result.setControlType(controlType);
        result.setKey(key);
        result.setName(name);
        result.setSubtype(subtype);
        result.setType(type);
        return result;
    }

    public static final class TripartiteReportParametersDateHelper {
        Integer month;
        Integer year;

        TripartiteReportParametersDateHelper(Date date) {
            if (date == null) {
                return;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.month = cal.get(2) + 1;
            this.year = cal.get(1);
        }

        public TripartiteReportParametersDateHelper(int aYear, int aMonth) {
            this.year = aYear;
            this.month = aMonth;
        }

        public TripartiteReportParametersDateHelper(Integer aYear, Integer aMonth) {
            this.year = aYear;
            this.month = aMonth;
        }

        public Date getBeginDate() {
            if (this.month == null || this.year == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.set(1, this.year);
            cal.set(2, this.month - 1);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            return cal.getTime();
        }

        public Date getEndDate() {
            if (this.month == null || this.year == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.set(1, this.year);
            cal.set(2, this.month - 1);
            cal.set(5, 1);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.add(2, 1);
            cal.add(13, -1);
            return cal.getTime();
        }
    }
}

