/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.handlers.launch;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiDictWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ValuesWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasValues;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.common.fx.reports.ReportKeys;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.ModelContract;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.standard.helpers.HttpHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.DownloadableData;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.RequestedParameterControlType;
import com.gridnine.xtrip.common.model.system.RequestedParameterCustomType;
import com.gridnine.xtrip.common.model.system.RequestedParameterValue;
import com.gridnine.xtrip.common.model.system.Worklog;
import com.gridnine.xtrip.common.reports.model.TemplateReportRequestedParameter;
import com.gridnine.xtrip.common.reports.model.TemplateReportRequestedParameterBusinessType;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javafx.scene.Node;

public class TemplateReportParametersHelper {
    private static Map<RequestedParameterCustomType, BiFunction<String, Boolean, GridCell<?>>> simpleWidgets = new EnumMap<RequestedParameterCustomType, BiFunction<String, Boolean, GridCell<?>>>(RequestedParameterCustomType.class){
        private static final long serialVersionUID = 1992075052539998870L;
        {
            this.put(RequestedParameterCustomType.BOOLEAN, (caption, isReadonly) -> {
                BooleanValueWidget widget = new BooleanValueWidget(false, isReadonly != null && isReadonly != false);
                return new GridCell(caption, (Node)widget);
            });
            this.put(RequestedParameterCustomType.STRING, (caption, isReadonly) -> {
                TextFieldWidget widget = new TextFieldWidget(isReadonly != null && isReadonly != false);
                return new GridCell(caption, (Node)widget);
            });
            this.put(RequestedParameterCustomType.NUMBER, (caption, isReadonly) -> {
                PriceValueWidget widget = new PriceValueWidget(isReadonly != null && isReadonly != false);
                return new GridCell(caption, (Node)widget);
            });
            this.put(RequestedParameterCustomType.DATE, (caption, isReadonly) -> {
                DateValueWidget widget = new DateValueWidget(isReadonly != null && isReadonly != false);
                return new GridCell(caption, (Node)widget);
            });
            this.put(RequestedParameterCustomType.DATETIME, (caption, isReadonly) -> {
                DateTimeValueWidget widget = new DateTimeValueWidget(isReadonly != null && isReadonly != false);
                return new GridCell(caption, (Node)widget);
            });
            this.put(RequestedParameterCustomType.FILE, (caption, isReadonly) -> {
                FileChooserWidget widget = new FileChooserWidget(isReadonly != null && isReadonly != false);
                return new GridCell(caption, (Node)widget);
            });
        }
    };
    private static BiFunction<TemplateReportRequestedParameter, Boolean, GridCell<?>> enumSingleWidget = (value, isReadonly) -> {
        ComboBoxWidget widget = new ComboBoxWidget(isReadonly != null && isReadonly != false);
        String caption = value.getName();
        String subtype = value.getSubtype();
        try {
            Class<?> enumClass = Class.forName(subtype);
            Method valuesMethod = enumClass.getMethod("values", new Class[0]);
            Object[] enumValues = (Object[])valuesMethod.invoke(null, new Object[0]);
            List<Object> valuesList = Arrays.asList(enumValues);
            widget.setItemsSupplier(() -> valuesList);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        return new GridCell(caption, (Node)widget);
    };
    private static BiFunction<TemplateReportRequestedParameter, Boolean, GridCell<?>> enumCollectionWidget = (value, isReadonly) -> {
        ValuesWidget widget = new ValuesWidget(isReadonly != null && isReadonly != false);
        String caption = value.getName();
        String subtype = value.getSubtype();
        try {
            Class<?> enumClass = Class.forName(subtype);
            Method valuesMethod = enumClass.getMethod("values", new Class[0]);
            Object[] enumValues = (Object[])valuesMethod.invoke(null, new Object[0]);
            List<Object> valuesList = Arrays.asList(enumValues);
            widget.setItemsSupplier(() -> valuesList);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        return new GridCell(caption, (Node)widget);
    };
    private static BiFunction<TemplateReportRequestedParameter, Boolean, GridCell<?>> dictSingleWidget = (value, isReadonly) -> {
        DictBoxWidget widget = null;
        String caption = value.getName();
        String subtype = value.getSubtype();
        try {
            Class<?> dictClass = Class.forName(subtype);
            widget = new DictBoxWidget(dictClass, isReadonly != null && isReadonly != false);
            widget.setFieldName(caption);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        return new GridCell(caption, widget);
    };
    private static BiFunction<TemplateReportRequestedParameter, Boolean, GridCell<?>> dictCollectionWidget = (value, isReadonly) -> {
        MultiDictWidget widget = new MultiDictWidget(null, isReadonly != null && isReadonly != false);
        String caption = value.getName();
        String subtype = value.getSubtype();
        try {
            Class<?> dictClass = Class.forName(subtype);
            widget = new MultiDictWidget(dictClass, isReadonly != null && isReadonly != false);
            widget.setFieldName(caption);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        return new GridCell(caption, (Node)widget);
    };
    private static Map<RequestedParameterCustomType, Supplier<GridCell<?>>> entitySingleWidgets = new EnumMap<RequestedParameterCustomType, Supplier<GridCell<?>>>(RequestedParameterCustomType.class){
        private static final long serialVersionUID = 1992075052539998871L;
        {
            this.put(RequestedParameterCustomType.AGENCY, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getAgencies()));
            this.put(RequestedParameterCustomType.BLANK_OWNER, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getBlankOwners()));
            this.put(RequestedParameterCustomType.SUPPLIER, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getSuppliers()));
            this.put(RequestedParameterCustomType.CLIENT, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getClients()));
            this.put(RequestedParameterCustomType.AGENT, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Person.class, ControllerInterceptorsHelper.getAgents()));
            this.put(RequestedParameterCustomType.SALES_POINT, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(SalesPoint.class, ControllerInterceptorsHelper.getSalesPoints()));
            this.put(RequestedParameterCustomType.CASH, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Cash.class, ControllerInterceptorsHelper.getCashes()));
            this.put(RequestedParameterCustomType.CASH_REGISTER, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(CashRegister.class, ControllerInterceptorsHelper.getCashRegisters()));
            this.put(RequestedParameterCustomType.CASH_REGISTER_WORKPLACE, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(CashRegisterWorkplace.class, ControllerInterceptorsHelper.getCashRegisterWorkplaces()));
            this.put(RequestedParameterCustomType.WORKLOG, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Worklog.class, ControllerInterceptorsHelper.getWorklogs()));
            this.put(RequestedParameterCustomType.LOCATION, () -> TemplateReportParametersHelper.createSingleCellUsingSupplier(BaseProfile.class, ControllerInterceptorsHelper.getProfileMulti()));
        }
    };
    private static Map<TemplateReportRequestedParameterBusinessType, Supplier<GridCell<?>>> businessTypeEntitySingleWidgets = new EnumMap<TemplateReportRequestedParameterBusinessType, Supplier<GridCell<?>>>(TemplateReportRequestedParameterBusinessType.class){
        private static final long serialVersionUID = 1992075052539998872L;
        {
            this.put(TemplateReportRequestedParameterBusinessType.AGENCY, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getAgencies()));
            this.put(TemplateReportRequestedParameterBusinessType.SUBAGENCY, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getAgencies()));
            this.put(TemplateReportRequestedParameterBusinessType.CLIENT, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getClients()));
            this.put(TemplateReportRequestedParameterBusinessType.SALES_POINT, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(SalesPoint.class, ControllerInterceptorsHelper.getSalesPoints()));
            this.put(TemplateReportRequestedParameterBusinessType.AGENT, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Person.class, ControllerInterceptorsHelper.getAgents()));
            this.put(TemplateReportRequestedParameterBusinessType.BLANK_OWNER, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getBlankOwners()));
            this.put(TemplateReportRequestedParameterBusinessType.SUPPLIER, () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getSuppliers()));
        }
    };
    private static Map<String, Supplier<GridCell<?>>> freeFormatSingleWidgets = new HashMap<String, Supplier<GridCell<?>>>(){
        private static final long serialVersionUID = 1992075052539998873L;
        {
            this.put(ReportKeys.CLIENT.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getClients()));
            this.put(ReportKeys.CLIENTS.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Person.class, ControllerInterceptorsHelper.getPersonsSortByCode()));
            this.put(ReportKeys.USER.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Person.class, ControllerInterceptorsHelper.getPersonsSortByCode()));
            this.put(ReportKeys.AGENCY.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getAgencies()));
            this.put(ReportKeys.SUBAGENTS.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getAgencies()));
            this.put(ReportKeys.AGENTS.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Person.class, ControllerInterceptorsHelper.getAgents()));
            this.put(ReportKeys.HOLDING.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Holding.class, ControllerInterceptorsHelper.getHoldings()));
            this.put(ReportKeys.CONTRACT.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Contract.class, ControllerInterceptorsHelper.getContracts()));
            this.put(ReportKeys.employee.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Person.class, ControllerInterceptorsHelper.getPersonsSortByCode()));
            this.put(ReportKeys.director.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Person.class, ControllerInterceptorsHelper.getPersonsSortByCode()));
            this.put(ReportKeys.responsible.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Person.class, ControllerInterceptorsHelper.getPersonsSortByCode()));
            this.put(ReportKeys.report_author.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Person.class, ControllerInterceptorsHelper.getPersonsSortByCode()));
            this.put(ReportKeys.accountant.name(), () -> TemplateReportParametersHelper.createSingleCellUsingIndex(Person.class, ControllerInterceptorsHelper.getPersonsSortByCode()));
        }
    };
    private static Map<String, BiFunction<String, Boolean, GridCell<?>>> customSingleWidgets = new HashMap<String, BiFunction<String, Boolean, GridCell<?>>>(){
        private static final long serialVersionUID = 1992075052539998874L;
        {
            this.put("GDS_ACCOUNT", (caption, isReadonly) -> {
                EntityBoxWidget widget = null;
                try {
                    Class<?> gdsAccountClass = Class.forName("com.gridnine.xtrip.common.gds.model.BaseGdsAccount");
                    Class<?> gdsIndexHandlerClass = Class.forName("com.gridnine.xtrip.client.fx.gds.entity.index.GdsAccountIndexHandler");
                    Method createListParameters = gdsIndexHandlerClass.getMethod("createListParameters", new Class[0]);
                    IndexListParameters listParameters = (IndexListParameters)createListParameters.invoke(gdsIndexHandlerClass.newInstance(), new Object[0]);
                    widget = new EntityBoxWidget(gdsAccountClass, isReadonly != null && isReadonly != false);
                    widget.setListParametersSupplier(() -> listParameters);
                    widget.setFieldName(caption);
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
                return new GridCell(caption, widget);
            });
        }
    };
    private static Map<String, BiFunction<String, Boolean, GridCell<?>>> customCollectionWidgets = new HashMap<String, BiFunction<String, Boolean, GridCell<?>>>(){
        private static final long serialVersionUID = 1992075052539998875L;
        {
            this.put("GDS_ACCOUNT", (caption, isReadonly) -> {
                MultiEntityWidget widget = null;
                try {
                    Class<?> gdsAccountClass = Class.forName("com.gridnine.xtrip.common.gds.model.BaseGdsAccount");
                    Class<?> gdsIndexHandlerClass = Class.forName("com.gridnine.xtrip.client.fx.gds.entity.index.GdsAccountIndexHandler");
                    Method createListParameters = gdsIndexHandlerClass.getMethod("createListParameters", new Class[0]);
                    IndexListParameters listParameters = (IndexListParameters)createListParameters.invoke(gdsIndexHandlerClass.newInstance(), new Object[0]);
                    widget = new MultiEntityWidget(gdsAccountClass, isReadonly != null && isReadonly != false);
                    widget.setListParametersSupplier(() -> listParameters);
                    widget.setFieldName(caption);
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
                return new GridCell(caption, widget);
            });
        }
    };
    private static Map<String, Supplier<GridCell<?>>> freeFormatCollectionWidgets = new HashMap<String, Supplier<GridCell<?>>>(){
        private static final long serialVersionUID = 1992075052539998876L;
        {
            this.put("CLIENT", () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getClients()));
            this.put("CLIENTS", () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Person.class, ControllerInterceptorsHelper.getPersonsSortByCode()));
            this.put("AGENCY", () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getAgencies()));
            this.put("USER", () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Person.class, ControllerInterceptorsHelper.getPersonsSortByCode()));
            this.put("SUBAGENTS", () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getAgencies()));
            this.put("AGENTS", () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Person.class, ControllerInterceptorsHelper.getAgents()));
            this.put("HOLDING", () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Holding.class, ControllerInterceptorsHelper.getHoldings()));
            this.put("CONTRACT", () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Contract.class, ControllerInterceptorsHelper.getEnabledContracts()));
            this.put("employee", () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Person.class, ControllerInterceptorsHelper.getPersonsSortByCode()));
            this.put(ReportKeys.CONTRACT_RULES_GROUP.name(), () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(ModelContract.class, ControllerInterceptorsHelper.getModelContract()));
        }
    };
    private static Map<TemplateReportRequestedParameterBusinessType, Supplier<GridCell<?>>> businessTypeEntityCollectionWidgets = new EnumMap<TemplateReportRequestedParameterBusinessType, Supplier<GridCell<?>>>(TemplateReportRequestedParameterBusinessType.class){
        private static final long serialVersionUID = 1992075052539998877L;
        {
            this.put(TemplateReportRequestedParameterBusinessType.AGENCY, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getAgencies()));
            this.put(TemplateReportRequestedParameterBusinessType.SUBAGENCY, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getAgencies()));
            this.put(TemplateReportRequestedParameterBusinessType.SALES_POINT, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(SalesPoint.class, ControllerInterceptorsHelper.getSalesPoints()));
            this.put(TemplateReportRequestedParameterBusinessType.CLIENT, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getClients()));
            this.put(TemplateReportRequestedParameterBusinessType.AGENT, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Person.class, ControllerInterceptorsHelper.getAgents()));
            this.put(TemplateReportRequestedParameterBusinessType.BLANK_OWNER, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getBlankOwners()));
            this.put(TemplateReportRequestedParameterBusinessType.SUPPLIER, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getSuppliers()));
        }
    };
    private static Map<RequestedParameterCustomType, Supplier<GridCell<?>>> entityCollectionWidgets = new EnumMap<RequestedParameterCustomType, Supplier<GridCell<?>>>(RequestedParameterCustomType.class){
        private static final long serialVersionUID = 1992075052539998878L;
        {
            this.put(RequestedParameterCustomType.AGENCY, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getAgencies()));
            this.put(RequestedParameterCustomType.BLANK_OWNER, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getBlankOwners()));
            this.put(RequestedParameterCustomType.SUPPLIER, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getSuppliers()));
            this.put(RequestedParameterCustomType.CLIENT, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Organization.class, ControllerInterceptorsHelper.getClients()));
            this.put(RequestedParameterCustomType.AGENT, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(Person.class, ControllerInterceptorsHelper.getAgents()));
            this.put(RequestedParameterCustomType.SALES_POINT, () -> TemplateReportParametersHelper.createCollectionCellUsingIndex(SalesPoint.class, ControllerInterceptorsHelper.getSalesPoints()));
        }
    };

    static void toVMTemplateReportRequestedParameters(List<TemplateReportRequestedParameter> requestedParameters, List<RequestedParameterValue> modelRequestedParameters, LinkedHashMap<String, Object> vmRequestedParameters) {
        for (TemplateReportRequestedParameter param : requestedParameters) {
            TemplateReportParametersHelper.toVMRequestedParameter(param, modelRequestedParameters, vmRequestedParameters);
        }
    }

    static void toModelTemplateReportRequestedParameters(List<TemplateReportRequestedParameter> requestedParameters, List<RequestedParameterValue> modelRequestedParameters, LinkedHashMap<String, Object> vmRequestedParameters) {
        for (TemplateReportRequestedParameter param : requestedParameters) {
            TemplateReportParametersHelper.toModelRequestedParameter(param, modelRequestedParameters, vmRequestedParameters);
        }
    }

    private static void toVMRequestedParameter(TemplateReportRequestedParameter param, List<RequestedParameterValue> modelRequestedParameters, LinkedHashMap<String, Object> vmRequestedParameters) {
        Object value = TemplateReportParametersHelper.getParameter(modelRequestedParameters, param.getKey());
        if (value == null) {
            return;
        }
        Node widget = ((GridCell)vmRequestedParameters.get(param.getKey())).getPayload();
        boolean valueIsCollection = value instanceof Collection;
        if (widget instanceof HasValue) {
            if (value instanceof Date) {
                ((HasValue)widget).valueProperty().set((Object)DateUtils.asLocalDate((Date)((Date)value)));
            } else {
                ((HasValue)widget).valueProperty().set(value);
            }
        } else if (widget instanceof HasValues) {
            if (valueIsCollection) {
                ((HasValues)widget).getValues().setAll((Collection)value);
            } else {
                ((HasValues)widget).getValues().add(value);
            }
        }
    }

    private static void toModelRequestedParameter(TemplateReportRequestedParameter param, List<RequestedParameterValue> modelRequestedParameters, LinkedHashMap<String, Object> vmRequestedParameters) {
        FileChooserWidget fileChooserWidget;
        if (!vmRequestedParameters.containsKey(param.getKey())) {
            return;
        }
        Node widget = ((GridCell)vmRequestedParameters.get(param.getKey())).getPayload();
        if (widget instanceof HasValue) {
            Object value = ((HasValue)widget).valueProperty().get();
            if (value instanceof LocalDate) {
                TemplateReportParametersHelper.setParameter(modelRequestedParameters, param.getKey(), DateUtils.asDate((LocalDate)((LocalDate)value)));
            } else {
                TemplateReportParametersHelper.setParameter(modelRequestedParameters, param.getKey(), value);
            }
        } else if (widget instanceof HasValues) {
            TemplateReportParametersHelper.setParameter(modelRequestedParameters, param.getKey(), new ArrayList(((HasValues)widget).getValues()));
        } else if (widget instanceof FileChooserWidget && (fileChooserWidget = (FileChooserWidget)widget).getMode() == FileChooserWidget.ChoosingMode.OPEN_SINGLE && !fileChooserWidget.getFiles().isEmpty()) {
            File file = (File)fileChooserWidget.getFiles().get(0);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 FileInputStream strm = new FileInputStream(file);){
                IoUtil.copyStream((InputStream)strm, (OutputStream)baos, (int)256);
                DownloadableData result = new DownloadableData();
                result.setFileName(file.getName());
                result.setContent(new BinaryData());
                result.getContent().setData(baos.toByteArray());
                result.getContent().setContentType(HttpHelper.detectContentType((String)file.getName()));
                TemplateReportParametersHelper.setParameter(modelRequestedParameters, param.getKey(), result);
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
    }

    public static void createRequestedParameters(List<TemplateReportRequestedParameter> requestedParameters, LinkedHashMap<String, Object> paramsMap, Boolean isReadonly) {
        for (TemplateReportRequestedParameter value : requestedParameters) {
            boolean singleValueRequired = value.getControlType() == null || value.getControlType().equals((Object)RequestedParameterControlType.SINGLE_VALUE);
            try {
                GridCell<?> cell = singleValueRequired ? TemplateReportParametersHelper.createSingleValueCell(value, isReadonly) : TemplateReportParametersHelper.createCollectionValueCell(value, isReadonly);
                if (cell == null) continue;
                paramsMap.put(value.getKey(), cell);
            }
            catch (NullPointerException e) {
                ErrorHandler.handle((Throwable)Xeption.forDeveloper((String)TemplateReportParametersHelper.createWidgetCreationErrorMessage(value), (Object[])new Object[0]));
            }
        }
    }

    private static GridCell<?> createSingleValueCell(TemplateReportRequestedParameter value, Boolean isReadonly) {
        GridCell<?> cell = null;
        RequestedParameterCustomType valueType = value.getType();
        String caption = value.getName();
        boolean isSimpleCell = simpleWidgets.containsKey(valueType);
        boolean isEntityCell = entitySingleWidgets.containsKey(valueType);
        boolean isEnumCell = valueType.equals((Object)RequestedParameterCustomType.ENUM);
        boolean isDictionaryCell = valueType.equals((Object)RequestedParameterCustomType.DICTIONARY);
        boolean isNonSpecifiedCell = valueType.equals((Object)RequestedParameterCustomType.ENTITY);
        if (isSimpleCell) {
            cell = simpleWidgets.get(valueType).apply(caption, isReadonly);
        } else if (isEntityCell) {
            cell = entitySingleWidgets.get(valueType).get();
            ((EntityBoxWidget)cell.getPayload()).getViewState().setReadonly(isReadonly.booleanValue());
            cell.setCaption(caption);
        } else if (isEnumCell) {
            cell = enumSingleWidget.apply(value, isReadonly);
        } else if (isDictionaryCell) {
            cell = dictSingleWidget.apply(value, isReadonly);
        } else if (isNonSpecifiedCell) {
            cell = TemplateReportParametersHelper.createNonSpecifiedSingleCell(value, isReadonly);
        }
        return cell;
    }

    private static GridCell<?> createCollectionValueCell(TemplateReportRequestedParameter value, Boolean isReadonly) {
        GridCell<?> cell = null;
        RequestedParameterCustomType valueType = value.getType();
        String caption = value.getName();
        boolean isEntityCell = entityCollectionWidgets.containsKey(valueType);
        boolean isEnumCell = valueType.equals((Object)RequestedParameterCustomType.ENUM);
        boolean isDictionaryCell = valueType.equals((Object)RequestedParameterCustomType.DICTIONARY);
        boolean isNonSpecifiedCell = valueType.equals((Object)RequestedParameterCustomType.ENTITY);
        if (isEntityCell) {
            cell = entityCollectionWidgets.get(valueType).get();
            ((MultiEntityWidget)cell.getPayload()).getViewState().setReadonly(isReadonly.booleanValue());
            ((MultiEntityWidget)cell.getPayload()).setFieldName(caption);
            cell.setCaption(caption);
        } else if (isEnumCell) {
            cell = enumCollectionWidget.apply(value, isReadonly);
        } else if (isDictionaryCell) {
            cell = dictCollectionWidget.apply(value, isReadonly);
        } else if (isNonSpecifiedCell) {
            cell = TemplateReportParametersHelper.createNonSpecifiedCollectionCell(value, isReadonly);
        }
        return cell;
    }

    private static GridCell<?> createNonSpecifiedCollectionCell(TemplateReportRequestedParameter value, Boolean isReadonly) {
        if (value.getBusinessType() != null) {
            GridCell<?> result = businessTypeEntityCollectionWidgets.get(value.getBusinessType()).get();
            ((MultiEntityWidget)result.getPayload()).getViewState().setReadonly(isReadonly.booleanValue());
            result.setCaption(value.getBusinessType().toString());
            return result;
        }
        if (freeFormatCollectionWidgets.containsKey(value.getKey())) {
            GridCell<?> result = freeFormatCollectionWidgets.get(value.getKey()).get();
            ((MultiEntityWidget)result.getPayload()).getViewState().setReadonly(isReadonly.booleanValue());
            result.setCaption(value.getName());
            return result;
        }
        if (customCollectionWidgets.containsKey(value.getKey())) {
            return customCollectionWidgets.get(value.getKey()).apply(value.getName(), isReadonly);
        }
        try {
            MultiEntityWidget widget = new MultiEntityWidget(XSHelper.getClass((String)value.getSubtype()), isReadonly.booleanValue());
            widget.setFieldName(value.getName());
            return new GridCell(value.getName(), (Node)widget);
        }
        catch (ClassNotFoundException cnfe) {
            Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 {0}, \u043a\u043b\u044e\u0447={1}, \u0442\u0438\u043f={2}", (Object[])new Object[]{value.getName(), value.getKey(), value.getSubtype()})});
            return null;
        }
    }

    private static GridCell<?> createNonSpecifiedSingleCell(TemplateReportRequestedParameter value, Boolean isReadonly) {
        GridCell<?> cell;
        String userDefinedKey = value.getKey();
        TemplateReportRequestedParameterBusinessType businessType = value.getBusinessType();
        String caption = value.getName();
        boolean isBusinessTypeReferencedCell = businessType != null;
        boolean isFreeFormatCell = freeFormatSingleWidgets.containsKey(userDefinedKey);
        if (isBusinessTypeReferencedCell) {
            cell = businessTypeEntitySingleWidgets.get(businessType).get();
            ((EntityBoxWidget)cell.getPayload()).getViewState().setReadonly(isReadonly.booleanValue());
            cell.setCaption(businessType.toString());
        } else if (isFreeFormatCell) {
            cell = freeFormatSingleWidgets.get(userDefinedKey).get();
            ((EntityBoxWidget)cell.getPayload()).getViewState().setReadonly(isReadonly.booleanValue());
            cell.setCaption(caption);
        } else {
            cell = customSingleWidgets.get(userDefinedKey).apply(caption, isReadonly);
        }
        return cell;
    }

    private static String createWidgetCreationErrorMessage(TemplateReportRequestedParameter value) {
        return "Failed to create widget with following parameters: " + String.format("businessType = %s, ", value.getBusinessType()) + String.format("name = %s, ", value.getName()) + String.format("key = %s, ", value.getKey()) + String.format("type = %s, ", value.getType()) + String.format("subtype = %s, ", value.getSubtype()) + String.format("controlType = %s, ", value.getControlType());
    }

    private static <V> V getParameter(List<RequestedParameterValue> paramsMap, String key) {
        for (RequestedParameterValue param : paramsMap) {
            if (!TextUtil.isSame((String)key, (String)param.getKey())) continue;
            return (V)param.getValue();
        }
        return null;
    }

    private static void setParameter(List<RequestedParameterValue> paramsMap, String key, Object value) {
        boolean found = false;
        for (RequestedParameterValue param : paramsMap) {
            if (!TextUtil.isSame((String)key, (String)param.getKey())) continue;
            param.setValue(value);
            found = true;
            break;
        }
        if (!found) {
            RequestedParameterValue param = new RequestedParameterValue();
            param.setKey(key);
            param.setValue(value);
            paramsMap.add(param);
        }
    }

    private static <T extends BaseEntity, I extends EntityIndex<T>> GridCell createSingleCellUsingIndex(Class<T> entity, IndexListParameters<T, I> index) {
        EntityBoxWidget widget = new EntityBoxWidget(entity, false);
        widget.setListParametersSupplier(() -> index);
        return new GridCell((Node)widget);
    }

    private static <T extends BaseEntity> GridCell createSingleCellUsingSupplier(Class<T> entity, MultiSupplier<IndexListParameters<T, ?>> supplier) {
        EntityBoxWidget widget = new EntityBoxWidget(entity, false);
        widget.setListParametersSupplier(supplier);
        return new GridCell((Node)widget);
    }

    private static <T extends BaseEntity, I extends EntityIndex<T>> GridCell createCollectionCellUsingIndex(Class<T> entity, IndexListParameters<T, I> index) {
        MultiEntityWidget widget = new MultiEntityWidget(entity, false);
        widget.setListParametersSupplier(() -> index);
        return new GridCell((Node)widget);
    }

    private static <T extends BaseEntity> GridCell createCollectionCellUsingSupplier(Class<T> entity, MultiSupplier<IndexListParameters<T, ?>> supplier) {
        MultiEntityWidget widget = new MultiEntityWidget(entity, false);
        widget.setListParametersSupplier(supplier);
        return new GridCell((Node)widget);
    }
}

