/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.reports.handlers.launch.ReportLaunchHelper;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.manager.DocumentsCompactPane;
import com.gridnine.xtrip.client.fx.reports.manager.DocumentsFullPane;
import com.gridnine.xtrip.client.fx.standard.tasks.EntityDeleteTask;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

enum DocumentsActions implements TileAction<DocumentsCompactPane, DocumentsFullPane>
{
    EDIT{

        public String getName(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return Messages.Edit;
        }

        public String getDescription(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return Messages.Edit_selected_docs;
        }

        public boolean isEnabled(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return !((DocumentsFullPane)tile.getFullNode()).getSelectedItems().isEmpty();
        }

        public void execute(Control source, Tile<DocumentsCompactPane, DocumentsFullPane> tile, boolean alt) {
            for (EntityIndex idx : ((DocumentsFullPane)tile.getFullNode()).getSelectedItems()) {
                RootEntityEditingService.navigateTo((EntityReference)idx.getSource());
            }
        }
    }
    ,
    DELETE{

        public String getName(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return Messages.Delete;
        }

        public String getDescription(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return Messages.Delete_selected_docs;
        }

        public boolean isEnabled(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return !((DocumentsFullPane)tile.getFullNode()).getSelectedItems().isEmpty();
        }

        public void execute(Control source, Tile<DocumentsCompactPane, DocumentsFullPane> tile, boolean alt) {
            Dialog.confirm((Node)source, (String)Messages.Delete_selected_docs2, null, (String)Messages.Delete, () -> Notifications.get().enqueueAsyncTask((ClientTask)new EntityDeleteTask((Collection)((DocumentsFullPane)tile.getFullNode()).getSelectedItems().stream().map(EntityIndex::getSource).collect(Collectors.toList()))), null);
        }
    }
    ,
    LAUNCH{

        public String getName(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return Messages.Recreate;
        }

        public String getDescription(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return Messages.Run_forming_report;
        }

        public boolean isEnabled(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return ((DocumentsFullPane)tile.getFullNode()).getSelectedItems().size() == 1;
        }

        public void execute(Control source, Tile<DocumentsCompactPane, DocumentsFullPane> tile, boolean alt) {
            EntityReference documentRef = ((EntityIndex)((DocumentsFullPane)tile.getFullNode()).getSelectedItems().get(0)).getSource();
            Notifications.get().submitTask(() -> {
                ServiceInvocationContext sic = ServiceInvocationContext.get();
                EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
                EntityContainer documentCtr = entityService.load(sic, documentRef);
                if (documentCtr == null) {
                    ErrorHandler.handle((Throwable)Xeption.forEndUser((String)Messages.Doc_with_report_data_not_found, (Object[])new Object[0]));
                    return;
                }
                FxUtil.submitToFxThread(() -> ReportLaunchHelper.relaunch((Node)source, documentCtr));
            }, Messages.Loading_report_parameters);
        }
    }
    ,
    CLEANUP{

        public String getName(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return Messages.Clean;
        }

        public String getDescription(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return Messages.Delete_old_docs_all_categories;
        }

        public boolean isEnabled(Tile<DocumentsCompactPane, DocumentsFullPane> tile) {
            return true;
        }

        public void execute(Control source, Tile<DocumentsCompactPane, DocumentsFullPane> tile, boolean alt) {
            StandardNotifications.NOT_IMPLEMENTED.show(null);
        }
    };


    public double getWeight() {
        return this.ordinal();
    }
}

