/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.reports.api.ReportDocumentHandler;
import com.gridnine.xtrip.client.fx.reports.api.ReportHandlersSupplier;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.reports.model.BaseReportDocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.scene.layout.StackPane;

class DocumentsFullPane
extends StackPane {
    private final ObservableMutex mutex;
    private TableView<EntityIndex<BaseReportDocument>> tableView;
    private final ObservableList<EntityIndex<BaseReportDocument>> selectedItems = FXCollections.observableArrayList();
    private final ObservableList<EntityIndex<BaseReportDocument>> readonlySelectedItems = FXCollections.unmodifiableObservableList(this.selectedItems);
    private final InvalidationListener selectionListener = src -> {
        if (this.tableView == null) {
            this.selectedItems.clear();
        } else {
            this.selectedItems.setAll((Collection)this.tableView.getSelectionModel().getSelectedItems());
        }
    };

    DocumentsFullPane(ObservableMutex mtx) {
        this.mutex = mtx;
    }

    ObservableList<EntityIndex<BaseReportDocument>> getSelectedItems() {
        return this.readonlySelectedItems;
    }

    protected void updateTableView(TableView<EntityIndex<BaseReportDocument>> value) {
        if (this.tableView != null) {
            this.tableView.getSelectionModel().getSelectedItems().removeListener(this.selectionListener);
        }
        this.tableView = value;
        this.tableView.getSelectionModel().getSelectedItems().addListener(this.selectionListener);
        this.selectedItems.clear();
    }

    void init() {
        final ArrayList handlers = new ArrayList();
        for (ReportHandlersSupplier supplier : ClientRegistry.get().allOf(ReportHandlersSupplier.TYPE).values()) {
            handlers.addAll(supplier.getDocumentHandlers());
        }
        FxUtil.submitToFxThread(() -> {
            IndexListPane<BaseReportDocument, EntityIndex<BaseReportDocument>> newListPane = new IndexListPane<BaseReportDocument, EntityIndex<BaseReportDocument>>(this.mutex, (MultiSupplier)new MultiSupplier<IndexListPaneConfiguration<BaseReportDocument, EntityIndex<BaseReportDocument>>>(){

                public String getDisplayName(int idx) {
                    return MetaRegistryHelper.getDisplayName(((ReportDocumentHandler)handlers.get(idx)).getIndexType());
                }

                public int count() {
                    return handlers.size();
                }

                public IndexListPaneConfiguration<BaseReportDocument, EntityIndex<BaseReportDocument>> get(int idx) {
                    IndexListParameters parameters = EntityIndexHandler.forIndexClass(((ReportDocumentHandler)handlers.get(idx)).getIndexType()).createListParameters();
                    IndexListPaneConfiguration result = new IndexListPaneConfiguration(parameters.getIndexType());
                    result.setSelectionMode(SelectionMode.MULTIPLE);
                    result.setPatternSearchEnabled(true);
                    result.setActionsEnabled(false);
                    result.setLimit(parameters.getLimit());
                    result.applyParameters(parameters);
                    return result;
                }
            }){

                protected void newConfigurationPopulated() {
                    this.getTableView().getColumns().add((Object)TableColumnSettings.createActionColumn(idx -> {
                        if (idx == null) {
                            return;
                        }
                        RootEntityEditingService.navigateTo((EntityReference)idx.getSource());
                    }));
                    DocumentsFullPane.this.updateTableView((TableView<EntityIndex<BaseReportDocument>>)this.getTableView());
                }

                protected void executeDefaultAction(Control source) {
                    List selected = this.getSelectedItems();
                    if (!selected.isEmpty()) {
                        RootEntityEditingService.navigateTo((EntityReference)((EntityIndex)selected.get(0)).getSource());
                    }
                }
            };
            if (!this.getChildren().isEmpty()) {
                EventBus.get().unsubscribe((Object)((IndexListPane)this.getChildren().get(0)).getModificationEventHandler());
            }
            this.getChildren().setAll((Object[])new Node[]{newListPane});
            EventBus.get().subscribe(EntityModificationEvent.TYPE, newListPane.getModificationEventHandler());
        });
    }
}

