/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.reports.manager;

import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.settings.SettingsModificationEvent;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchEvent;
import com.gridnine.xtrip.client.fx.reports.api.ReportLaunchHandler;
import com.gridnine.xtrip.client.fx.reports.l10n.Messages;
import com.gridnine.xtrip.client.fx.reports.manager.LaunchersCompactPane;
import com.gridnine.xtrip.client.fx.reports.manager.LaunchersFullPane;
import java.util.function.Consumer;
import javafx.scene.Node;

class LaunchersTile
extends Tile<LaunchersCompactPane, LaunchersFullPane> {
    private final Consumer<SettingsModificationEvent> settingsModificationEventListener;

    LaunchersTile() {
        super("launchers", Messages.Creating_new_report, (Node)new LaunchersCompactPane(), (Node)new LaunchersFullPane());
        ((LaunchersCompactPane)this.getCompactNode()).setLauncher(handler -> this.launch(this.getCompactNode(), (ReportLaunchHandler)handler));
        ((LaunchersFullPane)this.getFullNode()).setLauncher(handler -> this.launch(this.getFullNode(), (ReportLaunchHandler)handler));
        this.settingsModificationEventListener = evt -> {
            try {
                ((LaunchersCompactPane)this.getCompactNode()).loadHandlers();
                ((LaunchersFullPane)this.getFullNode()).loadHandlers();
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        };
        EventBus.get().subscribe(SettingsModificationEvent.TYPE, this.settingsModificationEventListener);
    }

    private void launch(Node node, ReportLaunchHandler handler) {
        handler.launch(node, () -> EventBus.get().publishAsync((Event)new ReportLaunchEvent(handler)));
    }

    void init() {
        try {
            ((LaunchersCompactPane)this.getCompactNode()).loadHandlers();
            ((LaunchersFullPane)this.getFullNode()).loadHandlers();
            FxUtil.waitForFxThread(() -> ((LaunchersFullPane)this.getFullNode()).initialized.set(true));
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    void dispose() {
        ((LaunchersCompactPane)this.getCompactNode()).dispose();
    }
}

